/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.reactor;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.reactor.NuclearExplosionEntity;

public class NuclearExplosionBlock
extends Block
implements EntityBlock {
    private final int size;

    public NuclearExplosionBlock(BlockBehaviour.Properties settings, int size) {
        super(settings);
        this.size = size;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new NuclearExplosionEntity(pos, state, this.size);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof BlockEntityTicker) {
                BlockEntityTicker ticker = (BlockEntityTicker)blockEntity;
                ticker.tick(world1, pos, state1, blockEntity);
            }
        };
    }
}

