/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import java.util.HashMap;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.block.FrameInteractionBlock;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.Geometry;

public abstract class FrameInteractionBlockEntity
extends NetworkedBlockEntity {
    private static final int MAX_SEARCH_LENGTH = Oritech.CONFIG.processingMachines.machineFrameMaxLength();
    private static final HashMap<Vec3i, HashMap<Vec3i, Vec3i>> occupiedAreas = new HashMap();
    @SyncField(value={SyncType.INITIAL, SyncType.SPARSE_TICK})
    private BlockPos areaMin;
    @SyncField(value={SyncType.INITIAL, SyncType.SPARSE_TICK})
    private BlockPos areaMax;
    @SyncField(value={SyncType.INITIAL, SyncType.SPARSE_TICK})
    public boolean disabledViaRedstone;
    @SyncField
    private BlockPos currentTarget;
    @SyncField
    private BlockPos lastTarget;
    @SyncField
    private boolean moving;
    @SyncField
    private float currentProgress;
    private Vec3i currentDirection = new Vec3i(1, 0, 0);
    public long lastWorkedAt;
    public Vec3 lastRenderedPosition = new Vec3(0.0, 0.0, 0.0);

    public FrameInteractionBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean tryFindFrame() {
        Oritech.LOGGER.debug("searching machine frame");
        Direction facing = this.getFacing();
        Vec3i backRelative = new Vec3i(this.getFrameOffset(), 0, 0);
        BlockPos searchStart = (BlockPos)Geometry.offsetToWorldPosition(facing, backRelative, (Vec3i)this.worldPosition);
        BlockPos endRightFront = this.searchFrameLine(searchStart, Geometry.getRight(facing));
        if (endRightFront.equals((Object)BlockPos.ZERO)) {
            this.highlightBlock(searchStart);
            return false;
        }
        BlockPos endRightBack = this.searchFrameLine(endRightFront, Geometry.getBackward(facing));
        if (endRightBack.equals((Object)endRightFront)) {
            this.highlightBlock(endRightFront.offset(Geometry.getRight(facing)));
            this.highlightBlock(endRightFront.offset(Geometry.getBackward(facing)));
            return false;
        }
        BlockPos endLeftBack = this.searchFrameLine(endRightBack, Geometry.getLeft(facing));
        if (endLeftBack.equals((Object)endRightBack)) {
            this.highlightBlock(endRightBack.offset(Geometry.getBackward(facing)));
            this.highlightBlock(endRightBack.offset(Geometry.getLeft(facing)));
            return false;
        }
        BlockPos endLeftFront = this.searchFrameLine(endLeftBack, Geometry.getForward(facing));
        if (endLeftFront.equals((Object)endLeftBack)) {
            this.highlightBlock(endLeftBack.offset(Geometry.getLeft(facing)));
            this.highlightBlock(endLeftBack.offset(Geometry.getForward(facing)));
            return false;
        }
        BlockPos endMiddleFront = this.searchFrameLineEnd(endLeftFront, Geometry.getRight(facing), searchStart);
        if (endMiddleFront.equals((Object)endLeftFront)) {
            this.highlightBlock(endMiddleFront.offset(Geometry.getForward(facing)));
            this.highlightBlock(endMiddleFront.offset(Geometry.getRight(facing)));
            return false;
        }
        if (!endMiddleFront.equals((Object)searchStart)) {
            this.highlightBlock(endMiddleFront.offset(Geometry.getRight(facing)));
            return false;
        }
        boolean innerValid = this.checkInnerEmpty(endLeftBack, endRightFront);
        if (!innerValid) {
            return false;
        }
        int startX = Math.min(endLeftFront.getX(), endRightBack.getX()) + 1;
        int startZ = Math.min(endLeftFront.getZ(), endRightBack.getZ()) + 1;
        this.areaMin = new BlockPos(startX, this.getBlockPos().getY(), startZ);
        int endX = Math.max(endLeftFront.getX(), endRightBack.getX()) - 1;
        int endZ = Math.max(endLeftFront.getZ(), endRightBack.getZ()) - 1;
        this.areaMax = new BlockPos(endX, this.getBlockPos().getY(), endZ);
        if (this.currentTarget == null || !this.isInBounds(this.currentTarget)) {
            this.currentTarget = this.areaMin;
            this.lastTarget = this.areaMin;
        }
        this.setChanged();
        this.sendUpdate(SyncType.INITIAL);
        return true;
    }

    protected Direction getFacing() {
        return (Direction)Objects.requireNonNull(this.level).getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    private boolean checkInnerEmpty(BlockPos leftBack, BlockPos rightFront) {
        assert (this.level != null);
        int lengthX = Math.abs(leftBack.getX() - rightFront.getX());
        int lengthZ = Math.abs(leftBack.getZ() - rightFront.getZ());
        int dirX = leftBack.getX() - rightFront.getX() > 0 ? -1 : 1;
        int dirZ = leftBack.getZ() - rightFront.getZ() > 0 ? -1 : 1;
        boolean valid = true;
        for (int x = 1; x < lengthX; ++x) {
            for (int z = 1; z < lengthZ; ++z) {
                BlockPos offset = new BlockPos(dirX * x, 0, dirZ * z);
                BlockPos checkPos = leftBack.offset((Vec3i)offset);
                Block foundBlock = this.level.getBlockState(checkPos).getBlock();
                if (foundBlock.equals(Blocks.AIR)) continue;
                this.highlightBlock(checkPos);
                valid = false;
            }
        }
        return valid;
    }

    private BlockPos searchFrameLine(BlockPos searchStart, Vec3i direction) {
        BlockPos checkPos;
        BlockPos lastPosition = BlockPos.ZERO;
        for (int i = 0; i < MAX_SEARCH_LENGTH && this.testForFrame(checkPos = searchStart.offset(direction.multiply(i))); ++i) {
            lastPosition = checkPos;
        }
        return lastPosition;
    }

    private BlockPos searchFrameLineEnd(BlockPos searchStart, Vec3i direction, BlockPos searchEnd) {
        BlockPos checkPos;
        BlockPos lastPosition = BlockPos.ZERO;
        for (int i = 0; i < MAX_SEARCH_LENGTH && this.testForFrame(checkPos = searchStart.offset(direction.multiply(i))); ++i) {
            if (checkPos.equals((Object)searchEnd)) {
                Oritech.LOGGER.debug("found start, machine is valid");
                return checkPos;
            }
            lastPosition = checkPos;
        }
        return lastPosition;
    }

    private boolean testForFrame(BlockPos pos) {
        Block found = this.level.getBlockState(pos).getBlock();
        return found.equals(BlockContent.MACHINE_FRAME_BLOCK);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        if (!this.isActive(state) || !((Boolean)state.getValue((Property)FrameInteractionBlock.HAS_FRAME)).booleanValue() || this.getAreaMin() == null) {
            return;
        }
        if (!this.canProgress()) {
            return;
        }
        while ((double)this.currentProgress > 0.01) {
            if (!this.moving && this.currentProgress >= this.getWorkTime()) {
                this.setChanged();
                if (!this.startBlockMove()) break;
                this.currentProgress -= this.getWorkTime();
                this.finishBlockWork(this.lastTarget);
                this.updateToolPosInFrame();
                this.moving = true;
                continue;
            }
            if (!this.moving || !(this.currentProgress >= this.getMoveTime())) break;
            this.setChanged();
            if (this.hasWorkAvailable(this.currentTarget)) {
                this.moving = false;
                this.currentProgress -= this.getMoveTime();
                continue;
            }
            if (!this.startBlockMove()) break;
            this.updateToolPosInFrame();
            this.currentProgress -= this.getMoveTime();
        }
        this.doProgress(this.moving);
        this.currentProgress += 1.0f;
        this.lastWorkedAt = world.getGameTime();
    }

    private boolean isBlockAvailable(BlockPos target) {
        if (!occupiedAreas.containsKey(this.areaMin)) {
            occupiedAreas.put((Vec3i)this.areaMin, new HashMap(1));
            return true;
        }
        HashMap<Vec3i, Vec3i> frameEntries = occupiedAreas.get(this.areaMin);
        return !frameEntries.containsValue(target);
    }

    private void updateToolPosInFrame() {
        HashMap<Vec3i, Vec3i> frameEntries = occupiedAreas.get(this.areaMin);
        frameEntries.put((Vec3i)this.worldPosition, (Vec3i)this.currentTarget);
    }

    public void cleanup() {
        HashMap<Vec3i, Vec3i> frameEntries = occupiedAreas.get(this.areaMin);
        if (frameEntries != null) {
            frameEntries.remove(this.worldPosition);
        }
    }

    protected abstract boolean hasWorkAvailable(BlockPos var1);

    protected abstract void doProgress(boolean var1);

    protected abstract boolean canProgress();

    public abstract void finishBlockWork(BlockPos var1);

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        if (((Boolean)this.getBlockState().getValue((Property)FrameInteractionBlock.HAS_FRAME)).booleanValue() && this.areaMin != null) {
            nbt.putLong("areaMin", this.areaMin.asLong());
            nbt.putLong("areaMax", this.areaMax.asLong());
            nbt.putLong("currentTarget", this.currentTarget.asLong());
            nbt.putLong("currentDirection", new BlockPos(this.currentDirection).asLong());
            nbt.putInt("progress", (int)this.currentProgress);
            nbt.putBoolean("moving", this.moving);
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        if (((Boolean)this.getBlockState().getValue((Property)FrameInteractionBlock.HAS_FRAME)).booleanValue()) {
            this.areaMin = BlockPos.of((long)nbt.getLong("areaMin"));
            this.areaMax = BlockPos.of((long)nbt.getLong("areaMax"));
            this.currentTarget = BlockPos.of((long)nbt.getLong("currentTarget"));
            this.currentDirection = BlockPos.of((long)nbt.getLong("currentDirection"));
            this.lastTarget = this.currentTarget;
            this.currentProgress = nbt.getInt("progress");
            this.moving = nbt.getBoolean("moving");
        }
    }

    private boolean startBlockMove() {
        BlockPos nextPos = this.currentTarget.offset(this.currentDirection);
        Vec3i nextDir = this.currentDirection;
        if (!this.isInBounds(nextPos)) {
            nextPos = this.currentTarget.offset(0, 0, 1);
            nextDir = this.currentDirection.multiply(-1);
            if (!this.isInBounds(nextPos)) {
                Tuple<BlockPos, BlockPos> data = this.resetWorkPosition();
                nextPos = (BlockPos)data.getA();
                nextDir = (Vec3i)data.getB();
            }
        }
        if (!this.isBlockAvailable(nextPos) && this.currentProgress <= this.getWorkTime() * this.getSpeedMultiplier() * 2.0f + 4.0f) {
            return false;
        }
        this.lastTarget = this.currentTarget;
        this.currentTarget = nextPos;
        this.currentDirection = nextDir;
        return true;
    }

    private Tuple<BlockPos, BlockPos> resetWorkPosition() {
        return new Tuple((Object)this.areaMin, (Object)new BlockPos(1, 0, 0));
    }

    private boolean isInBounds(BlockPos pos) {
        return pos.getX() >= this.areaMin.getX() && pos.getX() <= this.areaMax.getX() && pos.getZ() >= this.areaMin.getZ() && pos.getZ() <= this.areaMax.getZ();
    }

    private void highlightBlock(BlockPos block) {
        ParticleContent.HIGHLIGHT_BLOCK.spawn(this.level, Vec3.atLowerCornerOf((Vec3i)block), null);
    }

    public abstract BlockState getMachineHead();

    public int getFrameOffset() {
        return 1;
    }

    public float getSpeedMultiplier() {
        return 1.0f;
    }

    public BlockPos getAreaMin() {
        return this.areaMin;
    }

    public void setAreaMin(BlockPos areaMin) {
        this.areaMin = areaMin;
    }

    public BlockPos getAreaMax() {
        return this.areaMax;
    }

    public void setAreaMax(BlockPos areaMax) {
        this.areaMax = areaMax;
    }

    public BlockPos getCurrentTarget() {
        return this.currentTarget;
    }

    public void setCurrentTarget(BlockPos currentTarget) {
        this.currentTarget = currentTarget;
    }

    public BlockPos getLastTarget() {
        return this.lastTarget;
    }

    public void setLastTarget(BlockPos lastTarget) {
        this.lastTarget = lastTarget;
    }

    public int getCurrentProgress() {
        return (int)this.currentProgress;
    }

    public void setCurrentProgress(int currentProgress) {
        this.currentProgress = currentProgress;
    }

    public boolean isActive(BlockState state) {
        return true;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    public Vec3i getCurrentDirection() {
        return this.currentDirection;
    }

    public void setCurrentDirection(Vec3i currentDirection) {
        this.currentDirection = currentDirection;
    }

    public abstract float getMoveTime();

    public abstract float getWorkTime();

    public ItemStack getToolheadAdditionalRender() {
        return null;
    }

    @Override
    public void sendUpdate(SyncType type) {
        if (this.currentTarget == null || this.lastTarget == null) {
            return;
        }
        super.sendUpdate(type);
    }
}

