/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DelegatingEnergyStorage;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.energy.containers.DynamicStatisticEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.blocks.storage.SmallStorageBlock;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.ItemContent;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.StackContext;

public abstract class ExpandableEnergyStorageBlockEntity
extends NetworkedBlockEntity
implements EnergyApi.BlockProvider,
ItemApi.BlockProvider,
MachineAddonController,
ScreenProvider,
ExtendedMenuProvider {
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<BlockPos> connectedAddons = new ArrayList<BlockPos>();
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<BlockPos> openSlots = new ArrayList<BlockPos>();
    @SyncField(value={SyncType.GUI_OPEN})
    private MachineAddonController.BaseAddonData addonData = MachineAddonController.DEFAULT_ADDON_DATA;
    @SyncField(value={SyncType.GUI_TICK})
    private boolean redstonePowered;
    @SyncField(value={SyncType.GUI_TICK})
    public DynamicStatisticEnergyStorage.EnergyStatistics currentStats;
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(1, this::setChanged);
    @SyncField(value={SyncType.GUI_TICK})
    public final DynamicStatisticEnergyStorage energyStorage = new DynamicStatisticEnergyStorage(this.getDefaultCapacity(), this.getDefaultInsertRate(), this.getDefaultExtractionRate(), this::setChanged);
    private final EnergyApi.EnergyStorage outputStorage = new DelegatingEnergyStorage(this, this.energyStorage, null){

        @Override
        public boolean supportsInsertion() {
            return false;
        }

        @Override
        public long insert(long amount, boolean simulate) {
            return 0L;
        }
    };
    private final EnergyApi.EnergyStorage inputStorage = new DelegatingEnergyStorage(this, this.energyStorage, null){

        @Override
        public boolean supportsExtraction() {
            return false;
        }

        @Override
        public long extract(long amount, boolean simulate) {
            return 0L;
        }
    };

    public ExpandableEnergyStorageBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        this.energyStorage.tick((int)world.getGameTime());
        if (!this.redstonePowered) {
            this.outputEnergy();
        }
        this.inputFromCrystal();
    }

    private void inputFromCrystal() {
        if (this.energyStorage.amount >= this.energyStorage.capacity || this.inventory.isEmpty()) {
            return;
        }
        if (!this.inventory.getItem(0).getItem().equals(ItemContent.OVERCHARGED_CRYSTAL)) {
            return;
        }
        this.energyStorage.amount = Math.min(this.energyStorage.capacity, this.energyStorage.amount + (long)Oritech.CONFIG.overchargedCrystalChargeRate());
    }

    private void outputEnergy() {
        if (this.energyStorage.amount <= 0L) {
            return;
        }
        this.chargeItems();
        Tuple<Direction, BlockPos> target = ExpandableEnergyStorageBlockEntity.getOutputPosition(this.worldPosition, this.getFacing());
        EnergyApi.EnergyStorage candidate = EnergyApi.BLOCK.find(this.level, (BlockPos)target.getB(), ((Direction)target.getA()).getOpposite());
        if (candidate != null && candidate.supportsInsertion()) {
            EnergyApi.transfer(this.energyStorage, candidate, Long.MAX_VALUE, false);
        }
    }

    private void chargeItems() {
        ItemStack heldStack = (ItemStack)this.inventory.heldStacks.get(0);
        if (heldStack.isEmpty() || heldStack.getCount() > 1) {
            return;
        }
        StackContext stackRef = new StackContext(heldStack, updated -> this.inventory.heldStacks.set(0, updated));
        EnergyApi.EnergyStorage slotEnergyContainer = EnergyApi.ITEM.find(stackRef);
        if (slotEnergyContainer != null) {
            EnergyApi.transfer(this.energyStorage, slotEnergyContainer, Long.MAX_VALUE, false);
        }
    }

    public static Tuple<Direction, BlockPos> getOutputPosition(BlockPos pos, Direction facing) {
        BlockPos blockInFront = (BlockPos)Geometry.offsetToWorldPosition(facing, new Vec3i(-1, 0, 0), (Vec3i)pos);
        BlockPos worldOffset = blockInFront.subtract((Vec3i)pos);
        Direction direction = Direction.fromDelta((int)worldOffset.getX(), (int)worldOffset.getY(), (int)worldOffset.getZ());
        return new Tuple((Object)direction, (Object)blockInFront);
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.writeAddonToNbt(nbt);
        nbt.putLong("energy_stored", this.energyStorage.amount);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory.heldStacks, (boolean)false, (HolderLookup.Provider)registryLookup);
        nbt.putBoolean("redstone", this.redstonePowered);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.loadAddonNbtData(nbt);
        this.updateEnergyContainer();
        this.energyStorage.amount = nbt.getLong("energy_stored");
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory.heldStacks, (HolderLookup.Provider)registryLookup);
        this.redstonePowered = nbt.getBoolean("redstone");
    }

    @Override
    public void preNetworkUpdate(SyncType type) {
        super.preNetworkUpdate(type);
        this.currentStats = this.energyStorage.getCurrentStatistics(this.level.getGameTime());
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(Direction direction) {
        return this.inventory;
    }

    public Direction getFacing() {
        return (Direction)this.getBlockState().getValue((Property)SmallStorageBlock.TARGET_DIR);
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(Direction direction) {
        if (direction == null) {
            return this.energyStorage;
        }
        if (direction.equals((Object)this.getFacing())) {
            return this.outputStorage;
        }
        return this.inputStorage;
    }

    @Override
    public List<BlockPos> getConnectedAddons() {
        return this.connectedAddons;
    }

    @Override
    public List<BlockPos> getOpenAddonSlots() {
        return this.openSlots;
    }

    @Override
    public Direction getFacingForAddon() {
        Direction facing = (Direction)Objects.requireNonNull(this.level).getBlockState(this.getBlockPos()).getValue((Property)SmallStorageBlock.TARGET_DIR);
        if (facing.equals((Object)Direction.UP) || facing.equals((Object)Direction.DOWN)) {
            return Direction.NORTH;
        }
        return facing;
    }

    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return this.energyStorage;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForAddon() {
        return this.inventory;
    }

    @Override
    public ScreenProvider getScreenProvider() {
        return this;
    }

    @Override
    public MachineAddonController.BaseAddonData getBaseAddonData() {
        return this.addonData;
    }

    @Override
    public void setBaseAddonData(MachineAddonController.BaseAddonData data) {
        this.addonData = data;
    }

    @Override
    public void updateEnergyContainer() {
        MachineAddonController.super.updateEnergyContainer();
        this.energyStorage.maxExtract = this.getDefaultExtractionRate() + this.addonData.energyBonusTransfer();
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxInsert;
    }

    public abstract long getDefaultExtractionRate();

    public void saveExtraData(FriendlyByteBuf buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.writeBlockPos(this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.literal((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new UpgradableMachineScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 30, 42));
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public BlockPos getPosForAddon() {
        return this.getBlockPos();
    }

    @Override
    public Level getWorldForAddon() {
        return this.getLevel();
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.STORAGE_SCREEN;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public Property<Direction> getBlockFacingProperty() {
        return SmallStorageBlock.TARGET_DIR;
    }

    public void setRedstonePowered(boolean isPowered) {
        this.redstonePowered = isPowered;
    }

    @Override
    public boolean hasRedstoneControlAvailable() {
        return true;
    }

    @Override
    public int receivedRedstoneSignal() {
        if (this.redstonePowered) {
            return 15;
        }
        return this.level.getBestNeighborSignal(this.worldPosition);
    }

    @Override
    public String currentRedstoneEffect() {
        if (this.receivedRedstoneSignal() > 0) {
            return "tooltip.oritech.redstone_disabled_storage";
        }
        return "tooltip.oritech.redstone_enabled_direct";
    }
}

