/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.create.mechanical_chisel;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.saw.SawBlock;
import com.simibubi.create.foundation.block.IBE;
import com.supermartijn642.rechiseled.create.RechiseledCreate;
import com.supermartijn642.rechiseled.create.mechanical_chisel.MechanicalChiselBlockEntity;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MechanicalChiselBlock
extends DirectionalAxisKineticBlock
implements IBE<MechanicalChiselBlockEntity> {
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public MechanicalChiselBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)SawBlock.FLIPPED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{SawBlock.FLIPPED}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getHorizontalDirection();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(facing.getAxis() == Direction.Axis.X))).setValue((Property)SawBlock.FLIPPED, (Comparable)Boolean.valueOf(facing.getAxisDirection() == Direction.AxisDirection.POSITIVE));
    }

    public BlockState getRotatedBlockState(BlockState state, Direction side) {
        BlockState newState = super.getRotatedBlockState(state, side);
        if (((Direction)newState.getValue((Property)FACING)).getAxis() != Direction.Axis.Y) {
            return newState;
        }
        if (side.getAxis() != Direction.Axis.Y) {
            return newState;
        }
        if (!((Boolean)state.getValue((Property)AXIS_ALONG_FIRST_COORDINATE)).booleanValue()) {
            newState = (BlockState)newState.cycle((Property)SawBlock.FLIPPED);
        }
        return newState;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        BlockState newState = super.rotate(state, rotation);
        if (((Direction)state.getValue((Property)FACING)).getAxis() != Direction.Axis.Y) {
            return newState;
        }
        if (rotation.ordinal() % 2 == 1 && rotation == Rotation.CLOCKWISE_90 != (Boolean)state.getValue((Property)AXIS_ALONG_FIRST_COORDINATE)) {
            newState = (BlockState)newState.cycle((Property)SawBlock.FLIPPED);
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            newState = (BlockState)newState.cycle((Property)SawBlock.FLIPPED);
        }
        return newState;
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        BlockState newState = super.mirror(state, mirror);
        if (((Direction)state.getValue((Property)FACING)).getAxis() != Direction.Axis.Y) {
            return newState;
        }
        boolean alongX = (Boolean)state.getValue((Property)AXIS_ALONG_FIRST_COORDINATE);
        if (alongX && mirror == Mirror.FRONT_BACK) {
            newState = (BlockState)newState.cycle((Property)SawBlock.FLIPPED);
        }
        if (!alongX && mirror == Mirror.LEFT_RIGHT) {
            newState = (BlockState)newState.cycle((Property)SawBlock.FLIPPED);
        }
        return newState;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.CASING_12PX.get((Direction)state.getValue((Property)FACING));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (!player.isShiftKeyDown() && player.mayBuild() && placementHelper.matchesItem(stack) && placementHelper.getOffset(player, level, state, pos, hit).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hit).consumesAction()) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!player.isSpectator() && stack.isEmpty()) {
            return state.getOptionalValue((Property)FACING).orElse(Direction.WEST) != Direction.UP ? ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION : this.onBlockEntityUseItemOn((BlockGetter)level, pos, be -> {
                for (int i = 0; i < be.inventory.getSlots(); ++i) {
                    ItemStack heldItemStack = be.inventory.getStackInSlot(i);
                    if (level.isClientSide || heldItemStack.isEmpty()) continue;
                    player.getInventory().placeItemBackInInventory(heldItemStack);
                }
                be.inventory.clear();
                be.notifyUpdate();
                return ItemInteractionResult.SUCCESS;
            });
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void updateEntityAfterFallOn(BlockGetter level, Entity entity) {
        super.updateEntityAfterFallOn(level, entity);
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        if (entity.level().isClientSide) {
            return;
        }
        BlockPos pos = entity.blockPosition();
        this.withBlockEntityDo((BlockGetter)entity.level(), pos, be -> {
            if (be.getSpeed() == 0.0f) {
                return;
            }
            be.insertItem((ItemEntity)entity);
        });
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.NORMAL;
    }

    public static boolean isHorizontal(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis().isHorizontal();
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return MechanicalChiselBlock.isHorizontal(state) ? ((Direction)state.getValue((Property)FACING)).getAxis() : super.getRotationAxis(state);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return MechanicalChiselBlock.isHorizontal(state) ? face == ((Direction)state.getValue((Property)FACING)).getOpposite() : super.hasShaftTowards(world, pos, state, face);
    }

    public Class<MechanicalChiselBlockEntity> getBlockEntityClass() {
        return MechanicalChiselBlockEntity.class;
    }

    public BlockEntityType<? extends MechanicalChiselBlockEntity> getBlockEntityType() {
        return RechiseledCreate.mechanical_chisel_entity;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return stack -> stack.getItem() instanceof BlockItem && ((BlockItem)stack.getItem()).getBlock() == RechiseledCreate.mechanical_chisel;
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> state.getBlock() == RechiseledCreate.mechanical_chisel;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)((Direction)state.getValue((Property)DirectionalKineticBlock.FACING)).getAxis(), dir -> world.getBlockState(pos.relative(dir)).canBeReplaced());
            return directions.isEmpty() ? PlacementOffset.fail() : PlacementOffset.success((Vec3i)pos.relative((Direction)directions.get(0)), s -> (BlockState)((BlockState)((BlockState)s.setValue((Property)DirectionalKineticBlock.FACING, (Comparable)((Direction)state.getValue((Property)DirectionalKineticBlock.FACING)))).setValue((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE, (Comparable)((Boolean)state.getValue((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE)))).setValue((Property)SawBlock.FLIPPED, (Comparable)((Boolean)state.getValue((Property)SawBlock.FLIPPED))));
        }
    }
}

