/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.neoforge.platform;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.TearBombBlock;
import cn.leolezury.eternalstarlight.common.block.fluid.EtherFluid;
import cn.leolezury.eternalstarlight.common.item.armor.AlchemistArmorItem;
import cn.leolezury.eternalstarlight.common.item.armor.ThermalSpringstoneArmorItem;
import cn.leolezury.eternalstarlight.common.item.combat.CrescentSpearItem;
import cn.leolezury.eternalstarlight.common.item.combat.HammerItem;
import cn.leolezury.eternalstarlight.common.item.combat.ScytheItem;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.platform.EntityDataAttachment;
import cn.leolezury.eternalstarlight.common.platform.registry.RegistrationProvider;
import cn.leolezury.eternalstarlight.common.platform.registry.RegistryObject;
import cn.leolezury.eternalstarlight.common.registry.ESCreativeModeTabs;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.neoforge.block.ForgeTearBombBlock;
import cn.leolezury.eternalstarlight.neoforge.block.fluid.ForgeEtherFluid;
import cn.leolezury.eternalstarlight.neoforge.client.ForgeDimensionSpecialEffects;
import cn.leolezury.eternalstarlight.neoforge.item.armor.ForgeAlchemistArmorItem;
import cn.leolezury.eternalstarlight.neoforge.item.armor.ForgeStarlitDiamondArmorItem;
import cn.leolezury.eternalstarlight.neoforge.item.armor.ForgeThermalSpringstoneArmorItem;
import cn.leolezury.eternalstarlight.neoforge.item.weapon.ForgeCrescentSpearItem;
import cn.leolezury.eternalstarlight.neoforge.item.weapon.ForgeHammerItem;
import cn.leolezury.eternalstarlight.neoforge.item.weapon.ForgeScytheItem;
import cn.leolezury.eternalstarlight.neoforge.network.NeoForgeNetworkHandler;
import com.google.auto.service.AutoService;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.Nullable;

@AutoService(value={ESPlatform.class})
public class NeoForgePlatform
implements ESPlatform {
    public static final List<DeferredRegister<?>> REGISTERS = new ArrayList();
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPE_REGISTER = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"eternal_starlight");
    public static final List<Registry<?>> NEW_REGISTRIES = new ArrayList();

    @Override
    public ESPlatform.Loader getLoader() {
        return ESPlatform.Loader.NEOFORGE;
    }

    @Override
    public boolean isPhysicalClient() {
        return FMLLoader.getDist() == Dist.CLIENT;
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public <T> RegistrationProvider<T> createRegistrationProvider(ResourceKey<? extends Registry<T>> key, String namespace) {
        NeoForgeRegistrationProvider provider = new NeoForgeRegistrationProvider(key, null, namespace);
        if (!REGISTERS.contains(provider.deferredRegister)) {
            REGISTERS.add(provider.deferredRegister);
        }
        return provider;
    }

    @Override
    public <T> RegistrationProvider<T> createNewRegistryProvider(ResourceKey<? extends Registry<T>> key, String namespace) {
        RegistryBuilder builder = new RegistryBuilder(key);
        builder.sync(true);
        Registry registry = builder.create();
        NeoForgeRegistrationProvider provider = new NeoForgeRegistrationProvider(key, registry, namespace);
        if (!REGISTERS.contains(provider.deferredRegister)) {
            REGISTERS.add(provider.deferredRegister);
        }
        NEW_REGISTRIES.add(registry);
        return provider;
    }

    @Override
    public <T> void registerDatapackRegistry(ResourceKey<Registry<T>> key, Codec<T> codec, Codec<T> networkCodec) {
        IEventBus bus;
        Optional optional = ModList.get().getModContainerById(key.location().getNamespace());
        if (optional.isPresent() && (bus = ((ModContainer)optional.get()).getEventBus()) != null) {
            if (networkCodec != null) {
                bus.addListener(DataPackRegistryEvent.NewRegistry.class, event -> event.dataPackRegistry(key, codec, networkCodec));
            } else {
                bus.addListener(DataPackRegistryEvent.NewRegistry.class, event -> event.dataPackRegistry(key, codec));
            }
        }
    }

    @Override
    public SpawnEggItem createSpawnEgg(Supplier<EntityType<? extends Mob>> defaultType, int backgroundColor, int highlightColor, Item.Properties properties) {
        return new DeferredSpawnEggItem(defaultType, backgroundColor, highlightColor, properties);
    }

    @Override
    public ScytheItem createScythe(Tier tier, boolean canTill, Item.Properties properties) {
        return new ForgeScytheItem(tier, canTill, properties);
    }

    @Override
    public HammerItem createHammer(Tier tier, Supplier<ParticleOptions> smashParticle, Holder<SoundEvent> smashSound, Item.Properties properties) {
        return new ForgeHammerItem(tier, smashParticle, smashSound, properties);
    }

    @Override
    public CrescentSpearItem createCrescentSpear(Item.Properties properties) {
        return new ForgeCrescentSpearItem(properties);
    }

    @Override
    public ThermalSpringstoneArmorItem createThermalSpringstoneArmor(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        return new ForgeThermalSpringstoneArmorItem(material, type, properties);
    }

    @Override
    public AlchemistArmorItem createAlchemistArmor(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        return new ForgeAlchemistArmorItem(material, type, properties);
    }

    @Override
    public ArmorItem createStarlitDiamondArmor(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        return new ForgeStarlitDiamondArmorItem(material, type, properties);
    }

    @Override
    public FlowerPotBlock createFlowerPot(Supplier<FlowerPotBlock> pot, Supplier<? extends Block> flower, BlockBehaviour.Properties properties) {
        FlowerPotBlock block = new FlowerPotBlock(pot, flower, properties);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(BuiltInRegistries.BLOCK.getKey((Object)flower.get()), () -> block);
        return block;
    }

    @Override
    public EtherFluid.Still createEtherFluid() {
        return new ForgeEtherFluid.Still();
    }

    @Override
    public EtherFluid.Flowing createFlowingEtherFluid() {
        return new ForgeEtherFluid.Flowing();
    }

    @Override
    public TearBombBlock createTearBombBlock(BlockBehaviour.Properties properties) {
        return new ForgeTearBombBlock(properties);
    }

    @Override
    public <T> EntityDataAttachment<T> registerDataAttachment(final String id, Supplier<T> defaultValue, Codec<T> codec, boolean copyOnDeath) {
        AttachmentType.Builder builder = AttachmentType.builder(h -> defaultValue.get());
        if (codec != null) {
            builder = builder.serialize(codec);
        }
        if (copyOnDeath) {
            builder = builder.copyOnDeath();
        }
        final DeferredHolder holder = ATTACHMENT_TYPE_REGISTER.register(id, () -> ((AttachmentType.Builder)builder).build());
        return new EntityDataAttachment<T>(this){

            @Override
            public ResourceLocation id() {
                return EternalStarlight.id(id);
            }

            @Override
            public boolean hasData(Entity entity) {
                return entity.hasData((Supplier)holder);
            }

            @Override
            public T getData(Entity entity) {
                return entity.getData((Supplier)holder);
            }

            @Override
            public Optional<T> getExistingData(Entity entity) {
                return entity.getExistingData((Supplier)holder);
            }

            @Override
            @Nullable
            public T setData(Entity entity, T data) {
                return entity.setData((Supplier)holder, data);
            }

            @Override
            @Nullable
            public T removeData(Entity entity) {
                return entity.removeData((Supplier)holder);
            }
        };
    }

    @Override
    public boolean canEntityGrief(Level level, Entity entity) {
        return EventHooks.canEntityGrief((Level)level, (Entity)entity);
    }

    @Override
    public boolean postEntityDestroyBlockEvent(Level level, BlockPos pos, Entity entity) {
        boolean bl;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            bl = CommonHooks.canEntityDestroy((Level)level, (BlockPos)pos, (LivingEntity)living);
        } else {
            bl = this.canEntityGrief(level, entity);
        }
        return bl;
    }

    @Override
    public boolean postTravelToDimensionEvent(Entity entity, ResourceKey<Level> dimension) {
        return CommonHooks.onTravelToDimension((Entity)entity, dimension);
    }

    @Override
    public boolean postTeleportEvent(Entity entity, Vec3 destPos) {
        EntityTeleportEvent event = new EntityTeleportEvent(entity, destPos.x, destPos.y, destPos.z);
        NeoForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    @Override
    public boolean isShears(ItemStack stack) {
        return stack.is(Tags.Items.TOOLS_SHEAR);
    }

    @Override
    public boolean isShield(ItemStack stack) {
        return stack.canPerformAction(ItemAbilities.SHIELD_BLOCK);
    }

    @Override
    public boolean canScrape(ItemStack stack) {
        return stack.canPerformAction(ItemAbilities.AXE_SCRAPE);
    }

    @Override
    public CreativeModeTab getESTab() {
        return CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ESItems.STARLIGHT_FLOWER.get())).title((Component)Component.translatable((String)"name.eternal_starlight")).displayItems((displayParameters, output) -> {
            for (ResourceKey<Item> entry : ESItems.REGISTERED_ITEMS) {
                Item item = (Item)BuiltInRegistries.ITEM.get(entry);
                if (item == null) continue;
                output.accept((ItemLike)item);
                if (item != ESItems.STARLIT_PAINTING.get()) continue;
                displayParameters.holders().lookup(Registries.PAINTING_VARIANT).ifPresent(registryLookup -> ESCreativeModeTabs.generatePresetPaintings(output, displayParameters.holders(), (HolderLookup.RegistryLookup<PaintingVariant>)registryLookup, holder -> holder.is(ESTags.PaintingVariants.PLACEABLE)));
            }
        }).build();
    }

    @Override
    public Pair<Predicate<UseOnContext>, Consumer<UseOnContext>> getToolTillAction(UseOnContext context) {
        BlockPos blockpos;
        Level level = context.getLevel();
        BlockState toolModifiedState = level.getBlockState(blockpos = context.getClickedPos()).getToolModifiedState(context, ItemAbilities.HOE_TILL, false);
        return toolModifiedState == null ? null : Pair.of(ctx -> true, ScytheItem.changeIntoState(toolModifiedState));
    }

    @Override
    public boolean canBoatInFluid(Boat boat, FluidState state) {
        return boat.canBoatInFluid(state);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public DimensionSpecialEffects getDimEffect() {
        ESPlatform.super.getDimEffect();
        return new ForgeDimensionSpecialEffects(160.0f, false, DimensionSpecialEffects.SkyType.NONE, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderBlock(BlockRenderDispatcher dispatcher, PoseStack stack, MultiBufferSource multiBufferSource, Level level, BlockState state, BlockPos pos, long seed) {
        BakedModel model = dispatcher.getBlockModel(state);
        for (RenderType renderType : model.getRenderTypes(state, RandomSource.create((long)seed), ModelData.EMPTY)) {
            dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, model, state, pos, stack, multiBufferSource.getBuffer(renderType), false, RandomSource.create(), seed, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, renderType);
        }
    }

    @Override
    public void sendToClient(ServerPlayer player, CustomPacketPayload packet) {
        NeoForgeNetworkHandler.sendToClient(player, packet);
    }

    @Override
    public void sendToServer(CustomPacketPayload packet) {
        NeoForgeNetworkHandler.sendToServer(packet);
    }

    static class NeoForgeRegistrationProvider<T>
    implements RegistrationProvider<T> {
        private final ResourceKey<? extends Registry<T>> key;
        private final Registry<T> registry;
        private final DeferredRegister<T> deferredRegister;
        private final String namespace;

        NeoForgeRegistrationProvider(ResourceKey<? extends Registry<T>> key, Registry<T> registry, String namespace) {
            this.key = key;
            this.registry = registry;
            this.deferredRegister = DeferredRegister.create(key, (String)namespace);
            this.namespace = namespace;
        }

        @Override
        public Registry<T> registry() {
            return this.registry == null ? (Registry)BuiltInRegistries.REGISTRY.get(this.key.location()) : this.registry;
        }

        @Override
        public <I extends T> RegistryObject<T, I> register(String id, Supplier<? extends I> supplier) {
            final ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)id);
            final ResourceKey resourceKey = ResourceKey.create(this.key, (ResourceLocation)location);
            final DeferredHolder holder = this.deferredRegister.register(id, supplier);
            return new RegistryObject<T, I>(this){

                @Override
                public Holder<T> asHolder() {
                    return holder;
                }

                @Override
                public ResourceKey<I> getResourceKey() {
                    return resourceKey;
                }

                @Override
                public ResourceLocation getId() {
                    return location;
                }

                @Override
                public I get() {
                    return holder.value();
                }
            };
        }
    }
}

