/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.network.UpdateStarlightStoryPacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.world.saved.BookProgressions;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class ESBookUtil {
    public static BookProgressions getOrCreateBookProgressions(ServerLevel serverLevel) {
        return (BookProgressions)serverLevel.getDataStorage().computeIfAbsent(BookProgressions.factory(serverLevel), "book_progressions");
    }

    public static Set<ResourceLocation> getUnlockedParts(ServerPlayer player) {
        ServerLevel level;
        MinecraftServer server = player.getServer();
        if (server != null && (level = player.getServer().getLevel(Level.OVERWORLD)) != null) {
            BookProgressions progressions = ESBookUtil.getOrCreateBookProgressions(level);
            return progressions.getProgressions().getOrDefault(player.getUUID(), new HashSet());
        }
        return new HashSet<ResourceLocation>();
    }

    public static void unlock(ServerPlayer player, ResourceLocation ... locations) {
        ServerLevel level;
        MinecraftServer server = player.getServer();
        if (server != null && (level = player.getServer().getLevel(Level.OVERWORLD)) != null) {
            BookProgressions progressions = ESBookUtil.getOrCreateBookProgressions(level);
            Set<ResourceLocation> unlocked = ESBookUtil.getUnlockedParts(player);
            HashSet<ResourceLocation> oldUnlocked = new HashSet<ResourceLocation>(unlocked);
            unlocked.addAll(Set.of(locations));
            progressions.getProgressions().put(player.getUUID(), unlocked);
            progressions.setDirty();
            ESPlatform.INSTANCE.sendToClient(player, new UpdateStarlightStoryPacket(oldUnlocked, unlocked));
        }
    }
}

