/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.platform;

import cn.leolezury.eternalstarlight.common.block.TearBombBlock;
import cn.leolezury.eternalstarlight.common.block.fluid.EtherFluid;
import cn.leolezury.eternalstarlight.common.client.ESDimensionSpecialEffects;
import cn.leolezury.eternalstarlight.common.client.model.item.GlowingBakedModel;
import cn.leolezury.eternalstarlight.common.item.armor.AlchemistArmorItem;
import cn.leolezury.eternalstarlight.common.item.armor.ThermalSpringstoneArmorItem;
import cn.leolezury.eternalstarlight.common.item.combat.CrescentSpearItem;
import cn.leolezury.eternalstarlight.common.item.combat.HammerItem;
import cn.leolezury.eternalstarlight.common.item.combat.ScytheItem;
import cn.leolezury.eternalstarlight.common.platform.EntityDataAttachment;
import cn.leolezury.eternalstarlight.common.platform.registry.RegistrationProvider;
import cn.leolezury.eternalstarlight.common.resource.gatekeeper.TheGatekeeperNameManager;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public interface ESPlatform {
    public static final ESPlatform INSTANCE = (ESPlatform)Util.make(() -> {
        ServiceLoader<ESPlatform> loader = ServiceLoader.load(ESPlatform.class);
        Iterator<ESPlatform> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            throw new RuntimeException("Platform instance not found!");
        }
        ESPlatform platform = iterator.next();
        if (iterator.hasNext()) {
            throw new RuntimeException("More than one platform instance was found!");
        }
        return platform;
    });

    public Loader getLoader();

    public boolean isPhysicalClient();

    public Path getConfigDir();

    public <T> RegistrationProvider<T> createRegistrationProvider(ResourceKey<? extends Registry<T>> var1, String var2);

    public <T> RegistrationProvider<T> createNewRegistryProvider(ResourceKey<? extends Registry<T>> var1, String var2);

    public <T> void registerDatapackRegistry(ResourceKey<Registry<T>> var1, Codec<T> var2, Codec<T> var3);

    default public SpawnEggItem createSpawnEgg(Supplier<EntityType<? extends Mob>> defaultType, int backgroundColor, int highlightColor, Item.Properties properties) {
        return new SpawnEggItem(defaultType.get(), backgroundColor, highlightColor, properties);
    }

    default public ScytheItem createScythe(Tier tier, boolean canTill, Item.Properties properties) {
        return new ScytheItem(tier, canTill, properties);
    }

    default public HammerItem createHammer(Tier tier, Supplier<ParticleOptions> smashParticle, Holder<SoundEvent> smashSound, Item.Properties properties) {
        return new HammerItem(tier, smashParticle, smashSound, properties);
    }

    default public CrescentSpearItem createCrescentSpear(Item.Properties properties) {
        return new CrescentSpearItem(properties);
    }

    public ThermalSpringstoneArmorItem createThermalSpringstoneArmor(Holder<ArmorMaterial> var1, ArmorItem.Type var2, Item.Properties var3);

    public AlchemistArmorItem createAlchemistArmor(Holder<ArmorMaterial> var1, ArmorItem.Type var2, Item.Properties var3);

    public ArmorItem createStarlitDiamondArmor(Holder<ArmorMaterial> var1, ArmorItem.Type var2, Item.Properties var3);

    public CreativeModeTab getESTab();

    default public FlowerPotBlock createFlowerPot(Supplier<FlowerPotBlock> pot, Supplier<? extends Block> flower, BlockBehaviour.Properties properties) {
        return new FlowerPotBlock(flower.get(), properties);
    }

    default public EtherFluid.Still createEtherFluid() {
        return new EtherFluid.Still();
    }

    default public EtherFluid.Flowing createFlowingEtherFluid() {
        return new EtherFluid.Flowing();
    }

    default public TearBombBlock createTearBombBlock(BlockBehaviour.Properties properties) {
        return new TearBombBlock(properties);
    }

    public <T> EntityDataAttachment<T> registerDataAttachment(String var1, Supplier<T> var2, Codec<T> var3, boolean var4);

    default public TheGatekeeperNameManager createGatekeeperNameManager() {
        return new TheGatekeeperNameManager();
    }

    default public boolean canEntityGrief(Level level, Entity entity) {
        return level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
    }

    default public boolean postEntityDestroyBlockEvent(Level level, BlockPos pos, Entity entity) {
        ServerPlayer player;
        if (entity instanceof ServerPlayer && (!level.mayInteract((Player)(player = (ServerPlayer)entity), pos) || player.blockActionRestricted(level, pos, player.gameMode.getGameModeForPlayer()))) {
            return false;
        }
        return level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
    }

    default public boolean postTravelToDimensionEvent(Entity entity, ResourceKey<Level> dimension) {
        return true;
    }

    default public boolean postTeleportEvent(Entity entity, Vec3 destPos) {
        return true;
    }

    public boolean isShears(ItemStack var1);

    public boolean isShield(ItemStack var1);

    default public boolean canScrape(ItemStack stack) {
        return stack.is(ItemTags.AXES);
    }

    public Pair<Predicate<UseOnContext>, Consumer<UseOnContext>> getToolTillAction(UseOnContext var1);

    default public boolean canBoatInFluid(Boat boat, FluidState state) {
        return state.is(FluidTags.WATER);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public DimensionSpecialEffects getDimEffect() {
        return new ESDimensionSpecialEffects(160.0f, false, DimensionSpecialEffects.SkyType.NONE, false, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public BakedModel getGlowingBakedModel(BakedModel origin) {
        return new GlowingBakedModel(origin);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderBlock(BlockRenderDispatcher dispatcher, PoseStack stack, MultiBufferSource multiBufferSource, Level level, BlockState state, BlockPos pos, long seed) {
        dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, dispatcher.getBlockModel(state), state, pos, stack, multiBufferSource.getBuffer(ItemBlockRenderTypes.getMovingBlockRenderType((BlockState)state)), false, RandomSource.create(), seed, OverlayTexture.NO_OVERLAY);
    }

    public void sendToClient(ServerPlayer var1, CustomPacketPayload var2);

    default public void sendToAllClients(ServerLevel level, CustomPacketPayload packet) {
        for (ServerPlayer player : level.players()) {
            this.sendToClient(player, packet);
        }
    }

    default public void sendToTrackingClients(ServerLevel level, Entity entity, CustomPacketPayload packet) {
        level.getChunkSource().broadcast(entity, (Packet)new ClientboundCustomPayloadPacket(packet));
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.sendToClient(player, packet);
        }
    }

    public void sendToServer(CustomPacketPayload var1);

    public static enum Loader {
        NEOFORGE,
        FABRIC;

    }
}

