/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.data.ESBiomes;
import cn.leolezury.eternalstarlight.common.entity.interfaces.StarlightWitch;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Raider.class})
public abstract class RaiderMixin {
    @Inject(method={"finalizeSpawn(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/DifficultyInstance;Lnet/minecraft/world/entity/MobSpawnType;Lnet/minecraft/world/entity/SpawnGroupData;)Lnet/minecraft/world/entity/SpawnGroupData;"}, at={@At(value="TAIL")})
    private void finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData, CallbackInfoReturnable<SpawnGroupData> cir) {
        Object object = (LivingEntity)this;
        if (object instanceof Witch) {
            Witch witch = (Witch)object;
            object = this;
            if (object instanceof StarlightWitch) {
                StarlightWitch starlightWitch = (StarlightWitch)object;
                Holder biome = serverLevelAccessor.getBiome(witch.blockPosition());
                if (biome.is(ESBiomes.DARK_SWAMP)) {
                    starlightWitch.setWitchType("dark_swamp");
                }
            }
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        RaiderMixin raiderMixin = this;
        if (raiderMixin instanceof StarlightWitch) {
            StarlightWitch witch = (StarlightWitch)((Object)raiderMixin);
            compoundTag.putString("eternal_starlight:witch_type", witch.getWitchType());
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        RaiderMixin raiderMixin = this;
        if (raiderMixin instanceof StarlightWitch) {
            StarlightWitch witch = (StarlightWitch)((Object)raiderMixin);
            witch.setWitchType(compoundTag.getString("eternal_starlight:witch_type"));
        }
    }
}

