/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.living.monster.Stranghoul;
import cn.leolezury.eternalstarlight.common.item.interfaces.Swingable;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ESGlowParticleOptions;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESAttributes;
import cn.leolezury.eternalstarlight.common.registry.ESCriteriaTriggers;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    @Nullable
    protected ItemStack autoSpinAttackItemStack;
    @Shadow
    private Optional<BlockPos> lastClimbablePos;

    @Shadow
    public abstract ItemStack getItemInHand(InteractionHand var1);

    @Shadow
    public abstract boolean isUsingItem();

    @Shadow
    public abstract ItemStack getUseItem();

    @Shadow
    public abstract Collection<MobEffectInstance> getActiveEffects();

    @Shadow
    public abstract boolean hasEffect(Holder<MobEffect> var1);

    @Shadow
    public abstract boolean removeEffect(Holder<MobEffect> var1);

    @Shadow
    @NotNull
    public abstract ItemStack getWeaponItem();

    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    @Shadow
    public abstract AttributeMap getAttributes();

    @Shadow
    public abstract boolean hurt(DamageSource var1, float var2);

    @Shadow
    @Nullable
    public abstract LivingEntity getKillCredit();

    @Inject(method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"}, at={@At(value="HEAD")})
    private void swing(InteractionHand interactionHand, boolean bl, CallbackInfo ci) {
        Item item = this.getItemInHand(interactionHand).getItem();
        if (item instanceof Swingable) {
            Swingable swingable = (Swingable)item;
            swingable.swing(this.getItemInHand(interactionHand), (LivingEntity)this);
        }
    }

    @Inject(method={"isBlocking()Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void isBlocking(CallbackInfoReturnable<Boolean> cir) {
        if (this.isUsingItem() && this.getUseItem().is(ESTags.Items.GREATSWORDS)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getKnockback(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;)F"}, at={@At(value="RETURN")}, cancellable=true)
    private void getKnockback(Entity target, DamageSource damageSource, CallbackInfoReturnable<Float> cir) {
        if (this.getWeaponItem().is(ESTags.Items.HAMMERS)) {
            cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() + 1.0f));
        }
    }

    @Inject(method={"decreaseAirSupply(I)I"}, at={@At(value="RETURN")}, cancellable=true)
    private void decreaseAirSupply(int i, CallbackInfoReturnable<Integer> cir) {
        if (this.getItemBySlot(EquipmentSlot.HEAD).is(ESItems.AIR_SAC_MASK.asHolder())) {
            LivingEntity entity = (LivingEntity)this;
            if (entity.getDeltaMovement().length() < 0.001) {
                cir.setReturnValue((Object)Math.min(i + 1, entity.getMaxAirSupply()));
            } else if (entity.isSwimming()) {
                cir.setReturnValue((Object)Math.max((Integer)cir.getReturnValue() - (entity.getRandom().nextBoolean() ? 1 : 0), 0));
            }
        }
    }

    @Inject(method={"createLivingAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"}, at={@At(value="RETURN")})
    private static void createLivingAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> cir) {
        ((AttributeSupplier.Builder)cir.getReturnValue()).add(ESAttributes.THROWN_POTION_DISTANCE.asHolder()).add(ESAttributes.ETHER_RESISTANCE.asHolder()).add(ESAttributes.FIRE_RESISTANCE.asHolder());
    }

    @Inject(method={"checkAutoSpinAttack(Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/phys/AABB;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", shift=At.Shift.AFTER)})
    private void checkAutoSpinAttack(CallbackInfo ci) {
        this.doCrescentSpearDamage();
    }

    @Inject(method={"checkAutoSpinAttack(Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/phys/AABB;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;level()Lnet/minecraft/world/level/Level;", shift=At.Shift.AFTER)})
    private void checkAutoSpinAttackTail(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.horizontalCollision) {
            this.doCrescentSpearDamage();
        }
    }

    @Unique
    private void doCrescentSpearDamage() {
        LivingEntity entity = (LivingEntity)this;
        if (this.autoSpinAttackItemStack != null && this.autoSpinAttackItemStack.is(ESItems.CRESCENT_SPEAR.get()) && !entity.level().isClientSide) {
            Level living2;
            for (Level living2 : entity.level().getNearbyEntities(LivingEntity.class, TargetingConditions.DEFAULT, entity, entity.getBoundingBox().inflate(3.0))) {
                if (living2.isAlliedTo((Entity)entity) || !(entity instanceof Player)) continue;
                Player player = (Player)entity;
                player.attack((Entity)living2);
            }
            living2 = entity.level();
            if (living2 instanceof ServerLevel) {
                int i;
                ServerLevel serverLevel = (ServerLevel)living2;
                for (i = 0; i < 40; ++i) {
                    serverLevel.sendParticles((ParticleOptions)ESGlowParticleOptions.GLOW, entity.getX() + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth() * 2.0, entity.getRandomY(), entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth() * 2.0, 3, 0.2, 0.2, 0.2, 0.0);
                }
                for (i = 0; i < 10; ++i) {
                    Vec3 speed = new Vec3((double)((entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.1f), (double)(entity.getRandom().nextFloat() * 0.05f), (double)((entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.1f)).normalize();
                    Vec3 centerPos = entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
                    ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.CRESCENT_SPEAR, centerPos.x + speed.x * 1.5, centerPos.y + speed.y * 1.5, centerPos.z + speed.z * 1.5, speed.x, speed.y, speed.z));
                }
                ScreenShakeVfx.createInstance((ResourceKey<Level>)entity.level().dimension(), entity.position(), 40.0f, 50, 0.12f, 0.24f, 3.0f, 5.5f).send(serverLevel);
            }
        }
    }

    @Inject(method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/food/FoodProperties;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")})
    private void eat(Level level, ItemStack itemStack, FoodProperties foodProperties, CallbackInfoReturnable<ItemStack> cir) {
        if (itemStack.is(ESItems.LUNARIS_CACTUS_GEL.get())) {
            ArrayList<Holder> effectsToRemove = new ArrayList<Holder>();
            for (MobEffectInstance effectInstance : this.getActiveEffects()) {
                if (((MobEffect)effectInstance.getEffect().value()).isBeneficial()) continue;
                effectsToRemove.add(effectInstance.getEffect());
            }
            for (Holder effect : effectsToRemove) {
                if (!this.hasEffect((Holder<MobEffect>)effect)) continue;
                this.removeEffect((Holder<MobEffect>)effect);
            }
        } else if (itemStack.is(ESItems.PUNGENCY_STEW.get())) {
            this.removeEffect((Holder<MobEffect>)MobEffects.HUNGER);
        }
    }

    @Inject(method={"onClimbable()Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void onClimbable(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (this.hasEffect(ESMobEffects.STICKY.asHolder())) {
            boolean climbable = false;
            AABB box = livingEntity.getBoundingBox();
            BlockPos fromPos = BlockPos.containing((double)(box.minX - 0.001), (double)(box.minY + 1.0E-7), (double)(box.minZ - 0.001));
            BlockPos toPos = BlockPos.containing((double)(box.maxX + 0.001), (double)(box.maxY - 1.0E-7), (double)(box.maxZ + 0.001));
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int i = fromPos.getX(); i <= toPos.getX(); ++i) {
                for (int j = fromPos.getY(); j <= toPos.getY(); ++j) {
                    for (int k = fromPos.getZ(); k <= toPos.getZ(); ++k) {
                        mutableBlockPos.set(i, j, k);
                        if (!livingEntity.level().getBlockState((BlockPos)mutableBlockPos).isCollisionShapeFullBlock((BlockGetter)livingEntity.level(), (BlockPos)mutableBlockPos)) continue;
                        climbable = true;
                    }
                }
            }
            if (climbable) {
                this.lastClimbablePos = Optional.of(livingEntity.blockPosition());
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"tickEffects()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;updateGlowingStatus()V", shift=At.Shift.AFTER)})
    private void tickEffects(CallbackInfo ci) {
        CompoundTag tag;
        float damage;
        LivingEntity livingEntity = (LivingEntity)this;
        if (!this.hasEffect(ESMobEffects.NUMBNESS.asHolder()) && (damage = (tag = ESEntityUtil.getPersistentData((Entity)livingEntity)).getFloat("numbness_damage")) != 0.0f) {
            this.hurt(ESDamageTypes.getDamageSource(livingEntity.level(), ESDamageTypes.NUMBNESS), damage);
            tag.putFloat("numbness_damage", 0.0f);
        }
    }

    @Inject(method={"die(Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;gameEvent(Lnet/minecraft/core/Holder;)V", shift=At.Shift.AFTER)})
    private void die(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity.getType().is(ESTags.EntityTypes.STRANGHOUL_PREYS) && this.getKillCredit() instanceof Stranghoul) {
            List players = livingEntity.level().getNearbyPlayers(TargetingConditions.forNonCombat(), livingEntity, livingEntity.getBoundingBox().inflate(20.0));
            for (Player player : players) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ESCriteriaTriggers.WITNESS_STRANGHOUL_HUNT.get().trigger(serverPlayer);
            }
        }
    }
}

