/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.recipe;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.item.recipe.DryingRecipeInput;
import cn.leolezury.eternalstarlight.common.registry.ESRecipeSerializers;
import cn.leolezury.eternalstarlight.common.registry.ESRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record DryingRecipe(Ingredient input, ItemStack output, int durationTicks, boolean fireBelow) implements Recipe<DryingRecipeInput>
{
    public boolean matches(DryingRecipeInput container, Level level) {
        return this.input().test(container.input()) && this.fireBelow() == container.fireBelow();
    }

    public ItemStack assemble(DryingRecipeInput container, HolderLookup.Provider provider) {
        return this.output().copy();
    }

    public boolean canCraftInDimensions(int i, int j) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output();
    }

    public RecipeSerializer<?> getSerializer() {
        return ESRecipeSerializers.DRYING.get();
    }

    public RecipeType<?> getType() {
        return ESRecipes.DRYING.get();
    }

    public static class Serializer
    implements RecipeSerializer<DryingRecipe> {
        private static final MapCodec<DryingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("input").forGetter(DryingRecipe::input), (App)ItemStack.OPTIONAL_CODEC.fieldOf("output").forGetter(DryingRecipe::output), (App)Codec.INT.fieldOf("duration_ticks").forGetter(DryingRecipe::durationTicks), (App)Codec.BOOL.fieldOf("fire_below").forGetter(DryingRecipe::fireBelow)).apply((Applicative)instance, DryingRecipe::new));

        public MapCodec<DryingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DryingRecipe> streamCodec() {
            return new StreamCodec<RegistryFriendlyByteBuf, DryingRecipe>(this){

                public DryingRecipe decode(RegistryFriendlyByteBuf friendlyByteBuf) {
                    Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)friendlyByteBuf);
                    ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)friendlyByteBuf);
                    int durationTicks = friendlyByteBuf.readInt();
                    boolean fireBelow = friendlyByteBuf.readBoolean();
                    return new DryingRecipe(input, output, durationTicks, fireBelow);
                }

                public void encode(RegistryFriendlyByteBuf friendlyByteBuf, DryingRecipe recipe) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)recipe.input());
                    ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)recipe.output());
                    friendlyByteBuf.writeInt(recipe.durationTicks());
                    friendlyByteBuf.writeBoolean(recipe.fireBelow());
                }
            };
        }
    }

    public static class Type
    implements RecipeType<DryingRecipe> {
        public static final ResourceLocation ID = EternalStarlight.id("drying");

        public String toString() {
            return ID.toString();
        }
    }
}

