/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper;

import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.TheGatekeeper;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorPhase;
import cn.leolezury.eternalstarlight.common.entity.misc.ESFallingBlock;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GatekeeperSwingSwordPhase
extends BehaviorPhase<TheGatekeeper> {
    public static final int ID = 6;

    public GatekeeperSwingSwordPhase() {
        super(6, 1, 61, 100);
    }

    @Override
    public boolean canStart(TheGatekeeper entity, boolean cooldownOver) {
        return cooldownOver && this.canReachTarget(entity, 3.0);
    }

    @Override
    public void onStart(TheGatekeeper entity) {
    }

    @Override
    public void tick(TheGatekeeper entity) {
        Level level;
        if (entity.getBehaviorTicks() < 40 && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 pos = entity.position().add(0.0, (double)entity.getBbHeight() * 0.5, 0.0).offsetRandom(entity.getRandom(), 6.0f);
            Vec3 delta = entity.position().add(0.0, (double)entity.getBbHeight() * 0.5, 0.0).subtract(pos).normalize();
            ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket((ParticleOptions)ParticleTypes.CRIT, pos.x, pos.y, pos.z, delta.x, delta.y, delta.z));
        }
        if (entity.getTarget() != null) {
            LivingEntity target = entity.getTarget();
            if (entity.getBehaviorTicks() == 40) {
                for (int x = -4; x <= 4; ++x) {
                    for (int y = -2; y <= 2; ++y) {
                        for (int z = -4; z <= 4; ++z) {
                            BlockPos pos = entity.blockPosition().offset(x, y, z);
                            if (!entity.level().getBlockState(pos.above()).isAir() || !(pos.getCenter().distanceTo(entity.position()) <= 4.0)) continue;
                            ESFallingBlock fallingBlock = new ESFallingBlock(entity.level(), (float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f, entity.level().getBlockState(pos), 100, false);
                            fallingBlock.push(0.0, entity.getRandom().nextDouble() / 12.0 + 0.2, 0.0);
                            entity.level().addFreshEntity((Entity)fallingBlock);
                            if (!fallingBlock.getBoundingBox().intersects(target.getBoundingBox()) || this.canReachTarget(entity, 2.0)) continue;
                            target.hurtMarked = true;
                            target.setDeltaMovement(target.getDeltaMovement().add(entity.position().subtract(target.position()).normalize().scale(0.5)));
                        }
                    }
                }
            }
            if (entity.getBehaviorTicks() >= 47 && entity.getBehaviorTicks() <= 51 && this.performMeleeAttack(entity, 3.0)) {
                target.hurtMarked = true;
                target.setDeltaMovement(target.getDeltaMovement().add(entity.position().subtract(target.position()).normalize().scale(-3.0).add(0.0, 0.2, 0.0)));
            }
        }
    }

    @Override
    public boolean canContinue(TheGatekeeper entity) {
        return true;
    }

    @Override
    public void onStop(TheGatekeeper entity) {
    }
}

