/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss;

import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.entity.living.phase.MultiBehaviorUser;
import cn.leolezury.eternalstarlight.common.item.component.ResourceKeyComponent;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;

public class ESBoss
extends Monster
implements MultiBehaviorUser {
    private static final String TAG_INITIAL_X = "initial_x";
    private static final String TAG_INITIAL_Y = "initial_y";
    private static final String TAG_INITIAL_Z = "initial_z";
    private static final String TAG_SPAWNED = "spawned";
    private static final String TAG_PHASE = "phase";
    private static final String TAG_ACTIVATED = "activated";
    protected final List<String> fightParticipants = new ArrayList<String>();
    protected static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.defineId(ESBoss.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> BEHAVIOR_STATE = SynchedEntityData.defineId(ESBoss.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> BEHAVIOR_TICKS = SynchedEntityData.defineId(ESBoss.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Boolean> ACTIVATED = SynchedEntityData.defineId(ESBoss.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private Vec3 initialPos = Vec3.ZERO;
    private boolean spawned = false;

    protected ESBoss(EntityType<? extends ESBoss> type, Level level) {
        super(type, level);
        if (level.isClientSide) {
            ClientHandlers.BOSSES.add((Mob)this);
        }
    }

    public int getPhase() {
        return (Integer)this.getEntityData().get(PHASE);
    }

    public void setPhase(int phase) {
        this.getEntityData().set(PHASE, (Object)phase);
    }

    @Override
    public int getBehaviorState() {
        return (Integer)this.getEntityData().get(BEHAVIOR_STATE);
    }

    @Override
    public void setBehaviorState(int behaviourState) {
        this.getEntityData().set(BEHAVIOR_STATE, (Object)behaviourState);
    }

    @Override
    public int getBehaviorTicks() {
        return (Integer)this.getEntityData().get(BEHAVIOR_TICKS);
    }

    @Override
    public void setBehaviorTicks(int behaviourTicks) {
        this.getEntityData().set(BEHAVIOR_TICKS, (Object)behaviourTicks);
    }

    public boolean isActivated() {
        return (Boolean)this.getEntityData().get(ACTIVATED);
    }

    public void setActivated(boolean activated) {
        this.getEntityData().set(ACTIVATED, (Object)activated);
        if (activated) {
            this.setBehaviorState(0);
            this.setBehaviorTicks(0);
        }
    }

    public Vec3 getInitialPos() {
        return this.initialPos;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BEHAVIOR_STATE, (Object)0).define(BEHAVIOR_TICKS, (Object)0).define(PHASE, (Object)0).define(ACTIVATED, (Object)true);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.initialPos = new Vec3(compoundTag.getDouble(TAG_INITIAL_X), compoundTag.getDouble(TAG_INITIAL_Y), compoundTag.getDouble(TAG_INITIAL_Z));
        this.spawned = compoundTag.getBoolean(TAG_SPAWNED);
        this.setPhase(compoundTag.getInt(TAG_PHASE));
        if (compoundTag.contains(TAG_ACTIVATED, 3)) {
            this.setActivated(compoundTag.getBoolean(TAG_ACTIVATED));
        }
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putDouble(TAG_INITIAL_X, this.initialPos.x);
        compoundTag.putDouble(TAG_INITIAL_Y, this.initialPos.y);
        compoundTag.putDouble(TAG_INITIAL_Z, this.initialPos.z);
        compoundTag.putBoolean(TAG_SPAWNED, this.spawned);
        compoundTag.putInt(TAG_PHASE, this.getPhase());
        compoundTag.putBoolean(TAG_ACTIVATED, this.isActivated());
    }

    public boolean hurt(DamageSource source, float amount) {
        ServerPlayer player;
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurt(source, amount);
        }
        if (source.equals(this.level().damageSources().fall())) {
            return false;
        }
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer && !this.fightParticipants.contains((player = (ServerPlayer)entity).getName().getString())) {
            this.fightParticipants.add(player.getName().getString());
        }
        return super.hurt(source, Math.min(amount, 20.0f));
    }

    public void die(DamageSource source) {
        Object object;
        if (!this.level().isClientSide && (object = this.level().getServer()) instanceof MinecraftServer) {
            MinecraftServer server = object;
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                for (String name : this.fightParticipants) {
                    if (!player.getName().getString().equals(name) || !player.isAlive() || player.level().dimension() != this.level().dimension()) continue;
                    CriteriaTriggers.PLAYER_KILLED_ENTITY.trigger(player, (Entity)this, source);
                }
            }
        }
        super.die(source);
    }

    public boolean removeWhenFarAway(double dist) {
        return false;
    }

    public boolean canChangeDimensions(Level level, Level level1) {
        return false;
    }

    public boolean startRiding(Entity entity, boolean bl) {
        return false;
    }

    public boolean canBossMove() {
        return true;
    }

    public void initializeBoss() {
        this.initialPos = this.position();
    }

    public boolean shouldPlayBossMusic() {
        return this.isAlive();
    }

    public SoundEvent getBossMusic() {
        return ESSoundEvents.MUSIC_BOSS.get();
    }

    public ResourceKey<LootTable> getBossLootTable() {
        ResourceLocation resourcelocation = BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getType());
        ResourceLocation lootTable = resourcelocation.withPrefix("bosses/");
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTable);
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource damageSource, boolean bl) {
        super.dropCustomDeathLoot(serverLevel, damageSource, bl);
        if (!this.level().isClientSide) {
            for (Player player : this.level().players()) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!this.fightParticipants.stream().anyMatch(s -> s.equals(player.getName().getString())) || !player.isAlive()) continue;
                ItemStack lootBag = new ItemStack((ItemLike)ESItems.LOOT_BAG.get());
                lootBag.applyComponentsAndValidate(DataComponentPatch.builder().set(ESDataComponents.LOOT_TABLE.get(), new ResourceKeyComponent<LootTable>(this.getBossLootTable())).build());
                ItemEntity item = player.spawnAtLocation(lootBag);
                if (item != null) {
                    item.setGlowingTag(true);
                    item.setExtendedLifetime();
                }
                this.dropExtraLoot(serverPlayer);
            }
        }
    }

    public void dropExtraLoot(ServerPlayer player) {
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (!this.spawned) {
                this.initializeBoss();
                this.spawned = true;
            }
            if (!this.canBossMove()) {
                this.setPos(this.initialPos.x, this.position().y, this.initialPos.z);
            }
        }
    }
}

