/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.data;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.data.ESBiomes;
import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.entity.living.animal.EntVariant;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class ESEntVariants {
    public static final ResourceKey<EntVariant> LUNAR = ESEntVariants.create("lunar");
    public static final ResourceKey<EntVariant> NORTHLAND = ESEntVariants.create("northland");
    public static final ResourceKey<EntVariant> SCARLET = ESEntVariants.create("scarlet");
    public static final ResourceKey<EntVariant> STARLIGHT_MANGROVE = ESEntVariants.create("starlight_mangrove");

    public static void bootstrap(BootstrapContext<EntVariant> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        context.register(LUNAR, (Object)new EntVariant((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(ESBiomes.STARLIGHT_FOREST), biomes.getOrThrow(ESBiomes.STARLIGHT_DENSE_FOREST)}), ESItems.LUNAR_LEAVES.asHolder(), EternalStarlight.id("textures/entity/ent/lunar")));
        context.register(NORTHLAND, (Object)new EntVariant((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(ESBiomes.STARLIGHT_PERMAFROST_FOREST)}), ESItems.NORTHLAND_LEAVES.asHolder(), EternalStarlight.id("textures/entity/ent/northland")));
        context.register(SCARLET, (Object)new EntVariant((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(ESBiomes.SCARLET_FOREST)}), ESItems.SCARLET_LEAVES.asHolder(), EternalStarlight.id("textures/entity/ent/scarlet")));
        context.register(STARLIGHT_MANGROVE, (Object)new EntVariant((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(ESBiomes.DARK_SWAMP)}), ESItems.STARLIGHT_MANGROVE_LEAVES.asHolder(), EternalStarlight.id("textures/entity/ent/starlight_mangrove")));
    }

    public static ResourceKey<EntVariant> create(String name) {
        return ResourceKey.create(ESRegistries.ENT_VARIANT, (ResourceLocation)EternalStarlight.id(name));
    }
}

