/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.entity.TinyCreteorModel;
import cn.leolezury.eternalstarlight.common.client.renderer.layer.TinyCreteorPowerLayer;
import cn.leolezury.eternalstarlight.common.entity.living.monster.TinyCreteor;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TinyCreteorRenderer<T extends TinyCreteor>
extends MobRenderer<T, TinyCreteorModel<T>> {
    private static final ResourceLocation ENTITY_TEXTURE = EternalStarlight.id("textures/entity/tiny_creteor.png");

    public TinyCreteorRenderer(EntityRendererProvider.Context context) {
        super(context, new TinyCreteorModel(context.bakeLayer(TinyCreteorModel.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new TinyCreteorPowerLayer(this, context.getModelSet()));
    }

    protected void scale(T entity, PoseStack poseStack, float f) {
        float swell = ((TinyCreteor)((Object)entity)).getSwellProgress(f);
        float factor = 1.0f + Mth.sin((float)(swell * 200.0f)) * swell * 0.05f;
        swell = Mth.clamp((float)swell, (float)0.0f, (float)1.0f);
        swell *= swell;
        swell *= swell;
        float xz = (1.0f + swell * 0.4f) * factor;
        float y = (1.0f + swell * 0.1f) / factor;
        poseStack.scale(xz, y, xz);
    }

    protected float getWhiteOverlayProgress(T entity, float f) {
        float swell = ((TinyCreteor)((Object)entity)).getSwellProgress(f);
        return (int)(swell * 40.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)swell, (float)0.05f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return ENTITY_TEXTURE;
    }
}

