/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.particle.effect;

import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.particle.ESGlowParticleOptions;
import cn.leolezury.eternalstarlight.common.util.Color;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ESGlowParticle
extends TextureSheetParticle {
    protected SpriteSet sprites;
    private final float rotSpeed;
    private float fadeR;
    private float fadeG;
    private float fadeB;

    protected ESGlowParticle(ClientLevel level, float lifeMultiplier, double x, double y, double z, double dx, double dy, double dz, int fromColor, int toColor, float alpha, SpriteSet spriteSet) {
        super(level, x, y, z, dx, dy, dz);
        this.xd = dx;
        this.yd = dy;
        this.zd = dz;
        this.rotSpeed = (float)(Math.random() * (double)0.05f + (double)0.075f);
        this.lifetime = (int)((float)((int)(Math.random() * 20.0) + 40) * lifeMultiplier);
        this.alpha = alpha;
        this.setColor(fromColor);
        this.setFadeColor(toColor);
        this.setSpriteFromAge(spriteSet);
        this.sprites = spriteSet;
    }

    public void setColor(int i) {
        float f = (float)((i & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((i & 0xFF00) >> 8) / 255.0f;
        float h = (float)(i & 0xFF) / 255.0f;
        this.setColor(f, g, h);
    }

    public void setFadeColor(int i) {
        this.fadeR = (float)((i & 0xFF0000) >> 16) / 255.0f;
        this.fadeG = (float)((i & 0xFF00) >> 8) / 255.0f;
        this.fadeB = (float)(i & 0xFF) / 255.0f;
    }

    public void tick() {
        super.tick();
        this.oRoll = this.roll;
        this.roll += this.rotSpeed;
        this.setSpriteFromAge(this.sprites);
        if (this.age > this.lifetime / 2) {
            this.rCol += (this.fadeR - this.rCol) * 0.2f;
            this.gCol += (this.fadeG - this.gCol) * 0.2f;
            this.bCol += (this.fadeB - this.bCol) * 0.2f;
        }
    }

    public int getLightColor(float f) {
        return 0xF000F0;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float f) {
        float a = this.alpha;
        float progress = Math.min((float)this.age + f, (float)this.lifetime) / (float)this.lifetime;
        this.alpha = Mth.lerp((float)((float)Math.pow(Math.abs((double)progress - 0.5) * 2.0, 5.0)), (float)this.alpha, (float)0.0f);
        super.render(ClientHandlers.DELAYED_BUFFER_SOURCE.getBuffer(ESRenderType.GLOW_PARTICLE), camera, f);
        this.alpha = a;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public static class Provider
    implements ParticleProvider<ESGlowParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(ESGlowParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ESGlowParticle(level, options.lifeScale(), x, y, z, xSpeed, ySpeed, zSpeed, Color.rgbd(options.fromColor().x / 255.0f, options.fromColor().y / 255.0f, options.fromColor().z / 255.0f).rgb(), Color.rgbd(options.toColor().x / 255.0f, options.toColor().y / 255.0f, options.toColor().z / 255.0f).rgb(), options.alpha(), this.sprites);
        }
    }
}

