/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.ThirstWalkerAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.monster.ThirstWalker;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ThirstWalkerModel<T extends ThirstWalker>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("thirst_walker"), "main");
    private final ModelPart root;
    private final ModelPart head;

    public ThirstWalkerModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("body").getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 26).addBox(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(24, 18).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)-1.0f));
        head.addOrReplaceChild("head_outer", CubeListBuilder.create().texOffs(0, 11).addBox(-4.0f, -7.0f, -8.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)4.0f));
        PartDefinition crystals = body.addOrReplaceChild("crystals", CubeListBuilder.create().texOffs(-11, 0).addBox(-5.5f, 0.0f, -2.0f, 11.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)1.0f, (float)0.6109f, (float)0.5236f, (float)-0.6109f));
        crystals.addOrReplaceChild("rotated", CubeListBuilder.create().texOffs(-11, 0).addBox(-5.5f, 0.0f, -2.0f, 11.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f));
        body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(24, 30).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 23.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)-8.0f, (float)0.0f));
        body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(24, 30).mirror().addBox(-1.0f, -1.0f, -1.0f, 2.0f, 23.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-5.0f, (float)-8.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(32, 30).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 20.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)4.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(32, 30).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 20.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.0f, (float)4.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.animate(((ThirstWalker)entity).idleAnimationState, ThirstWalkerAnimation.IDLE, ageInTicks);
        this.animateWalk(ThirstWalkerAnimation.WALK, limbSwing, limbSwingAmount, 2.5f, 1.2f);
        this.animate(((ThirstWalker)entity).meleeAnimationState, ((ThirstWalker)entity).isIntentionalAttack() ? ThirstWalkerAnimation.INTENTIONAL_ATTACK : ThirstWalkerAnimation.ATTACK, ageInTicks);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

