/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.helper;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ClientWeatherState;
import cn.leolezury.eternalstarlight.common.client.book.Book;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponentDefinition;
import cn.leolezury.eternalstarlight.common.client.book.component.DisplayBookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.IndexBookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.TextBookComponent;
import cn.leolezury.eternalstarlight.common.client.gui.screen.BookScreen;
import cn.leolezury.eternalstarlight.common.client.gui.screen.CrestSelectionScreen;
import cn.leolezury.eternalstarlight.common.client.gui.toast.BookUnlockToast;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.client.helper.ClientHelper;
import cn.leolezury.eternalstarlight.common.client.particle.advanced.AdvancedParticleOptions;
import cn.leolezury.eternalstarlight.common.entity.interfaces.StarlightWitch;
import cn.leolezury.eternalstarlight.common.entity.projectile.SoulitSpectator;
import cn.leolezury.eternalstarlight.common.network.ClientDismountPacket;
import cn.leolezury.eternalstarlight.common.network.ClientMountPacket;
import cn.leolezury.eternalstarlight.common.network.NoParametersPacket;
import cn.leolezury.eternalstarlight.common.network.OpenCrestGuiPacket;
import cn.leolezury.eternalstarlight.common.network.OpenStarlightStoryPacket;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.network.UpdateCameraPacket;
import cn.leolezury.eternalstarlight.common.network.UpdateStarlightStoryPacket;
import cn.leolezury.eternalstarlight.common.network.UpdateWitchTypePacket;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.registry.ESWeathers;
import cn.leolezury.eternalstarlight.common.spell.ManaType;
import cn.leolezury.eternalstarlight.common.util.Color;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.util.Easing;
import cn.leolezury.eternalstarlight.common.util.SmoothSegmentedValue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class ClientSideHelper
implements ClientHelper {
    @Override
    public void handleS2cNoParam(NoParametersPacket packet) {
        switch (packet.id()) {
            case "cancel_weather": {
                ClientWeatherState.weather = null;
            }
        }
    }

    @Override
    public void handleParticlePacket(ParticlePacket packet) {
        ClientLevel clientLevel = Minecraft.getInstance().level;
        if (clientLevel != null) {
            clientLevel.addParticle(packet.particle(), true, packet.x(), packet.y(), packet.z(), packet.dx(), packet.dy(), packet.dz());
        }
    }

    @Override
    public void handleOpenCrestGui(OpenCrestGuiPacket packet) {
        if (packet.ownedCrests().crests().isEmpty()) {
            if (Minecraft.getInstance().player != null) {
                Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"message.eternal_starlight.no_crest"), true);
            }
        } else {
            Minecraft.getInstance().setScreen((Screen)new CrestSelectionScreen(packet.crests().crests(), packet.ownedCrests().crests()));
        }
    }

    @Override
    public void handleUpdateCamera(UpdateCameraPacket packet) {
        Entity camera;
        if (packet.cameraId() == -1) {
            ClientHandlers.resetCameraIn = 0;
        } else if (Minecraft.getInstance().level != null && !(Minecraft.getInstance().getCameraEntity() instanceof SoulitSpectator) && (camera = Minecraft.getInstance().level.getEntity(packet.cameraId())) != null) {
            ClientHandlers.resetCameraIn = 260;
            Minecraft.getInstance().options.hideGui = true;
            Minecraft.getInstance().setCameraEntity(camera);
        }
    }

    @Override
    public void handleClientMount(ClientMountPacket packet) {
        if (Minecraft.getInstance().level != null) {
            Entity rider = Minecraft.getInstance().level.getEntity(packet.riderId());
            Entity vehicle = Minecraft.getInstance().level.getEntity(packet.vehicleId());
            if (rider != null && vehicle != null) {
                rider.startRiding(vehicle, true);
            }
        }
    }

    @Override
    public void handleClientDismount(ClientDismountPacket packet) {
        Entity rider;
        if (Minecraft.getInstance().level != null && (rider = Minecraft.getInstance().level.getEntity(packet.riderId())) != null) {
            rider.stopRiding();
        }
    }

    @Override
    public void handleUpdateStarlightStory(UpdateStarlightStoryPacket packet) {
        IndexBookComponent oldIndex = this.buildIndex(packet.oldUnlocked());
        IndexBookComponent index = this.buildIndex(packet.unlocked());
        List<Component> oldTexts = oldIndex.getIndexItems().stream().map(IndexBookComponent.IndexItem::originalText).toList();
        ArrayList<Component> newTexts = new ArrayList<Component>(index.getIndexItems().stream().map(IndexBookComponent.IndexItem::originalText).toList());
        newTexts.removeAll(oldTexts);
        if (newTexts.size() > 3) {
            Minecraft.getInstance().getToasts().addToast((Toast)new BookUnlockToast(this.translatedBookText("unlock.multiple")));
        } else {
            for (Component component : newTexts) {
                Minecraft.getInstance().getToasts().addToast((Toast)new BookUnlockToast(component));
            }
        }
    }

    private Component translatedBookText(String id) {
        return Component.translatable((String)("book.eternal_starlight." + id));
    }

    private IndexBookComponent buildIndex(Set<ResourceLocation> unlocked) {
        return new IndexBookComponent(this.translatedBookText("index"), List.of(new IndexBookComponent.IndexItem(this.translatedBookText("main_story_title"), EternalStarlight.id("main_story"), unlocked.contains(EternalStarlight.id("enter_starlight"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESItems.SEEKING_EYE.get().getDescriptionId()), EternalStarlight.id("seeking_eye_display"), unlocked.contains(EternalStarlight.id("enter_starlight"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESItems.ORB_OF_PROPHECY.get().getDescriptionId()), EternalStarlight.id("orb_of_prophecy_display"), unlocked.contains(EternalStarlight.id("enter_starlight"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESEntities.STARLIGHT_GOLEM.get().getDescriptionId()), EternalStarlight.id("starlight_golem_display"), unlocked.contains(EternalStarlight.id("enter_starlight"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESEntities.FREEZE.get().getDescriptionId()), EternalStarlight.id("freeze_display"), unlocked.contains(EternalStarlight.id("freeze"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESEntities.LUNAR_MONSTROSITY.get().getDescriptionId()), EternalStarlight.id("lunar_monstrosity_display"), unlocked.contains(EternalStarlight.id("enter_starlight"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESEntities.TANGLED_HATRED.get().getDescriptionId()), EternalStarlight.id("tangled_hatred_display"), unlocked.contains(EternalStarlight.id("tangled_hatred"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESEntities.TANGLED.get().getDescriptionId()), EternalStarlight.id("tangled_display"), unlocked.contains(EternalStarlight.id("tangled"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESWeathers.METEOR_SHOWER.get().getDescriptionId()), EternalStarlight.id("meteor_shower_display"), unlocked.contains(EternalStarlight.id("enter_starlight"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESEntities.THIRST_WALKER.get().getDescriptionId()), EternalStarlight.id("thirst_walker_display"), unlocked.contains(EternalStarlight.id("thirst_walker"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESItems.DAGGER_OF_HUNGER.get().getDescriptionId()), EternalStarlight.id("dagger_of_hunger_display"), unlocked.contains(EternalStarlight.id("thirst_walker"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESItems.CRYSTALBORN_CATALYST.get().getDescriptionId()), EternalStarlight.id("crystalborn_catalyst_display"), unlocked.contains(EternalStarlight.id("thirst_walker"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESEntities.STRANGHOUL.get().getDescriptionId()), EternalStarlight.id("stranghoul_display"), unlocked.contains(EternalStarlight.id("stranghoul"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESItems.PUNGENCY_FRUIT.get().getDescriptionId()), EternalStarlight.id("pungency_fruit_display"), unlocked.contains(EternalStarlight.id("stranghoul")) || unlocked.contains(EternalStarlight.id("pungency_fruit"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESItems.SILVER_PUNGENCY_FRUIT.get().getDescriptionId()), EternalStarlight.id("silver_pungency_fruit_display"), unlocked.contains(EternalStarlight.id("stranghoul")) || unlocked.contains(EternalStarlight.id("pungency_fruit"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESItems.SEEDS_LAUNCHER.get().getDescriptionId()), EternalStarlight.id("seeds_launcher_display"), unlocked.contains(EternalStarlight.id("stranghoul"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESItems.DRYING_RACK.get().getDescriptionId()), EternalStarlight.id("drying_rack_display"), unlocked.contains(EternalStarlight.id("drying_rack"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESEntities.TWILIGHT_GAZE.get().getDescriptionId()), EternalStarlight.id("twilight_gaze_display"), unlocked.contains(EternalStarlight.id("twilight_gaze"))), new IndexBookComponent.IndexItem((Component)Component.translatable((String)ESEntities.SHIMMER_LACEWING.get().getDescriptionId()), EternalStarlight.id("shimmer_lacewing_display"), unlocked.contains(EternalStarlight.id("shimmer_lacewing")))), 105, 125);
    }

    @Override
    public void handleOpenStarlightStory(OpenStarlightStoryPacket packet) {
        DisplayBookComponent title = new DisplayBookComponent(105, 130).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 92, 96, 11).textDisplay((Component)Component.translatable((String)ESItems.BOOK.get().getDescriptionId()), 52, 115, 1.2f);
        TextBookComponent preface = new TextBookComponent(this.translatedBookText("preface"), false, 105, 125);
        IndexBookComponent index = this.buildIndex(packet.unlocked());
        TextBookComponent mainStory = new TextBookComponent(this.translatedBookText("main_story"), 105, 125);
        DisplayBookComponent seekingEyeDisplay = new DisplayBookComponent(105, 130).textDisplay((Component)Component.translatable((String)ESItems.SEEKING_EYE.get().getDescriptionId()), 52, 28, 1.0f).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 45, 96, 11).imageDisplay(EternalStarlight.id("textures/gui/screen/book/slot.png"), 36, 74, 32, 32).itemDisplay(ESItems.SEEKING_EYE.get().getDefaultInstance(), 44, 82);
        TextBookComponent seekingEye = new TextBookComponent(this.translatedBookText("seeking_eye"), 105, 125);
        DisplayBookComponent orbDisplay = new DisplayBookComponent(105, 130).textDisplay((Component)Component.translatable((String)ESItems.ORB_OF_PROPHECY.get().getDescriptionId()), 52, 28, 1.0f).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 45, 96, 11).imageDisplay(EternalStarlight.id("textures/gui/screen/book/slot.png"), 36, 74, 32, 32).itemDisplay(ESItems.ORB_OF_PROPHECY.get().getDefaultInstance(), 44, 82);
        TextBookComponent orb = new TextBookComponent(this.translatedBookText("orb_of_prophecy"), 105, 125);
        DisplayBookComponent golemDisplay = new DisplayBookComponent(105, 130).entityDisplay(ESEntities.STARLIGHT_GOLEM.get(), 52, 75, -25.0f, 210.0f, 20.0f, new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI)).imageDisplay(EternalStarlight.id("textures/gui/screen/book/frame.png"), 18, 20, 68, 68).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 92, 96, 11).textDisplay((Component)Component.translatable((String)ESEntities.STARLIGHT_GOLEM.get().getDescriptionId()), 52, 115, 1.2f);
        DisplayBookComponent golemLocator = new DisplayBookComponent(105, 130).textDisplay(this.translatedBookText("locators"), 52, 28, 1.0f).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 45, 96, 11).imageDisplay(EternalStarlight.id("textures/gui/screen/book/slot.png"), 36, 74, 32, 32).itemTagDisplay(ESTags.Items.GOLEM_FORGE_LOCATORS, 44, 82);
        TextBookComponent golem = new TextBookComponent(this.translatedBookText("starlight_golem"), 105, 125);
        TextBookComponent golemSeen = new TextBookComponent(this.translatedBookText("starlight_golem_seen"), 105, 125);
        DisplayBookComponent freezeDisplay = new DisplayBookComponent(105, 130).entityDisplay(ESEntities.FREEZE.get(), 52, 80, -25.0f, 210.0f, 40.0f, new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI)).imageDisplay(EternalStarlight.id("textures/gui/screen/book/frame.png"), 18, 20, 68, 68).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 92, 96, 11).textDisplay((Component)Component.translatable((String)ESEntities.FREEZE.get().getDescriptionId()), 52, 115, 1.2f);
        TextBookComponent freeze = new TextBookComponent(this.translatedBookText("freeze"), 105, 125);
        DisplayBookComponent lunarMonstrosityDisplay = new DisplayBookComponent(105, 130).entityDisplay(ESEntities.LUNAR_MONSTROSITY.get(), 52, 80, -25.0f, 210.0f, 16.0f, new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI)).imageDisplay(EternalStarlight.id("textures/gui/screen/book/frame.png"), 18, 20, 68, 68).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 92, 96, 11).textDisplay((Component)Component.translatable((String)ESEntities.LUNAR_MONSTROSITY.get().getDescriptionId()), 52, 115, 1.1f);
        DisplayBookComponent lunarMonstrosityLocator = new DisplayBookComponent(105, 130).textDisplay(this.translatedBookText("locators"), 52, 28, 1.0f).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 45, 96, 11).imageDisplay(EternalStarlight.id("textures/gui/screen/book/slot.png"), 36, 74, 32, 32).itemTagDisplay(ESTags.Items.CURSED_GARDEN_LOCATORS, 44, 82);
        TextBookComponent lunarMonstrosity = new TextBookComponent(this.translatedBookText("lunar_monstrosity"), 105, 125);
        TextBookComponent lunarMonstrositySeen = new TextBookComponent(this.translatedBookText("lunar_monstrosity_seen"), 105, 125);
        DisplayBookComponent tangledHatredDisplay = new DisplayBookComponent(105, 130).textDisplay((Component)Component.translatable((String)ESEntities.TANGLED_HATRED.get().getDescriptionId()), 52, 28, 1.0f).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 45, 96, 11).imageDisplay(EternalStarlight.id("textures/gui/screen/book/slot.png"), 36, 74, 32, 32).itemDisplay(ESItems.TENACIOUS_VINE.get().getDefaultInstance(), 44, 82);
        TextBookComponent tangledHatred = new TextBookComponent(this.translatedBookText("tangled_hatred"), 105, 125);
        DisplayBookComponent tangledDisplay = new DisplayBookComponent(105, 130).entityDisplay(ESEntities.TANGLED.get(), 52, 80, -25.0f, 210.0f, 30.0f, new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI)).imageDisplay(EternalStarlight.id("textures/gui/screen/book/frame.png"), 18, 20, 68, 68).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 92, 96, 11).textDisplay((Component)Component.translatable((String)ESEntities.TANGLED.get().getDescriptionId()), 52, 115, 1.2f);
        TextBookComponent tangled = new TextBookComponent(this.translatedBookText("tangled"), 105, 125);
        DisplayBookComponent meteorShowerDisplay = new DisplayBookComponent(105, 130).textDisplay((Component)Component.translatable((String)ESWeathers.METEOR_SHOWER.get().getDescriptionId()), 52, 28, 1.0f).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 45, 96, 11).imageDisplay(EternalStarlight.id("textures/gui/screen/book/slot.png"), 36, 74, 32, 32).itemDisplay(ESItems.RAW_AETHERSENT.get().getDefaultInstance(), 44, 82);
        TextBookComponent meteorShower = new TextBookComponent(this.translatedBookText("meteor_shower"), 105, 125);
        DisplayBookComponent thirstWalkerDisplay = new DisplayBookComponent(105, 130).entityDisplay(ESEntities.THIRST_WALKER.get(), 52, 80, 0.0f, 210.0f, 25.0f, new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI)).imageDisplay(EternalStarlight.id("textures/gui/screen/book/frame.png"), 18, 20, 68, 68).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 92, 96, 11).textDisplay((Component)Component.translatable((String)ESEntities.THIRST_WALKER.get().getDescriptionId()), 52, 115, 1.2f);
        TextBookComponent thirstWalker = new TextBookComponent(this.translatedBookText("thirst_walker"), 105, 125);
        DisplayBookComponent daggerOfHungerDisplay = new DisplayBookComponent(105, 130).textDisplay((Component)Component.translatable((String)ESItems.DAGGER_OF_HUNGER.get().getDescriptionId()), 52, 28, 1.0f).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 45, 96, 11).imageDisplay(EternalStarlight.id("textures/gui/screen/book/slot.png"), 36, 74, 32, 32).itemDisplay(ESItems.DAGGER_OF_HUNGER.get().getDefaultInstance(), 44, 82);
        TextBookComponent daggerOfHunger = new TextBookComponent(this.translatedBookText("dagger_of_hunger"), 105, 125);
        DisplayBookComponent crystalbornCatalystDisplay = new DisplayBookComponent(105, 130).textDisplay((Component)Component.translatable((String)ESItems.CRYSTALBORN_CATALYST.get().getDescriptionId()), 52, 28, 1.0f).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 45, 96, 11).imageDisplay(EternalStarlight.id("textures/gui/screen/book/slot.png"), 36, 74, 32, 32).itemDisplay(ESItems.CRYSTALBORN_CATALYST.get().getDefaultInstance(), 44, 82);
        TextBookComponent crystalbornCatalyst = new TextBookComponent(this.translatedBookText("crystalborn_catalyst"), 105, 125);
        DisplayBookComponent stranghoulDisplay = new DisplayBookComponent(105, 130).entityDisplay(ESEntities.STRANGHOUL.get(), 52, 80, -25.0f, 210.0f, 30.0f, new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI)).imageDisplay(EternalStarlight.id("textures/gui/screen/book/frame.png"), 18, 20, 68, 68).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 92, 96, 11).textDisplay((Component)Component.translatable((String)ESEntities.STRANGHOUL.get().getDescriptionId()), 52, 115, 1.2f);
        TextBookComponent stranghoul = new TextBookComponent(this.translatedBookText("stranghoul"), 105, 125);
        DisplayBookComponent pungencyFruitDisplay = new DisplayBookComponent(105, 130).textDisplay((Component)Component.translatable((String)ESItems.PUNGENCY_FRUIT.get().getDescriptionId()), 52, 28, 1.0f).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 45, 96, 11).imageDisplay(EternalStarlight.id("textures/gui/screen/book/slot.png"), 36, 74, 32, 32).itemDisplay(ESItems.PUNGENCY_FRUIT.get().getDefaultInstance(), 44, 82);
        TextBookComponent pungencyFruit = new TextBookComponent(this.translatedBookText("pungency_fruit"), 105, 125);
        DisplayBookComponent silverPungencyFruitDisplay = new DisplayBookComponent(105, 130).textDisplay((Component)Component.translatable((String)ESItems.SILVER_PUNGENCY_FRUIT.get().getDescriptionId()), 52, 28, 1.0f).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 45, 96, 11).imageDisplay(EternalStarlight.id("textures/gui/screen/book/slot.png"), 36, 74, 32, 32).itemDisplay(ESItems.SILVER_PUNGENCY_FRUIT.get().getDefaultInstance(), 44, 82);
        TextBookComponent silverPungencyFruit = new TextBookComponent(this.translatedBookText("silver_pungency_fruit"), 105, 125);
        DisplayBookComponent seedsLauncherDisplay = new DisplayBookComponent(105, 130).textDisplay((Component)Component.translatable((String)ESItems.SEEDS_LAUNCHER.get().getDescriptionId()), 52, 28, 1.0f).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 45, 96, 11).imageDisplay(EternalStarlight.id("textures/gui/screen/book/slot.png"), 36, 74, 32, 32).itemDisplay(ESItems.SEEDS_LAUNCHER.get().getDefaultInstance(), 44, 82);
        TextBookComponent seedsLauncher = new TextBookComponent(this.translatedBookText("seeds_launcher"), 105, 125);
        DisplayBookComponent dryingRackDisplay = new DisplayBookComponent(105, 130).textDisplay((Component)Component.translatable((String)ESItems.DRYING_RACK.get().getDescriptionId()), 52, 28, 1.0f).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 45, 96, 11).imageDisplay(EternalStarlight.id("textures/gui/screen/book/slot.png"), 36, 74, 32, 32).itemDisplay(ESItems.DRYING_RACK.get().getDefaultInstance(), 44, 82);
        TextBookComponent dryingRack = new TextBookComponent(this.translatedBookText("drying_rack"), 105, 125);
        DisplayBookComponent twilightGazeDisplay = new DisplayBookComponent(105, 130).entityDisplay(ESEntities.TWILIGHT_GAZE.get(), 52, 60, 0.0f, 210.0f, 25.0f, new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI)).imageDisplay(EternalStarlight.id("textures/gui/screen/book/frame.png"), 18, 20, 68, 68).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 92, 96, 11).textDisplay((Component)Component.translatable((String)ESEntities.TWILIGHT_GAZE.get().getDescriptionId()), 52, 115, 1.2f);
        TextBookComponent twilightGaze = new TextBookComponent(this.translatedBookText("twilight_gaze"), 105, 125);
        DisplayBookComponent shimmerLacewingDisplay = new DisplayBookComponent(105, 130).entityDisplay(ESEntities.SHIMMER_LACEWING.get(), 52, 65, 0.0f, 210.0f, 25.0f, new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI)).imageDisplay(EternalStarlight.id("textures/gui/screen/book/frame.png"), 18, 20, 68, 68).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 92, 96, 11).textDisplay((Component)Component.translatable((String)ESEntities.SHIMMER_LACEWING.get().getDescriptionId()), 52, 115, 1.2f);
        TextBookComponent shimmerLacewing = new TextBookComponent(this.translatedBookText("shimmer_lacewing"), 105, 125);
        Book book = new Book(Lists.newArrayList((Object[])new BookComponentDefinition[]{new BookComponentDefinition(title, EternalStarlight.id("title"), 11, 6, 5, 6), new BookComponentDefinition(preface, EternalStarlight.id("preface"), 11, 12, 5, 12), new BookComponentDefinition(index, EternalStarlight.id("index"), 11, 12, 5, 12), new BookComponentDefinition(mainStory, EternalStarlight.id("main_story"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(seekingEyeDisplay, EternalStarlight.id("seeking_eye_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(seekingEye, EternalStarlight.id("seeking_eye"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(orbDisplay, EternalStarlight.id("orb_of_prophecy_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(orb, EternalStarlight.id("orb_of_prophecy"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(golemDisplay, EternalStarlight.id("starlight_golem_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(golemLocator, EternalStarlight.id("starlight_golem_locator"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(golem, EternalStarlight.id("starlight_golem"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(golemSeen, EternalStarlight.id("starlight_golem_seen"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("enter_starlight")) && packet.unlocked().contains(EternalStarlight.id("starlight_golem_seen"))), new BookComponentDefinition(freezeDisplay, EternalStarlight.id("freeze_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight")) && packet.unlocked().contains(EternalStarlight.id("freeze"))), new BookComponentDefinition(freeze, EternalStarlight.id("freeze"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("enter_starlight")) && packet.unlocked().contains(EternalStarlight.id("freeze"))), new BookComponentDefinition(lunarMonstrosityDisplay, EternalStarlight.id("lunar_monstrosity_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(lunarMonstrosityLocator, EternalStarlight.id("lunar_monstrosity_locator"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(lunarMonstrosity, EternalStarlight.id("lunar_monstrosity"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(lunarMonstrositySeen, EternalStarlight.id("lunar_monstrosity_seen"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("enter_starlight")) && packet.unlocked().contains(EternalStarlight.id("lunar_monstrosity_seen"))), new BookComponentDefinition(tangledHatredDisplay, EternalStarlight.id("tangled_hatred_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight")) && packet.unlocked().contains(EternalStarlight.id("tangled_hatred"))), new BookComponentDefinition(tangledHatred, EternalStarlight.id("tangled_hatred"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("enter_starlight")) && packet.unlocked().contains(EternalStarlight.id("tangled_hatred"))), new BookComponentDefinition(tangledDisplay, EternalStarlight.id("tangled_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight")) && packet.unlocked().contains(EternalStarlight.id("tangled"))), new BookComponentDefinition(tangled, EternalStarlight.id("tangled"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("enter_starlight")) && packet.unlocked().contains(EternalStarlight.id("tangled"))), new BookComponentDefinition(meteorShowerDisplay, EternalStarlight.id("meteor_shower_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(meteorShower, EternalStarlight.id("meteor_shower"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(thirstWalkerDisplay, EternalStarlight.id("thirst_walker_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("thirst_walker"))), new BookComponentDefinition(thirstWalker, EternalStarlight.id("thirst_walker"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("thirst_walker"))), new BookComponentDefinition(daggerOfHungerDisplay, EternalStarlight.id("dagger_of_hunger_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("thirst_walker"))), new BookComponentDefinition(daggerOfHunger, EternalStarlight.id("dagger_of_hunger"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("thirst_walker"))), new BookComponentDefinition(crystalbornCatalystDisplay, EternalStarlight.id("crystalborn_catalyst_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("thirst_walker"))), new BookComponentDefinition(crystalbornCatalyst, EternalStarlight.id("crystalborn_catalyst"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("thirst_walker"))), new BookComponentDefinition(stranghoulDisplay, EternalStarlight.id("stranghoul_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("stranghoul"))), new BookComponentDefinition(stranghoul, EternalStarlight.id("stranghoul"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("stranghoul"))), new BookComponentDefinition(pungencyFruitDisplay, EternalStarlight.id("pungency_fruit_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("stranghoul")) || packet.unlocked().contains(EternalStarlight.id("pungency_fruit"))), new BookComponentDefinition(pungencyFruit, EternalStarlight.id("pungency_fruit"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("stranghoul")) || packet.unlocked().contains(EternalStarlight.id("pungency_fruit"))), new BookComponentDefinition(silverPungencyFruitDisplay, EternalStarlight.id("silver_pungency_fruit_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("stranghoul")) || packet.unlocked().contains(EternalStarlight.id("pungency_fruit"))), new BookComponentDefinition(silverPungencyFruit, EternalStarlight.id("silver_pungency_fruit"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("stranghoul")) || packet.unlocked().contains(EternalStarlight.id("pungency_fruit"))), new BookComponentDefinition(seedsLauncherDisplay, EternalStarlight.id("seeds_launcher_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("stranghoul"))), new BookComponentDefinition(seedsLauncher, EternalStarlight.id("seeds_launcher"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("stranghoul"))), new BookComponentDefinition(dryingRackDisplay, EternalStarlight.id("drying_rack_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("drying_rack"))), new BookComponentDefinition(dryingRack, EternalStarlight.id("drying_rack"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("drying_rack"))), new BookComponentDefinition(twilightGazeDisplay, EternalStarlight.id("twilight_gaze_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("twilight_gaze"))), new BookComponentDefinition(twilightGaze, EternalStarlight.id("twilight_gaze"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("twilight_gaze"))), new BookComponentDefinition(shimmerLacewingDisplay, EternalStarlight.id("shimmer_lacewing_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("shimmer_lacewing"))), new BookComponentDefinition(shimmerLacewing, EternalStarlight.id("shimmer_lacewing"), 11, 12, 5, 12, packet.unlocked().contains(EternalStarlight.id("shimmer_lacewing")))}), 240, 165, 18, 7, 12, 27, EternalStarlight.id("textures/gui/screen/book/book.png"), EternalStarlight.id("textures/gui/screen/book/book_cover.png"), EternalStarlight.id("textures/gui/screen/book/book_back_cover.png"), EternalStarlight.id("textures/gui/screen/book/book_flip_left.png"), EternalStarlight.id("textures/gui/screen/book/book_flip_right.png"));
        Minecraft.getInstance().setScreen((Screen)new BookScreen(book));
    }

    @Override
    public void handleUpdateWitchType(UpdateWitchTypePacket packet) {
        Entity witch;
        if (Minecraft.getInstance().level != null && (witch = Minecraft.getInstance().level.getEntity(packet.witchId())) instanceof StarlightWitch) {
            StarlightWitch starlightWitch = (StarlightWitch)witch;
            starlightWitch.setWitchType(packet.witchType());
        }
    }

    @Override
    public void spawnStellarRackParticles(Vec3 center) {
        int i;
        if ((double)AdvancedParticleOptions.RANDOM.nextFloat() < 0.3) {
            if (AdvancedParticleOptions.RANDOM.nextBoolean()) {
                float size = (float)(1.0 + ((double)AdvancedParticleOptions.RANDOM.nextFloat() - 0.5) * 0.4);
                new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.1f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.1f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_BACK, 0.1f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.1f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.1f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, (float)((12.0 + ((double)AdvancedParticleOptions.RANDOM.nextFloat() - 0.5) * 10.0) * 0.01745329238474369), (float)((18.0 + ((double)AdvancedParticleOptions.RANDOM.nextFloat() - 0.5) * 10.0) * 0.01745329238474369), 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, size, 0.4f).add(Easing.IN_OUT_BOUNCE, size, 0.0f, 0.6f)).lifetime((int)(40.0 + ((double)AdvancedParticleOptions.RANDOM.nextFloat() - 0.5) * 20.0)).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, 0.11764707f, 0.17764707f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.2682353f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.29882354f, 0.29411766f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)((ParticleType)ESParticles.SHINE.get())), (float)center.x, (float)center.y, (float)center.z);
            }
            for (i = 0; i < 4; ++i) {
                new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.1f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.1f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_BACK, 0.1f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.1f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.1f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, 0.31415927f, 0.62831855f, 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, 0.2f, 0.6f).add(Easing.IN_OUT_BOUNCE, 0.2f, 0.0f, 0.4f)).lifetime((int)(40.0 + ((double)AdvancedParticleOptions.RANDOM.nextFloat() - 0.5) * 20.0)).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, 0.29529414f, 0.23294118f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.14705883f, 0.14588235f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0023529413f, 0.21176472f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)((ParticleType)ESParticles.ADVANCED_GLOW.get())), (float)center.x, (float)center.y, (float)center.z);
            }
        }
        for (i = 0; i < 5; ++i) {
            new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, 0.31415927f, 0.62831855f, 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, 0.15f, 0.5f).add(Easing.IN_OUT_BOUNCE, 0.15f, 0.0f, 0.5f)).lifetime(12).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, 0.29529414f, 0.23294118f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.14705883f, 0.14588235f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0023529413f, 0.21176472f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)((ParticleType)ESParticles.ADVANCED_GLOW.get())), (float)center.x, (float)center.y + 0.45f, (float)center.z);
        }
    }

    @Override
    public void spawnStellarRackItemParticles(Vec3 center) {
        for (int i = 0; i < 5; ++i) {
            new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, 0.31415927f, 0.62831855f, 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, 0.15f, 0.5f).add(Easing.IN_OUT_BOUNCE, 0.15f, 0.0f, 0.5f)).lifetime(12).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, 0.29529414f, 0.23294118f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.14705883f, 0.14588235f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0023529413f, 0.21176472f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)((ParticleType)ESParticles.ADVANCED_GLOW.get())), (float)center.x, (float)center.y, (float)center.z);
        }
    }

    @Override
    public void spawnManaCrystalItemParticles(ManaType type, Vec3 center) {
        for (int i = 0; i < 5; ++i) {
            Vec3 pos = center.offsetRandom(AdvancedParticleOptions.RANDOM, 0.5f);
            Color color = Color.rgb(type.getColor());
            new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, AdvancedParticleOptions.RANDOM.nextFloat() * 0.015f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.nextFloat() - 0.5f) * 0.03f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, 0.31415927f, 0.62831855f, 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, 0.25f, 0.6f).add(Easing.IN_OUT_BOUNCE, 0.25f, 0.0f, 0.4f)).lifetime(12).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, (float)color.r() * 0.4f / 255.0f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (float)color.g() * 0.4f / 255.0f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (float)color.b() * 0.4f / 255.0f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)((ParticleType)ESParticles.ADVANCED_GLOW.get())), (float)pos.x, (float)pos.y, (float)pos.z);
        }
    }
}

