/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.gui.screen;

import cn.leolezury.eternalstarlight.common.client.book.Book;
import cn.leolezury.eternalstarlight.common.client.book.BookAccess;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponentDefinition;
import cn.leolezury.eternalstarlight.common.client.gui.screen.widget.ESPageButton;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BookScreen
extends Screen {
    private final Book book;
    private int pageSize;
    private int currentPage;
    private int mouseX;
    private int mouseY;
    private ESPageButton leftButton;
    private ESPageButton rightButton;

    public BookScreen(Book book) {
        super((Component)Component.empty());
        book.removeDisabled();
        this.book = book;
        this.currentPage = -2;
    }

    protected void init() {
        this.leftButton = (ESPageButton)this.addRenderableWidget((GuiEventListener)new ESPageButton(this.getBaseX(), this.getBaseY() + this.book.height(), this.book, false, true, button -> this.flipLeft()));
        this.rightButton = (ESPageButton)this.addRenderableWidget((GuiEventListener)new ESPageButton(this.getBaseX() + this.book.width() - this.book.buttonWidth(), this.getBaseY() + this.book.height(), this.book, true, true, button -> this.flipRight()));
        this.pageSize = 0;
        for (BookComponentDefinition definition : this.getComponents()) {
            this.pageSize += definition.component().getPageCount(this.pageSize, this.font);
        }
        this.updateVisibility();
    }

    public void mouseMoved(double d, double e) {
        super.mouseMoved(d, e);
        this.mouseX = (int)d;
        this.mouseY = (int)e;
    }

    public boolean mouseClicked(double x, double y, int i) {
        if (this.bookOpened()) {
            BookComponentDefinition left = this.getCurrentComponent(true);
            BookComponentDefinition right = this.getCurrentComponent(false);
            if (left != null) {
                left.component().onClick(this.createBookAccess(true), this.font, this.getBaseX() + left.xOffsetL(), this.getBaseY() + left.yOffsetL(), (int)x, (int)y);
            }
            if (right != null) {
                right.component().onClick(this.createBookAccess(false), this.font, this.getBaseX() + this.book.width() / 2 + right.xOffsetR(), this.getBaseY() + right.yOffsetR(), (int)x, (int)y);
            }
        } else if (this.currentPage < 0) {
            if (x >= (double)((float)this.getBaseX() + (float)this.book.width() / 2.0f) && x <= (double)(this.getBaseX() + this.book.width()) && y >= (double)this.getBaseY() && y <= (double)(this.getBaseY() + this.book.height())) {
                this.setPage(0);
            }
        } else if (x >= (double)this.getBaseX() && x <= (double)((float)this.getBaseX() + (float)this.book.width() / 2.0f) && y >= (double)this.getBaseY() && y <= (double)(this.getBaseY() + this.book.height())) {
            this.setPage(this.pageSize - 1);
        }
        return super.mouseClicked(x, y, i);
    }

    public void tick() {
        if (this.bookOpened()) {
            BookComponentDefinition left = this.getCurrentComponent(true);
            BookComponentDefinition right = this.getCurrentComponent(false);
            if (left != null) {
                left.component().tick(this.createBookAccess(true), this.font, this.getBaseX() + left.xOffsetL(), this.getBaseY() + left.yOffsetL(), this.mouseX, this.mouseY);
            }
            if (right != null) {
                right.component().tick(this.createBookAccess(false), this.font, this.getBaseX() + this.book.width() / 2 + right.xOffsetR(), this.getBaseY() + right.yOffsetR(), this.mouseX, this.mouseY);
            }
            if (left == null || right == null || left.component() != right.component()) {
                if (left != null) {
                    left.component().singleTick(this.createBookAccess(true), this.font, this.getBaseX() + left.xOffsetL(), this.getBaseY() + left.yOffsetL(), this.mouseX, this.mouseY);
                }
                if (right != null) {
                    right.component().singleTick(this.createBookAccess(false), this.font, this.getBaseX() + this.book.width() / 2 + right.xOffsetR(), this.getBaseY() + right.yOffsetR(), this.mouseX, this.mouseY);
                }
            } else {
                left.component().singleTick(this.createBookAccess(true), this.font, this.getBaseX() + left.xOffsetL(), this.getBaseY() + left.yOffsetL(), this.mouseX, this.mouseY);
            }
        }
        this.updateVisibility();
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderBackground(guiGraphics, i, j, f);
        if (this.bookOpened()) {
            guiGraphics.blit(this.book.background(), this.getBaseX(), this.getBaseY(), 0.0f, 0.0f, this.book.width(), this.book.height(), this.book.width(), this.book.height());
            BookComponentDefinition left = this.getCurrentComponent(true);
            BookComponentDefinition right = this.getCurrentComponent(false);
            if (left != null) {
                left.component().render(this.createBookAccess(true), guiGraphics, this.font, this.getBaseX() + left.xOffsetL(), this.getBaseY() + left.yOffsetL(), this.mouseX, this.mouseY);
            }
            if (right != null) {
                right.component().render(this.createBookAccess(false), guiGraphics, this.font, this.getBaseX() + this.book.width() / 2 + right.xOffsetR(), this.getBaseY() + right.yOffsetR(), this.mouseX, this.mouseY);
            }
        } else if (this.currentPage < 0) {
            guiGraphics.blit(this.book.cover(), this.getBaseX() + this.book.width() / 2, this.getBaseY(), 0.0f, 0.0f, this.book.width() / 2, this.book.height(), this.book.width() / 2, this.book.height());
        } else {
            guiGraphics.blit(this.book.backCover(), this.getBaseX(), this.getBaseY(), 0.0f, 0.0f, this.book.width() / 2, this.book.height(), this.book.width() / 2, this.book.height());
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void flipLeft() {
        this.setPage(this.currentPage - 2);
        this.updateVisibility();
    }

    public void flipRight() {
        this.setPage(this.currentPage + 2);
        this.updateVisibility();
    }

    private int getBaseX() {
        return (this.width - this.book.width()) / 2;
    }

    private int getBaseY() {
        return (this.height - this.book.height()) / 2;
    }

    private boolean bookOpened() {
        return this.currentPage >= 0 && this.currentPage < this.pageSize;
    }

    @Nullable
    private BookComponentDefinition getCurrentComponent(boolean left) {
        if (this.getCurrentComponentIndex(left) == -1) {
            return null;
        }
        return this.getComponents().get(this.getCurrentComponentIndex(left));
    }

    private int getCurrentComponentIndex(boolean left) {
        int pages = 0;
        for (int i = 0; i < this.getComponents().size(); ++i) {
            BookComponentDefinition definition = this.getComponents().get(i);
            if ((pages += definition.component().getPageCount(pages, this.font)) < this.currentPage + (left ? 1 : 2)) continue;
            return i;
        }
        return -1;
    }

    private BookAccess createBookAccess(final boolean left) {
        return new BookAccess(){

            @Override
            public int getRelativePage() {
                int pages = 0;
                for (int i = 0; i < this.getComponents().size(); ++i) {
                    int defCount;
                    BookComponentDefinition definition = this.getComponents().get(i);
                    if ((pages += (defCount = definition.component().getPageCount(pages, BookScreen.this.font))) < BookScreen.this.currentPage + (left ? 1 : 2)) continue;
                    return BookScreen.this.currentPage + (left ? 0 : 1) - (pages - defCount);
                }
                return 0;
            }

            @Override
            public boolean isLeftPage() {
                return left;
            }

            @Override
            public void setPage(int page) {
                BookScreen.this.setPage(page);
            }

            @Override
            public List<BookComponentDefinition> getComponents() {
                return BookScreen.this.getComponents();
            }
        };
    }

    private void setPage(int page) {
        this.currentPage = page - page % 2;
    }

    private void updateVisibility() {
        boolean visible;
        this.leftButton.visible = visible = this.bookOpened();
        this.rightButton.visible = visible;
    }

    private List<BookComponentDefinition> getComponents() {
        return this.book.components();
    }
}

