/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.spell.ManaType;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class DuskLightBlockEntity
extends BlockEntity {
    private static final String TAG_FACING = "facing";
    private static final String TAG_LENGTH = "length";
    private static final String TAG_LIT = "lit";
    public static final float MAX_LENGTH = 15.0f;
    private static final List<Direction> ORDER = Arrays.stream(Direction.values()).toList();
    private Direction facing = Direction.UP;
    private float length = 15.0f;
    private int ticksLeft = 0;
    private boolean lit = false;
    private final Object2FloatMap<Direction> beamProgresses = new Object2FloatArrayMap();
    private final Object2FloatMap<Direction> oldBeamProgresses = new Object2FloatArrayMap();

    public DuskLightBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(ESBlockEntities.DUSK_LIGHT.get(), blockPos, blockState);
    }

    public boolean isLit() {
        return this.lit;
    }

    public Object2FloatMap<Direction> getBeamProgresses() {
        return this.beamProgresses;
    }

    public Object2FloatMap<Direction> getOldBeamProgresses() {
        return this.oldBeamProgresses;
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putInt(TAG_FACING, this.facing.get3DDataValue());
        compoundTag.putFloat(TAG_LENGTH, this.length);
        compoundTag.putBoolean(TAG_LIT, this.lit);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.facing = Direction.from3DDataValue((int)compoundTag.getInt(TAG_FACING));
        this.length = compoundTag.getFloat(TAG_LENGTH);
        this.lit = compoundTag.getBoolean(TAG_LIT);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithFullMetadata(provider);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DuskLightBlockEntity entity) {
        if (level.isClientSide) {
            entity.oldBeamProgresses.clear();
            entity.oldBeamProgresses.putAll(entity.beamProgresses);
            for (Direction direction : Direction.values()) {
                if (!entity.beamProgresses.containsKey((Object)direction)) {
                    entity.beamProgresses.put((Object)direction, 0.0f);
                }
                if (direction.equals((Object)entity.facing) && entity.lit) {
                    entity.beamProgresses.put((Object)direction, Mth.clamp((float)(entity.beamProgresses.getFloat((Object)direction) + 0.05f), (float)0.0f, (float)(entity.length / 15.0f)));
                    continue;
                }
                entity.beamProgresses.put((Object)direction, Mth.clamp((float)(entity.beamProgresses.getFloat((Object)direction) - 0.15f), (float)0.0f, (float)1.0f));
            }
            if (entity.lit) {
                EternalStarlight.getClientHelper().spawnManaCrystalItemParticles(ManaType.BLAZE, pos.getCenter().add(new Vec3((double)entity.facing.getStepX(), (double)entity.facing.getStepY(), (double)entity.facing.getStepZ()).scale((double)entity.length)));
            }
        } else {
            float oldLength = entity.length;
            boolean oldLit = entity.lit;
            BlockHitResult result = level.clip(new ClipContext(pos.getCenter().add(new Vec3((double)entity.facing.getStepX(), (double)entity.facing.getStepY(), (double)entity.facing.getStepZ()).scale(0.51)), pos.getCenter().add(new Vec3((double)entity.facing.getStepX(), (double)entity.facing.getStepY(), (double)entity.facing.getStepZ()).scale(15.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
            if (result.getType() != HitResult.Type.MISS) {
                Object object;
                entity.length = (float)result.getLocation().subtract(pos.getCenter()).length();
                if (entity.lit && (object = level.getBlockEntity(result.getBlockPos())) instanceof DuskLightBlockEntity) {
                    DuskLightBlockEntity light = (DuskLightBlockEntity)((Object)object);
                    light.ticksLeft = 5;
                }
                if (level.getBlockState(result.getBlockPos()).is((Block)ESBlocks.ECLIPSE_CORE.get())) {
                    level.destroyBlock(result.getBlockPos(), false);
                }
            } else {
                entity.length = 15.0f;
            }
            if (level.getBlockState(pos.below()).is(ESTags.Blocks.DUSK_LIGHT_ENERGY_SOURCES)) {
                entity.ticksLeft = 5;
            }
            --entity.ticksLeft;
            if (entity.ticksLeft < 0) {
                entity.ticksLeft = 0;
            }
            boolean bl = entity.lit = entity.ticksLeft > 0;
            if (entity.lit) {
                List entities = level.getEntitiesOfClass(Entity.class, new AABB(pos.getCenter().subtract(0.5, 0.5, 0.5), pos.getCenter().relative(entity.facing, (double)entity.length).add(0.5, 0.5, 0.5)));
                for (Entity e : entities) {
                    e.setRemainingFireTicks(Math.max(e.getRemainingFireTicks(), 100));
                }
            }
            if ((double)Math.abs(entity.length - oldLength) < 0.01 || oldLit != entity.lit) {
                entity.markUpdated();
            }
        }
    }

    public void setFacing() {
        this.facing = ORDER.get((ORDER.indexOf(this.facing) + 1) % ORDER.size());
        this.markUpdated();
    }

    private void markUpdated() {
        if (this.getLevel() != null) {
            this.setChanged();
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }
}

