/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fusion;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.text.EnumColor;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.energy.BlockEnergyCapabilityCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityFusionReactorPort
extends TileEntityFusionReactorBlock {
    private final Map<Direction, BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> chemicalCapabilityCaches = new EnumMap<Direction, BlockCapabilityCache<IChemicalHandler, Direction>>(Direction.class);
    private final Map<Direction, BlockEnergyCapabilityCache> energyCapabilityCaches = new EnumMap<Direction, BlockEnergyCapabilityCache>(Direction.class);

    public TileEntityFusionReactorPort(BlockPos pos, BlockState state) {
        super((Holder<Block>)GeneratorsBlocks.FUSION_REACTOR_PORT, pos, state);
        this.delaySupplier = NO_DELAY;
    }

    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getChemicalTanks(side);
    }

    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getFluidTanks(side);
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getEnergyContainers(side);
    }

    @NotNull
    protected IHeatCapacitorHolder getInitialHeatCapacitors(IContentsListener listener, CachedAmbientTemperature ambientTemperature) {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getHeatCapacitors(side);
    }

    public boolean persists(ContainerType<?, ?, ?> type) {
        if (type == ContainerType.CHEMICAL || type == ContainerType.FLUID || type == ContainerType.ENERGY || type == ContainerType.HEAT) {
            return false;
        }
        return super.persists(type);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void addGasTargetCapability(List<MultiblockData.CapabilityOutputTarget<IChemicalHandler>> outputTargets, Direction side) {
        @Nullable BlockCapabilityCache cache = this.chemicalCapabilityCaches.get(side);
        if (cache == null) {
            cache = Capabilities.CHEMICAL.createCache((ServerLevel)this.level, this.worldPosition.relative(side), side.getOpposite());
            this.chemicalCapabilityCaches.put(side, (BlockCapabilityCache<IChemicalHandler, Direction>)cache);
        }
        outputTargets.add((MultiblockData.CapabilityOutputTarget<IChemicalHandler>)new MultiblockData.CapabilityOutputTarget(cache, () -> ((TileEntityFusionReactorPort)this).getActive()));
    }

    public void addEnergyTargetCapability(List<MultiblockData.EnergyOutputTarget> outputTargets, Direction side) {
        BlockEnergyCapabilityCache cache = this.energyCapabilityCaches.get(side);
        if (cache == null) {
            cache = BlockEnergyCapabilityCache.create((ServerLevel)((ServerLevel)this.level), (BlockPos)this.worldPosition.relative(side), (Direction)side.getOpposite());
            this.energyCapabilityCaches.put(side, cache);
        }
        outputTargets.add(new MultiblockData.EnergyOutputTarget(cache, () -> ((TileEntityFusionReactorPort)this).getActive()));
    }

    @Nullable
    public IHeatHandler getAdjacent(@NotNull Direction side) {
        if (this.canHandleHeat() && this.getHeatCapacitorCount(side) > 0 && WorldUtils.getBlockState((BlockGetter)this.level, (BlockPos)this.getBlockPos().relative(side)).filter(state -> !state.is(GeneratorsBlocks.FUSION_REACTOR_PORT)).isPresent()) {
            return this.getAdjacentUnchecked(side);
        }
        return null;
    }

    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            boolean oldMode = this.getActive();
            this.setActive(!oldMode);
            player.displayClientMessage((Component)GeneratorsLang.REACTOR_PORT_EJECT.translateColored(EnumColor.GRAY, new Object[]{BooleanStateDisplay.InputOutput.of((boolean)oldMode, (boolean)true)}), true);
        }
        return InteractionResult.SUCCESS;
    }

    public int getRedstoneLevel() {
        return ((FusionReactorMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }

    public boolean exposesMultiblockToComputer() {
        return false;
    }

    @ComputerMethod(methodDescription="true -> output, false -> input")
    boolean getMode() {
        return this.getActive();
    }

    @ComputerMethod(methodDescription="true -> output, false -> input")
    void setMode(boolean output) {
        this.setActive(output);
    }
}

