/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.common.blockentity;

import cy.jdkdigital.dyenamics.common.block.DyenamicBannerBlock;
import cy.jdkdigital.dyenamics.common.block.DyenamicWallBannerBlock;
import cy.jdkdigital.dyenamics.core.init.BlockEntityInit;
import cy.jdkdigital.dyenamics.core.init.BlockInit;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DyenamicBannerBlockEntity
extends BannerBlockEntity {
    private DyenamicDyeColor baseColor;

    public DyenamicBannerBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
        Block block = state.getBlock();
        if (block instanceof DyenamicBannerBlock) {
            DyenamicBannerBlock dyenamicBannerBlock = (DyenamicBannerBlock)block;
            this.baseColor = dyenamicBannerBlock.getDyenamicColor();
        } else {
            block = state.getBlock();
            if (block instanceof DyenamicWallBannerBlock) {
                DyenamicWallBannerBlock dyenamicBannerBlock = (DyenamicWallBannerBlock)block;
                this.baseColor = dyenamicBannerBlock.getDyenamicColor();
            }
        }
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)BlockEntityInit.BANNER.get();
    }

    public void setDyenamicColor(DyenamicDyeColor color) {
        this.baseColor = color;
    }

    public DyenamicDyeColor getDyenamicColor() {
        return this.baseColor;
    }

    public ItemStack getItem() {
        ItemStack itemstack = new ItemStack((ItemLike)BlockInit.DYED_BLOCKS.get(this.baseColor.getSerializedName()).get("banner").get());
        itemstack.applyComponents(this.collectComponents());
        return itemstack;
    }
}

