/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.network.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.block.microchip.MicrochipBlockEntity;
import net.swedz.little_big_redstone.gui.microchip.MicrochipViewPosition;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;
import net.swedz.little_big_redstone.network.LBRCustomPacket;
import net.swedz.tesseract.neoforge.packet.PacketContext;

public record WriteLogicConfigPacket(BlockPos pos, int slot, LogicComponent component, MicrochipViewPosition returnViewPosition) implements LBRCustomPacket
{
    public static final StreamCodec<ByteBuf, WriteLogicConfigPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, WriteLogicConfigPacket::pos, (StreamCodec)ByteBufCodecs.VAR_INT, WriteLogicConfigPacket::slot, LogicComponent.STREAM_CODEC, WriteLogicConfigPacket::component, MicrochipViewPosition.STREAM_CODEC, WriteLogicConfigPacket::returnViewPosition, WriteLogicConfigPacket::new);

    public void handle(PacketContext context) {
        context.assertServerbound();
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        String playerName = player.getGameProfile().getName();
        BlockEntity blockEntity = player.level().getBlockEntity(this.pos);
        if (blockEntity instanceof MicrochipBlockEntity) {
            MicrochipBlockEntity blockEntity2 = (MicrochipBlockEntity)blockEntity;
            Microchip microchip = blockEntity2.microchip();
            LogicEntry targetComponent = (LogicEntry)microchip.components().get(this.slot);
            if (targetComponent != null && targetComponent.component().type().equals(this.component.type())) {
                ((LogicConfig)targetComponent.component().config()).loadFrom(this.component.config());
                microchip.components().updateValidity();
                int wiresPopped = microchip.wires().cleanup(targetComponent);
                if (wiresPopped > 0) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack(LBRItems.REDSTONE_BIT, wiresPopped));
                }
                microchip.markDirty();
                blockEntity2.openMenu((Player)player, this.returnViewPosition);
            } else {
                LBR.LOGGER.warn("Received WriteLogicConfigPacket from {} targetting mismatching or non-existent component (slot {}), discarding", (Object)playerName, (Object)this.slot);
            }
        } else {
            LBR.LOGGER.warn("Received WriteLogicConfigPacket from {} when targeting non-microchip block entity (at {}), discarding", (Object)playerName, (Object)this.pos.toShortString());
        }
    }
}

