/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.awareness.types;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.swedz.little_big_redstone.block.microchip.MicrochipBlock;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessContext;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessType;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessTypes;
import net.swedz.little_big_redstone.microchip.awareness.MicrochipAwareness;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.object.logic.io.LogicIO;
import net.swedz.little_big_redstone.microchip.object.logic.io.LogicIOConfig;

public final class RedstoneAwareness
extends MicrochipAwareness<RedstoneAwareness> {
    private boolean initialized;
    private boolean[] inputSides = new boolean[6];
    private boolean[] outputSides = new boolean[6];
    private int[] inputPower = new int[6];
    private int[] outputPower = new int[6];
    private int[] outputPowerEvaluated = new int[6];

    public boolean[] getSides() {
        boolean[] sides = new boolean[6];
        for (int index = 0; index < sides.length; ++index) {
            sides[index] = this.inputSides[index] || this.outputSides[index];
        }
        return sides;
    }

    public int getInputPower(Direction direction) {
        return this.inputPower[direction.ordinal()];
    }

    public int getOutputPower(Direction direction) {
        return this.outputPower[direction.ordinal()];
    }

    public void setInputPowered(Direction direction, int signal) {
        int index = direction.ordinal();
        if (signal > 0) {
            this.outputPower[index] = 0;
            this.inputPower[index] = signal;
        } else {
            this.inputPower[index] = 0;
        }
    }

    public boolean setOutputPowered(Direction direction, int signal) {
        int index = direction.ordinal();
        if (signal > this.outputPowerEvaluated[index]) {
            this.inputPower[index] = 0;
            this.outputPowerEvaluated[index] = signal;
            return true;
        }
        return false;
    }

    public int outputRedstoneSignal(BlockState state, Direction direction) {
        int index = (direction = direction.getOpposite()).ordinal();
        boolean powered = this.outputSides[index] && (Boolean)state.getValue((Property)MicrochipBlock.getDirectionalState(direction)) != false;
        return powered ? this.outputPower[index] : 0;
    }

    @Override
    public AwarenessType<RedstoneAwareness> type() {
        return AwarenessTypes.REDSTONE;
    }

    @Override
    public void load(Microchip microchip) {
        boolean[] inputSides = new boolean[6];
        boolean[] outputSides = new boolean[6];
        for (LogicEntry entry : microchip.components()) {
            LogicComponent logicComponent = entry.component();
            if (!(logicComponent instanceof LogicIO)) continue;
            LogicIO io = (LogicIO)logicComponent;
            int direction = ((LogicIOConfig)io.config()).direction.ordinal();
            if (inputSides[direction] || outputSides[direction]) continue;
            if (((LogicIOConfig)io.config()).input) {
                inputSides[direction] = true;
                continue;
            }
            outputSides[direction] = true;
        }
        this.inputSides = inputSides;
        this.outputSides = outputSides;
    }

    @Override
    public void neighborChanged(AwarenessContext context, Block neighborBlock, BlockPos neighborPos, Direction neighborDirection, boolean movedByPiston) {
        Level level = context.level();
        BlockPos pos = context.pos();
        int neighborDirectionIndex = neighborDirection.ordinal();
        if (this.inputSides[neighborDirectionIndex] && !this.outputSides[neighborDirectionIndex]) {
            int signal = level.getSignal(neighborPos, neighborDirection);
            boolean powered = signal > 0;
            this.setInputPowered(neighborDirection, signal);
            level.setBlock(pos, (BlockState)context.state().setValue((Property)MicrochipBlock.getDirectionalState(neighborDirection), (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    @Override
    public void preTick(AwarenessContext context) {
        Level level = context.level();
        BlockPos pos = context.pos();
        if (!this.initialized) {
            int[] inputPower = new int[6];
            for (LogicEntry entry : context.microchip().components()) {
                int signal;
                LogicComponent logicComponent = entry.component();
                if (!(logicComponent instanceof LogicIO)) continue;
                LogicIO io = (LogicIO)logicComponent;
                Direction direction = ((LogicIOConfig)io.config()).direction;
                int directionIndex = direction.ordinal();
                if (!this.inputSides[directionIndex]) continue;
                inputPower[directionIndex] = signal = level.getSignal(pos.relative(direction), direction);
            }
            this.inputPower = inputPower;
            this.initialized = true;
        }
        this.outputPowerEvaluated = new int[6];
    }

    @Override
    public void postTick(AwarenessContext context, boolean microchipDirty, boolean contextDirty) {
        Level level = context.level();
        BlockPos pos = context.pos();
        BlockState state = context.state();
        boolean powerChanged = false;
        for (int index = 0; index < this.outputPowerEvaluated.length; ++index) {
            int signal = this.outputPowerEvaluated[index];
            if (this.outputPower[index] == signal) continue;
            powerChanged = true;
            break;
        }
        this.outputPower = this.outputPowerEvaluated;
        BlockState newState = state;
        for (Direction direction : Direction.values()) {
            int index = direction.ordinal();
            newState = (BlockState)newState.setValue((Property)MicrochipBlock.getDirectionalState(direction), (Comparable)Boolean.valueOf(this.inputPower[index] > 0 || this.outputPower[index] > 0));
        }
        if (powerChanged || newState != state) {
            level.setBlock(pos, newState, 3);
            level.updateNeighborsAt(pos, state.getBlock());
        }
    }
}

