/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.client.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRClientRenderTypes;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.client.model.logic.LogicBakedModel;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.tesseract.neoforge.helper.model.QuadColorFix;

public final class LogicItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private final RandomSource random = RandomSource.create();

    public LogicItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        LogicComponent component = (LogicComponent)stack.get(LBRComponents.LOGIC);
        BakedModel model = ((LogicBakedModel)Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.inventory((ResourceLocation)LBR.id(component.type().id())))).getModel(component);
        int index = 0;
        for (BakedModel modelLayer : model.getRenderPasses(stack, false)) {
            RenderType renderType = index == 2 ? LBRClientRenderTypes.logicScanline() : NeoForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get();
            VertexConsumer buffer = bufferSource.getBuffer(renderType);
            for (BakedQuad quad : modelLayer.getQuads(null, null, this.random, ModelData.EMPTY, null)) {
                QuadColorFix.putBulkData((VertexConsumer)buffer, (PoseStack.Pose)poseStack.last(), (BakedQuad)quad, (int)packedLight, (int)packedOverlay);
            }
            ++index;
        }
    }
}

