/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.storage.soul;

import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockProvider;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.ultramega.refinedtypes.ModInitializer;
import com.ultramega.refinedtypes.RefinedTypesUtil;
import com.ultramega.refinedtypes.registry.BlockEntities;
import com.ultramega.refinedtypes.registry.Menus;
import com.ultramega.refinedtypes.storage.soul.SoulStorageVariant;
import com.ultramega.refinedtypes.type.soul.SoulResourceFactory;
import com.ultramega.refinedtypes.type.soul.SoulResourceType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class SoulStorageBlockProvider
implements StorageBlockProvider {
    private final SoulStorageVariant variant;
    private final Component displayName;

    public SoulStorageBlockProvider(SoulStorageVariant variant) {
        this.variant = variant;
        this.displayName = RefinedTypesUtil.createRefinedTypesTranslation("block", String.format("%s_soul_storage_block", variant.getName()));
    }

    public SerializableStorage createStorage(Runnable runnable) {
        return SoulResourceType.STORAGE_TYPE.create(this.variant.getCapacity(), runnable);
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public long getEnergyUsage() {
        return switch (this.variant) {
            default -> throw new MatchException(null, null);
            case SoulStorageVariant.K_1 -> ModInitializer.getConfig().getSoulStorageBlock().get1KEnergyUsage();
            case SoulStorageVariant.K_8 -> ModInitializer.getConfig().getSoulStorageBlock().get8KEnergyUsage();
            case SoulStorageVariant.K_64 -> ModInitializer.getConfig().getSoulStorageBlock().get64KEnergyUsage();
            case SoulStorageVariant.K_512 -> ModInitializer.getConfig().getSoulStorageBlock().get512KEnergyUsage();
            case SoulStorageVariant.K_4096 -> ModInitializer.getConfig().getSoulStorageBlock().get4096KEnergyUsage();
            case SoulStorageVariant.K_32768 -> ModInitializer.getConfig().getSoulStorageBlock().get32768KEnergyUsage();
            case SoulStorageVariant.K_262144 -> ModInitializer.getConfig().getSoulStorageBlock().get262144KEnergyUsage();
            case SoulStorageVariant.K_2097152 -> ModInitializer.getConfig().getSoulStorageBlock().get2097152KEnergyUsage();
            case SoulStorageVariant.INFINITE -> ModInitializer.getConfig().getSoulStorageBlock().getInfiniteEnergyUsage();
        };
    }

    public ResourceFactory getResourceFactory() {
        return SoulResourceFactory.INSTANCE;
    }

    public BlockEntityType<?> getBlockEntityType() {
        return BlockEntities.getSoulStorageBlock(this.variant);
    }

    public MenuType<?> getMenuType() {
        return Menus.getSoulStorage();
    }
}

