/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.networkenergizer;

import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.Property;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.ultramega.refinedtypes.networkenergizer.NetworkEnergizerBlockEntity;
import com.ultramega.refinedtypes.networkenergizer.NetworkEnergizerData;
import com.ultramega.refinedtypes.networkenergizer.NetworkEnergizerEnergyInfo;
import com.ultramega.refinedtypes.registry.Menus;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class NetworkEnergizerContainerMenu
extends AbstractBaseContainerMenu {
    private final NetworkEnergizerEnergyInfo energyInfo;
    private final Predicate<Player> stillValid;

    public NetworkEnergizerContainerMenu(int syncId, Inventory playerInventory, NetworkEnergizerData networkEnergizerData) {
        super(Menus.getNetworkEnergizer(), syncId);
        this.energyInfo = NetworkEnergizerEnergyInfo.forClient(playerInventory.player, networkEnergizerData.stored(), networkEnergizerData.capacity());
        this.addPlayerInventory(playerInventory, 8, 107);
        this.registerProperty((Property)new ClientProperty(PropertyTypes.REDSTONE_MODE, (Object)RedstoneMode.IGNORE));
        this.stillValid = p -> true;
    }

    NetworkEnergizerContainerMenu(int syncId, Inventory playerInventory, NetworkEnergizerBlockEntity networkEnergizer, Player player) {
        super(Menus.getNetworkEnergizer(), syncId);
        this.energyInfo = NetworkEnergizerEnergyInfo.forServer(player, networkEnergizer::getStored, networkEnergizer::getCapacity);
        this.addPlayerInventory(playerInventory, 8, 107);
        this.registerProperty((Property)new ServerProperty(PropertyTypes.REDSTONE_MODE, () -> ((NetworkEnergizerBlockEntity)networkEnergizer).getRedstoneMode(), arg_0 -> ((NetworkEnergizerBlockEntity)networkEnergizer).setRedstoneMode(arg_0)));
        this.stillValid = p -> Container.stillValidBlockEntity((BlockEntity)networkEnergizer, (Player)p);
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        this.energyInfo.detectChanges();
    }

    public boolean stillValid(Player player) {
        return this.stillValid.test(player);
    }

    public NetworkEnergizerEnergyInfo getEnergyInfo() {
        return this.energyInfo;
    }
}

