/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability.mobeffect;

import artifacts.component.ability.CompositeAbility;
import artifacts.component.ability.EquipmentAbility;
import artifacts.component.ability.mobeffect.MobEffectProvider;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.equipment.EquipmentHelper;
import artifacts.registry.ModDataComponents;
import artifacts.util.DamageSourceHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public record AttackEffects(List<Entry> entries) implements CompositeAbility<Entry>
{
    private static final Set<Holder<MobEffect>> CUSTOM_TOOLTIP_MOB_EFFECTS = Set.of(MobEffects.WITHER);
    public static final Codec<AttackEffects> CODEC = Entry.CODEC.listOf().xmap(AttackEffects::new, AttackEffects::entries);
    public static final StreamCodec<RegistryFriendlyByteBuf, AttackEffects> STREAM_CODEC = ByteBufCodecs.list().apply(Entry.STREAM_CODEC).map(AttackEffects::new, AttackEffects::entries);

    public static void onLivingHurt(LivingEntity entity, DamageSource damageSource) {
        LivingEntity attacker = DamageSourceHelper.getAttacker(damageSource);
        if (attacker != null && DamageSourceHelper.isMeleeAttack(damageSource) && !entity.level().isClientSide()) {
            EquipmentHelper.iterateAbilities(ModDataComponents.ATTACK_EFFECTS.get(), attacker, true, true, (ability, stack) -> {
                for (Entry effect : ability.entries) {
                    if (!effect.shouldApply(entity)) continue;
                    entity.addEffect(effect.provider().createEffect(), (Entity)attacker);
                    if (!(attacker instanceof Player)) continue;
                    Player player = (Player)attacker;
                    player.getCooldowns().addCooldown(stack.getItem(), (Integer)effect.cooldown().get() * 20);
                }
            });
        }
    }

    public record Entry(MobEffectProvider provider, Value<Double> chance, Value<Integer> cooldown) implements EquipmentAbility
    {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MobEffectProvider.codec(true).fieldOf("effect").forGetter(Entry::provider), (App)ValueTypes.FRACTION.codec().optionalFieldOf("chance", Value.of(1.0)).forGetter(Entry::chance), (App)ValueTypes.DURATION.codec().optionalFieldOf("cooldown", Value.of(0)).forGetter(Entry::cooldown)).apply((Applicative)instance, Entry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = StreamCodec.composite(MobEffectProvider.STREAM_CODEC, Entry::provider, ValueTypes.FRACTION.streamCodec(), Entry::chance, ValueTypes.DURATION.streamCodec(), Entry::cooldown, Entry::new);

        public boolean shouldApply(LivingEntity entity) {
            return this.isNonCosmetic() && (Double)this.chance().get() > entity.getRandom().nextDouble();
        }

        @Override
        public boolean isNonCosmetic() {
            return this.provider().isNonCosmetic() && (Double)this.chance().get() > 0.0;
        }

        @Override
        public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
            for (Holder<MobEffect> mobEffect : CUSTOM_TOOLTIP_MOB_EFFECTS) {
                if (!mobEffect.isBound() || mobEffect.value() != this.provider.mobEffect().value() || !this.isNonCosmetic()) continue;
                String name = Objects.requireNonNull(BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)mobEffect.value()))).getPath();
                if (Mth.equal((double)((Double)this.chance().get()), (double)1.0)) {
                    writer.add(name + ".constant", new Object[0]);
                } else {
                    writer.add(name + ".chance", new Object[0]);
                }
                return;
            }
        }
    }
}

