/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.override.datagen;

import java.lang.runtime.SwitchBootstraps;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.data.LanguageProvider;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.FluidContent;
import tv.soaryn.xycraft.core.content.IContent;
import tv.soaryn.xycraft.core.content.ItemContent;
import tv.soaryn.xycraft.core.content.fluids.XyFluidType;
import tv.soaryn.xycraft.override.content.registries.OverrideContent;

public class OverrideLanguageDataGen
extends LanguageProvider
implements IConditionBuilder {
    private final String locale;

    public OverrideLanguageDataGen(PackOutput output, String modid, String locale) {
        super(output, modid, locale);
        this.locale = locale;
    }

    protected void addTranslations() {
        OverrideContent.Map.ListOfBlocks.forEach(this::handleLang);
        OverrideContent.Map.ListOfItems.forEach(this::handleLang);
        this.addToolTip((IContent<?>)OverrideContent.Block.SmoothSmoothStone, "Has connected texture", 0);
        this.addToolTip((IContent<?>)OverrideContent.Block.SmoothPolishedTuff, "Has connected texture", 0);
        this.add("itemGroup.xycraft_override_tab", "XyCraft Override");
    }

    private void addToolTip(IContent<?> content, String tooltip, int i) {
        IContent<?> iContent = content;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockContent.class, ItemContent.class, FluidContent.class}, iContent, n)) {
            case 0: {
                BlockContent wrapper = (BlockContent)iContent;
                this.add(wrapper.block().getDescriptionId() + ".tooltip." + i, tooltip);
                break;
            }
            case 1: {
                ItemContent wrapper = (ItemContent)iContent;
                this.add(wrapper.item().getDescriptionId() + ".tooltip." + i, tooltip);
                break;
            }
            case 2: {
                FluidContent wrapper = (FluidContent)iContent;
                this.add(((XyFluidType)wrapper.Type.get()).getDescriptionId() + ".tooltip." + i, tooltip);
                break;
            }
        }
    }

    private void handleLang(BlockContent wrapper) {
        this.add(wrapper.block(), wrapper.getLocalizedName(this.locale));
    }

    private void handleLang(ItemContent wrapper) {
        this.add(wrapper.item(), wrapper.getLocalizedName(this.locale));
    }
}

