/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.network.packet;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.evilcraft.item.ItemExaltedCrafter;

public class ExaltedCrafterOpenPacket
extends PacketCodec<ExaltedCrafterOpenPacket> {
    public static final CustomPacketPayload.Type<ExaltedCrafterOpenPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"exalted_crafter_open"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ExaltedCrafterOpenPacket> CODEC = ExaltedCrafterOpenPacket.getCodec(ExaltedCrafterOpenPacket::new);
    @CodecField
    private ItemLocation itemLocation = null;

    public ExaltedCrafterOpenPacket() {
        super(ID);
    }

    public ExaltedCrafterOpenPacket(ItemLocation itemLocation) {
        super(ID);
        this.itemLocation = itemLocation;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        ItemStack found;
        if (this.itemLocation != null && !(found = this.itemLocation.getItemStack((Player)player)).isEmpty() && found.getItem() instanceof ItemExaltedCrafter) {
            ((ItemExaltedCrafter)found.getItem()).openGuiForItemIndex(world, player, this.itemLocation);
        }
    }
}

