/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.item.ItemVengeancePickaxe;

public class ItemVengeancePickaxeConfig
extends ItemConfig {
    @ConfigurableProperty(category="item", comment="The default fortune enchantment level on these pickaxes in the creative tab.", requiresMcRestart=true)
    public static int fortuneLevel = 5;
    @ConfigurableProperty(category="item", comment="The default vengeance enchantment level on these pickaxes in the creative tab.", requiresMcRestart=true)
    public static int vengeanceLevel = 3;

    public ItemVengeancePickaxeConfig() {
        super((ModBase)EvilCraft._instance, "vengeance_pickaxe", eConfig -> new ItemVengeancePickaxe(new Item.Properties().attributes(PickaxeItem.createAttributes((Tier)Tiers.DIAMOND, (float)1.0f, (float)-2.8f)).durability(154)));
        EvilCraft._instance.getModEventBus().addListener(this::fillCreativeTab);
    }

    protected Collection<ItemStack> getDefaultCreativeTabEntries() {
        return Collections.emptyList();
    }

    protected Collection<ItemStack> dynamicCreativeTabEntries(CreativeModeTab.ItemDisplayParameters parameters) {
        return Collections.singleton(((ItemVengeancePickaxe)((Object)this.getInstance())).getEnchantedItemStack(parameters.holders()));
    }

    protected void fillCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == EvilCraft._instance.getDefaultCreativeTab()) {
            for (ItemStack itemStack : this.dynamicCreativeTabEntries(event.getParameters())) {
                event.accept(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }
}

