/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.Capabilities;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacity;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerCapacity;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerMutable;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.item.ItemBlockNBT;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.block.BlockDarkTankConfig;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.helper.BlockTankHelpers;
import org.cyclops.evilcraft.core.helper.ItemHelpers;

public class ItemBlockFluidContainer
extends ItemBlockNBT {
    private IBlockTank block;

    public ItemBlockFluidContainer(Block block, Item.Properties builder) {
        super(block, builder);
        this.block = (IBlockTank)block;
        EvilCraft._instance.getModEventBus().addListener(this::registerCapability);
    }

    private void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new FluidHandlerItemCapacity(stack, this.block.getDefaultCapacity()), new ItemLike[]{this});
        event.registerItem(Capabilities.Item.FLUID_HANDLER_CAPACITY, (stack, ctx) -> new FluidHandlerItemCapacity(stack, this.block.getDefaultCapacity()), new ItemLike[]{this});
    }

    public boolean isFoil(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    protected boolean itemStackDataToTile(ItemStack itemStack, BlockEntity tile) {
        BlockEntityHelpers.getCapability((ILevelExtension)tile.getLevel(), (BlockPos)tile.getBlockPos(), (BlockCapability)Capabilities.FluidHandler.BLOCK).ifPresent(fluidHandlerTile -> Optional.ofNullable((IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM)).ifPresent(fluidHandlerItem -> {
            if (fluidHandlerTile instanceof IFluidHandlerMutable) {
                ((IFluidHandlerMutable)fluidHandlerTile).setFluidInTank(0, fluidHandlerItem.getFluidInTank(0));
            }
            if (fluidHandlerTile instanceof IFluidHandlerCapacity) {
                ((IFluidHandlerCapacity)fluidHandlerTile).setTankCapacity(0, fluidHandlerItem.getTankCapacity(0));
            }
        }));
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (this.block.isActivatable()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)this.block.toggleActivation(player.getItemInHand(hand), world, player));
        }
        return super.use(world, player, hand);
    }

    protected void autofill(int itemSlot, IFluidHandlerItem source, Level world, Entity entity) {
        ItemHelpers.updateAutoFill(source, world, entity, BlockDarkTankConfig.autoFillBuckets);
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.block.isActivatable() && this.block.isActivated(stack, Item.TooltipContext.of((Level)worldIn))) {
            FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(fluidHandler -> this.autofill(itemSlot, (IFluidHandlerItem)fluidHandler, worldIn, entityIn));
        }
        super.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, list, flag);
        list.add((Component)BlockTankHelpers.getInfoTank(itemStack));
        if (this.block.isActivatable()) {
            L10NHelpers.addStatusInfo(list, (boolean)this.block.isActivated(itemStack, context), (String)(this.getDescriptionId() + ".info.auto_supply"));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.getItem() != newStack.getItem() || slotChanged;
    }
}

