/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;

@Deprecated
public abstract class Zone
implements Comparable<Zone> {
    public static Zone rectangular(BlockPos minCoords, BlockPos maxCoords) {
        return new RectangularCuboidZone(minCoords, maxCoords);
    }

    public static Zone sphere(BlockPos center, int radius) {
        return new SphereZone(center, radius);
    }

    public abstract boolean contains(BlockPos var1);

    public abstract AABB getBoundingBox();

    @Override
    public int compareTo(Zone zone) {
        AABB myBB = this.getBoundingBox();
        AABB hisBB = zone.getBoundingBox();
        return 0;
    }

    private static class RectangularCuboidZone
    extends Zone {
        private final BlockPos _minCoords;
        private final BlockPos _maxCoords;

        RectangularCuboidZone(BlockPos minCoords, BlockPos maxCoords) {
            this._minCoords = minCoords;
            this._maxCoords = maxCoords;
        }

        @Override
        public boolean contains(BlockPos position) {
            return this._minCoords.getX() <= position.getX() && position.getX() <= this._maxCoords.getX() && this._minCoords.getY() <= position.getY() && position.getY() <= this._maxCoords.getY() && this._minCoords.getZ() <= position.getZ() && position.getZ() <= this._maxCoords.getZ();
        }

        @Override
        public AABB getBoundingBox() {
            return new AABB((double)this._minCoords.getX(), (double)this._minCoords.getY(), (double)this._minCoords.getZ(), (double)this._maxCoords.getX(), (double)this._maxCoords.getY(), (double)this._maxCoords.getZ());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RectangularCuboidZone)) {
                return false;
            }
            RectangularCuboidZone other = (RectangularCuboidZone)o;
            return this._minCoords.equals((Object)other._minCoords) && this._maxCoords.equals((Object)other._maxCoords);
        }
    }

    private static class SphereZone
    extends Zone {
        private final BlockPos _center;
        private final int _radius;

        SphereZone(BlockPos center, int radius) {
            this._center = center;
            this._radius = radius;
        }

        @Override
        public boolean contains(BlockPos position) {
            return (position.getX() - this._center.getX()) * (position.getX() - this._center.getX()) + (position.getY() - this._center.getY()) * (position.getY() - this._center.getY()) + (position.getZ() - this._center.getZ()) * (position.getZ() - this._center.getZ()) <= this._radius * this._radius;
        }

        @Override
        public AABB getBoundingBox() {
            int centerX = this._center.getX();
            int centerY = this._center.getY();
            int centerZ = this._center.getZ();
            return new AABB((double)(centerX - this._radius), (double)(centerY - this._radius), (double)(centerZ - this._radius), (double)(centerX + this._radius - 1), (double)(centerY + this._radius - 1), (double)(centerZ + this._radius - 1));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SphereZone)) {
                return false;
            }
            SphereZone other = (SphereZone)o;
            return this._radius == other._radius && this._center.equals((Object)other._center);
        }
    }
}

