/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.result;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidStackRecipeResult
implements IRecipeResult<FluidStack> {
    public static final ModCodecs<FluidStackRecipeResult, RegistryFriendlyByteBuf> CODECS = new ModCodecs(FluidStack.CODEC.xmap(FluidStackRecipeResult::from, FluidStackRecipeResult::getResult), StreamCodec.composite((StreamCodec)FluidStack.STREAM_CODEC, FluidStackRecipeResult::getResult, FluidStackRecipeResult::new));
    private final FluidStack _result;

    public static FluidStackRecipeResult from(FluidStack stack) {
        return new FluidStackRecipeResult(stack);
    }

    @Override
    public ResourceLocation getId() {
        return CodeHelper.getObjectId(this._result.getFluid());
    }

    @Override
    public FluidStack getResult() {
        return this._result.copy();
    }

    @Override
    public long getAmount() {
        return this._result.isEmpty() ? 0L : (long)this._result.getAmount();
    }

    @Override
    public boolean isEmpty() {
        return this._result.isEmpty();
    }

    public String toString() {
        return FluidHelper.toStringHelper(this._result);
    }

    private FluidStackRecipeResult(FluidStack stack) {
        this._result = stack;
    }
}

