/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.ingredient;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.recipe.ingredient.FluidStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidStackRecipeIngredientsList
implements IRecipeIngredient<FluidStack> {
    public static final ModCodecs<FluidStackRecipeIngredientsList, RegistryFriendlyByteBuf> CODECS = new ModCodecs(FluidStackRecipeIngredient.CODECS.listCodec().xmap(FluidStackRecipeIngredientsList::from, l -> l._ingredients), StreamCodec.composite(FluidStackRecipeIngredient.CODECS.listStreamCodec(), l -> l._ingredients, FluidStackRecipeIngredientsList::from));
    private final List<FluidStackRecipeIngredient> _ingredients;
    private List<FluidStack> _cachedMatchingElements;

    public static FluidStackRecipeIngredientsList from(FluidStackRecipeIngredient ... ingredients) {
        return new FluidStackRecipeIngredientsList(List.of(ingredients));
    }

    public static FluidStackRecipeIngredientsList from(List<FluidStackRecipeIngredient> ingredients) {
        return new FluidStackRecipeIngredientsList(ingredients);
    }

    @Override
    public boolean isCompatible(FluidStack stack) {
        return this._ingredients.stream().anyMatch(ingredient -> ingredient.isCompatible(stack));
    }

    @Override
    public boolean isCompatible(FluidStack ... ingredients) {
        return this._ingredients.stream().anyMatch(ingredient -> ingredient.isCompatible(ingredients));
    }

    @Override
    public FluidStack getMatchFrom(FluidStack stack) {
        return this._ingredients.stream().map(ingredient -> ingredient.getMatchFrom(stack)).filter(match -> !match.isEmpty()).findAny().orElse(FluidStack.EMPTY);
    }

    @Override
    public long getAmount(FluidStack stack) {
        return this._ingredients.stream().mapToLong(ingredient -> ingredient.getAmount(stack)).filter(amount -> amount > 0L).findAny().orElse(0L);
    }

    @Override
    public List<FluidStack> getMatchingElements() {
        if (null == this._cachedMatchingElements) {
            this._cachedMatchingElements = (List)this._ingredients.stream().flatMap(ingredient -> ingredient.getMatchingElements().stream()).collect(ImmutableList.toImmutableList());
        }
        return this._cachedMatchingElements;
    }

    @Override
    public boolean isEmpty() {
        return this._ingredients.stream().anyMatch(IRecipeIngredient::isEmpty);
    }

    @Override
    public boolean test(FluidStack stack) {
        return this._ingredients.stream().anyMatch(ingredient -> ingredient.test(stack));
    }

    @Override
    public boolean testIgnoreAmount(FluidStack stack) {
        return this._ingredients.stream().anyMatch(ingredient -> ingredient.testIgnoreAmount(stack));
    }

    public String toString() {
        return this._ingredients.stream().map(Object::toString).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
    }

    protected FluidStackRecipeIngredientsList(List<FluidStackRecipeIngredient> ingredients) {
        this._ingredients = ObjectLists.unmodifiable((ObjectList)new ObjectArrayList(ingredients));
    }
}

