/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.fluid;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.EmptyFluidHandler;

public final class FluidHelper {
    public static final IFluidHandler EMPTY_FLUID_HANDLER = EmptyFluidHandler.INSTANCE;
    public static final int BUCKET_VOLUME = 1000;

    public static ResourceLocation getFluidId(Fluid fluid) {
        return Objects.requireNonNull(BuiltInRegistries.FLUID.getKey((Object)fluid));
    }

    public static ResourceLocation getFluidId(FluidStack stack) {
        return Objects.requireNonNull(BuiltInRegistries.FLUID.getKey((Object)stack.getFluid()));
    }

    public static MutableComponent getFluidName(Fluid fluid) {
        return Component.translatable((String)fluid.getFluidType().getDescriptionId());
    }

    public static MutableComponent getFluidName(FluidStack stack) {
        return Component.translatable((String)stack.getFluid().getFluidType().getDescriptionId(stack));
    }

    public static FluidStack tryFluidTransfer(IFluidHandler source, Level world, BlockPos destinationPosition, Direction fillDirection, int maxAmount, IFluidHandler.FluidAction action) {
        return FluidUtil.getFluidHandler((Level)world, (BlockPos)destinationPosition, (Direction)fillDirection).map(destination -> FluidUtil.tryFluidTransfer((IFluidHandler)destination, (IFluidHandler)source, (int)maxAmount, (boolean)action.execute())).orElse(FluidStack.EMPTY);
    }

    public static FluidStack stackFrom(FluidStack stack, int amount) {
        return stack.copyWithAmount(amount);
    }

    public static FluidStack stackDeserializeFromNBT(HolderLookup.Provider registries, Tag input) {
        CompoundTag compound;
        if (input instanceof CompoundTag && (compound = (CompoundTag)input).isEmpty()) {
            return FluidStack.EMPTY;
        }
        return FluidStack.parse((HolderLookup.Provider)registries, (Tag)input).orElse(FluidStack.EMPTY);
    }

    public static Tag stackSerializeToNBT(HolderLookup.Provider registries, FluidStack stack) {
        return stack.isEmpty() ? new CompoundTag() : stack.save(registries);
    }

    public static Tag stackSerializeToNBT(HolderLookup.Provider registries, FluidStack stack, Tag output) {
        return stack.isEmpty() ? new CompoundTag() : stack.save(registries, output);
    }

    public static String toStringHelper(FluidStack stack) {
        return "FluidStack: " + stack.getAmount() + " " + String.valueOf(FluidHelper.getFluidId(stack.getFluid()));
    }

    private FluidHelper() {
    }
}

