/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.recipe;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;

public abstract class AbstractModRecipeBuilder<Recipe extends ModRecipe, Result, RecipeResult extends IRecipeResult<Result>, Builder extends AbstractModRecipeBuilder<Recipe, Result, RecipeResult, Builder>> {
    private final RecipeResult _result;
    private final List<ICondition> _conditions;
    private final Map<String, Criterion<?>> _criteria;

    protected AbstractModRecipeBuilder(RecipeResult result) {
        Preconditions.checkNotNull(result, (Object)"Result must not be null");
        this._result = result;
        this._criteria = new LinkedHashMap();
        this._conditions = new ObjectArrayList(8);
    }

    protected abstract Recipe getRecipe();

    public void build(RecipeOutput output) {
        this.build(output, this._result.getId());
    }

    public void build(RecipeOutput output, ResourceLocation id) {
        ICondition[] conditions = this._conditions.toArray(new ICondition[0]);
        AdvancementHolder advancementHolder = AbstractModRecipeBuilder.buildAdvancements(output, this._criteria, id);
        output.accept(id, this.getRecipe(), advancementHolder, conditions);
    }

    public Builder addCriterion(String name, Criterion<?> criterion) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Name must not be null or empty");
        Preconditions.checkNotNull(criterion, (Object)"Criterion must not be null");
        if (null != this._criteria.put(name, criterion)) {
            throw new IllegalArgumentException("A criterion named " + name + " already exists");
        }
        return this.self();
    }

    public Builder addCondition(ICondition condition) {
        this._conditions.add(condition);
        return this.self();
    }

    private Builder self() {
        return (Builder)this;
    }

    private static AdvancementHolder buildAdvancements(RecipeOutput output, Map<String, Criterion<?>> criteria, ResourceLocation id) {
        Advancement.Builder builder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        return builder.build(id.withPrefix("recipes/"));
    }
}

