/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.client.model;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public class ItemOverrideBuilder
implements Supplier<JsonElement> {
    private final Object2FloatMap<ResourceLocation> _predicates = new Object2FloatArrayMap(8);
    private ResourceLocation _model;

    ItemOverrideBuilder() {
    }

    public ItemOverrideBuilder predicate(ResourceLocation itemPredicate, float value) {
        Preconditions.checkNotNull((Object)itemPredicate, (Object)"The item predicate must not be null");
        Preconditions.checkState((!this._predicates.containsKey((Object)itemPredicate) ? 1 : 0) != 0, (Object)"A value for the provided predicate is already defined");
        this._predicates.put((Object)itemPredicate, value);
        return this;
    }

    public ItemOverrideBuilder model(ResourceLocation model) {
        Preconditions.checkNotNull((Object)model, (Object)"The model must not be null");
        Preconditions.checkState((null == this._model ? 1 : 0) != 0, (Object)"A model for this override is already defined");
        this._model = model;
        return this;
    }

    @Override
    @ApiStatus.Internal
    public JsonElement get() {
        Preconditions.checkState((null != this._model ? 1 : 0) != 0, (Object)"A model must be provided for this override");
        Preconditions.checkState((!this._predicates.isEmpty() ? 1 : 0) != 0, (Object)"At least one predicate must be provided for this override");
        JsonObject json = new JsonObject();
        JsonObject predicates = new JsonObject();
        this._predicates.forEach((predicate, value) -> predicates.addProperty(predicate.toString(), (Number)value));
        json.add("predicate", (JsonElement)predicates);
        json.addProperty("model", this._model.toString());
        return json;
    }
}

