/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.datagen.IModDataGenerator;
import it.zerono.mods.zerocore.lib.datagen.provider.tag.IIntrinsicTagDataProvider;
import it.zerono.mods.zerocore.lib.datagen.provider.tag.ITagDataProvider;
import it.zerono.mods.zerocore.lib.datagen.provider.tag.ModIntrinsicTagAppender;
import it.zerono.mods.zerocore.lib.datagen.provider.tag.ModTagAppender;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

public class ForgeModDataGenerator
implements IModDataGenerator {
    private final ResourceLocationBuilder _modRootLocation;
    private final DataGenerator.PackGenerator _packGenerator;
    private final CompletableFuture<HolderLookup.Provider> _lookup;
    private final ExistingFileHelper _existingFileHelper;

    public ForgeModDataGenerator(GatherDataEvent gatherDataEvent, ResourceLocationBuilder modRootLocation, Consumer<@NotNull IModDataGenerator> providersConfigurator) {
        Preconditions.checkNotNull((Object)gatherDataEvent);
        Preconditions.checkNotNull((Object)modRootLocation);
        Preconditions.checkNotNull(providersConfigurator);
        this._modRootLocation = modRootLocation;
        this._packGenerator = gatherDataEvent.getGenerator().getVanillaPack(true);
        this._lookup = gatherDataEvent.getLookupProvider();
        this._existingFileHelper = gatherDataEvent.getExistingFileHelper();
        providersConfigurator.accept(this);
    }

    @Override
    public CompletableFuture<HolderLookup.Provider> getRegistryLookup() {
        return this._lookup;
    }

    @Override
    public ResourceLocationBuilder getModRoot() {
        return this._modRootLocation;
    }

    @Override
    public <P extends DataProvider> void addProvider(DataProvider.Factory<P> factory) {
        this._packGenerator.addProvider(factory);
    }

    @Override
    public <T> void addTagsProvider(ResourceKey<? extends Registry<T>> registryKey, final ITagDataProvider<T> provider) {
        Preconditions.checkNotNull(registryKey, (Object)"Registry key must not be null");
        Preconditions.checkNotNull(provider, (Object)"Provider must not be null");
        String namespace = this._modRootLocation.namespace();
        CompletableFuture<HolderLookup.Provider> lookup = this._lookup;
        ExistingFileHelper helper = this._existingFileHelper;
        this.addProvider(output -> new TagsProvider<T>(this, output, registryKey, lookup, namespace, helper){

            protected void addTags(HolderLookup.Provider lookup) {
                provider.build(lookup, tagKey -> new ModTagAppender(this.getOrCreateRawBuilder((TagKey)tagKey)));
            }

            public String getName() {
                return provider.getName();
            }
        });
    }

    @Override
    public <T> void addTagsProvider(ResourceKey<? extends Registry<T>> registryKey, final Function<@NotNull T, @NotNull ResourceKey<T>> elementKeyProvider, final IIntrinsicTagDataProvider<T> provider) {
        Preconditions.checkNotNull(registryKey, (Object)"Registry key must not be null");
        Preconditions.checkNotNull(elementKeyProvider, (Object)"Element key provider must not be null");
        Preconditions.checkNotNull(provider, (Object)"Provider must not be null");
        String namespace = this._modRootLocation.namespace();
        CompletableFuture<HolderLookup.Provider> lookup = this._lookup;
        ExistingFileHelper helper = this._existingFileHelper;
        this.addProvider(output -> new TagsProvider<T>(this, output, registryKey, lookup, namespace, helper){

            protected void addTags(HolderLookup.Provider lookup) {
                provider.build(lookup, tagKey -> new ModIntrinsicTagAppender(this.getOrCreateRawBuilder((TagKey)tagKey), elementKeyProvider));
            }

            public String getName() {
                return provider.getName();
            }
        });
    }
}

