/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.AbstractWindowsManager;
import it.zerono.mods.zerocore.lib.client.gui.GuiHelper;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.IWindow;
import it.zerono.mods.zerocore.lib.client.gui.Theme;
import it.zerono.mods.zerocore.lib.client.gui.WindowsManagerMultiWindow;
import it.zerono.mods.zerocore.lib.client.gui.WindowsManagerSingleWindow;
import it.zerono.mods.zerocore.lib.client.gui.control.HelpButton;
import it.zerono.mods.zerocore.lib.client.gui.control.SlotsGroup;
import it.zerono.mods.zerocore.lib.client.gui.databind.BindingGroup;
import it.zerono.mods.zerocore.lib.client.gui.databind.IBinding;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.event.ConcurrentEvent;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModContainerScreen<C extends ModContainer>
extends AbstractContainerScreen<C> {
    public final IEvent<Runnable> Create;
    public final IEvent<Runnable> Close;
    public final IEvent<Runnable> Created;
    public final IEvent<Runnable> DataUpdated;
    private final AbstractWindowsManager<C> _windowsManager;
    private final List<Runnable> _tickHandlers;
    private final Queue<Runnable> _deferred;
    private final Runnable _raiseContainerDataUpdatedHandler;
    private boolean _dataUpdateInProgress;
    private int _originalMouseX;
    private int _originalMouseY;
    private boolean _ignoreCloseOnInventoryKey;
    private int _nextBogusId;
    private BindingGroup _bindings;
    private Theme _theme;
    private boolean _keepScreenAlive;

    protected ModContainerScreen(C container, Inventory inventory, Component title, int guiWidth, int guiHeight) {
        this(container, inventory, title, guiWidth, guiHeight, true);
    }

    protected ModContainerScreen(C container, Inventory inventory, Component title, int guiWidth, int guiHeight, boolean singleWindow) {
        super(container, inventory, title);
        this.imageWidth = guiWidth;
        this.imageHeight = guiHeight;
        this._tickHandlers = Lists.newArrayListWithCapacity((int)2);
        this._deferred = Lists.newLinkedList();
        this._originalMouseY = 0;
        this._originalMouseX = 0;
        this._ignoreCloseOnInventoryKey = false;
        this._nextBogusId = 0;
        this._theme = Theme.DEFAULT;
        this._keepScreenAlive = false;
        this.Create = new Event<Runnable>();
        this.Close = new ConcurrentEvent<Runnable>();
        this.Created = new Event<Runnable>();
        this.DataUpdated = new Event<Runnable>();
        this._raiseContainerDataUpdatedHandler = ((ModContainer)((Object)container)).subscribeContainerDataUpdate(this::raiseDataUpdated);
        this._windowsManager = singleWindow ? new WindowsManagerSingleWindow(this) : new WindowsManagerMultiWindow(this);
    }

    protected void close() {
        if (null != Minecraft.getInstance().player) {
            Minecraft.getInstance().player.closeContainer();
        }
    }

    protected boolean isDataUpdateInProgress() {
        return this._dataUpdateInProgress;
    }

    protected void onScreenCreate() {
    }

    protected void onScreenCreated() {
        this.raiseDataUpdated();
    }

    protected void onScreenClose() {
        ((ModContainer)this.getMenu()).unsubscribeContainerDataUpdate(this._raiseContainerDataUpdatedHandler);
    }

    protected void onDataUpdated() {
    }

    public boolean isValid() {
        ArrayList errors = Lists.newArrayList();
        this._windowsManager.validate(errors::add);
        if (!errors.isEmpty()) {
            ZeroCore.getProxy().displayErrorToPlayer(null, errors);
            return false;
        }
        return true;
    }

    public void requestTickUpdates(Runnable handler) {
        this._tickHandlers.add(handler);
    }

    public int getGuiX() {
        return this.leftPos;
    }

    public int getGuiY() {
        return this.topPos;
    }

    public int getGuiWidth() {
        return this.imageWidth;
    }

    public int getGuiHeight() {
        return this.imageHeight;
    }

    public int getMinecraftWindowWidth() {
        return this.getMinecraft().getWindow().getWidth();
    }

    public int getMinecraftWindowHeight() {
        return this.getMinecraft().getWindow().getHeight();
    }

    public float getZLevel() {
        return 0.0f;
    }

    public double getGuiScaleFactor() {
        return this.getMinecraft().getWindow().getGuiScale();
    }

    public int getClippedMouseX() {
        return Mth.ceil((double)(GuiHelper.getMouse().xpos() - (double)this.getGuiX()));
    }

    public int getClippedMouseY() {
        return Mth.ceil((double)(GuiHelper.getMouse().ypos() - (double)this.getGuiY()));
    }

    public void renderHoveredSlotToolTip(GuiGraphics gfx) {
        this.renderTooltip(gfx, this.getOriginalMouseX(), this.getOriginalMouseY());
    }

    public int getTooltipsPopupMaxWidth() {
        return -1;
    }

    public static int parseTooltipsPopupMaxWidthFromLang(String langKey, int defaultValue) {
        MutableComponent text = Component.translatable((String)langKey);
        try {
            int width = Integer.parseInt(text.getString());
            return width > 0 ? width : defaultValue;
        }
        catch (NumberFormatException ex) {
            Log.LOGGER.error(Log.GUI, "Invalid integer value from lang file: {}", (Object)langKey);
            return defaultValue;
        }
    }

    public int getOriginalMouseX() {
        return this._originalMouseX;
    }

    public int getOriginalMouseY() {
        return this._originalMouseY;
    }

    public Rectangle getScreenRect() {
        return new Rectangle(0, 0, Minecraft.getInstance().getWindow().getGuiScaledWidth(), Minecraft.getInstance().getWindow().getGuiScaledHeight());
    }

    public Rectangle getScreenRectPadded() {
        return this.getScreenRect().inset(5, 5);
    }

    public int nextGenericId() {
        return this._nextBogusId++;
    }

    public String nextGenericName() {
        return Integer.toString(this.nextGenericId());
    }

    public void enqueueTask(Runnable runnable) {
        this._deferred.add(runnable);
    }

    protected IWindow createWindow(IControlContainer rootContainer, boolean modalWindow) {
        return this._windowsManager.createWindow(rootContainer, modalWindow, this.getGuiX(), this.getGuiY(), this.getGuiWidth(), this.getGuiHeight());
    }

    protected IWindow createWindow(IControlContainer rootContainer, boolean modalWindow, int x, int y, int width, int height) {
        return this._windowsManager.createWindow(rootContainer, modalWindow, x, y, width, height);
    }

    protected void ignoreCloseOnInventoryKey(boolean ignore) {
        this._ignoreCloseOnInventoryKey = ignore;
    }

    protected boolean ignoreCloseOnInventoryKey() {
        return this._ignoreCloseOnInventoryKey;
    }

    protected IControl createPatchouliHelpButton(ResourceLocation bookId, ResourceLocation entryId, int pageNum) {
        return HelpButton.patchouli(this, "helpPatchouli", bookId, entryId, pageNum);
    }

    protected IControl createRecipesButton(Runnable onClick, String tooltipTranslationKey) {
        return HelpButton.jeiRecipes(this, "recipes", tooltipTranslationKey, () -> {
            this._keepScreenAlive = true;
            onClick.run();
        });
    }

    public Theme getTheme() {
        return this._theme;
    }

    public void setTheme(Theme theme) {
        this._theme = Objects.requireNonNull(theme);
        this._windowsManager.onThemeChanged(theme);
    }

    public Font getFont() {
        return this.font;
    }

    protected SlotsGroup createMonoSlotGroupControl(String controlName, String inventorySlotsGroupName, ISprite backgroundSprite, int borderSize) {
        SlotsGroup control = new SlotsGroup(this, controlName, inventorySlotsGroupName, backgroundSprite.getWidth(), backgroundSprite.getHeight(), backgroundSprite);
        control.setPadding(borderSize);
        return control;
    }

    protected SlotsGroup createPlayerHotBarSlotsGroupControl(ISprite backgroundSprite, int borderSize) {
        SlotsGroup control = new SlotsGroup(this, "hotbar", "playerinventory_hotbar", backgroundSprite.getWidth(), backgroundSprite.getHeight(), backgroundSprite);
        control.setPadding(borderSize);
        return control;
    }

    protected SlotsGroup createPlayerInventorySlotsGroupControl(ISprite backgroundSprite, int borderSize) {
        SlotsGroup control = new SlotsGroup(this, "playerinv", "playerinventory_main", backgroundSprite.getWidth(), backgroundSprite.getHeight(), backgroundSprite);
        control.setPadding(borderSize);
        return control;
    }

    public <Value> void addDataBinding(Supplier<Value> supplier, Consumer<Value> consumer) {
        this.addDataBinding(IBinding.from(supplier, consumer));
    }

    @SafeVarargs
    public final <Value> void addDataBinding(Supplier<Value> supplier, Consumer<Value> ... consumers) {
        this.addDataBinding(IBinding.from(supplier, consumers));
    }

    private void addDataBinding(IBinding binding) {
        if (null == this._bindings) {
            this._bindings = new BindingGroup();
        }
        this._bindings.addBinding(binding);
    }

    public final void init() {
        super.init();
        this.raiseScreenCreate();
        this.raiseScreenCreated();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void added() {
        super.added();
        Minecraft.getInstance().tell(() -> ((ModContainer)this.getMenu()).onScreenOpened());
    }

    public final void removed() {
        if (this._keepScreenAlive) {
            this._keepScreenAlive = false;
            return;
        }
        super.removed();
        this.raiseScreenClose();
        this.Create.unsubscribeAll();
        this.Created.unsubscribeAll();
        this.Close.unsubscribeAll();
        CodeHelper.clearErrorReport();
    }

    public final void containerTick() {
        super.containerTick();
        this._windowsManager.onGuiContainerTick();
        this._tickHandlers.forEach(Runnable::run);
        if (!this._deferred.isEmpty()) {
            this._deferred.forEach(Runnable::run);
            this._deferred.clear();
        }
    }

    public final void renderBackground(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(gfx, mouseX, mouseY, partialTicks);
        this._originalMouseX = mouseX;
        this._originalMouseY = mouseY;
        this._windowsManager.onGuiContainerPaintBackground(gfx, partialTicks);
    }

    protected void renderBg(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
    }

    protected final void renderLabels(GuiGraphics gfx, int mouseX, int mouseY) {
        this._originalMouseX = mouseX;
        this._originalMouseY = mouseY;
        this._windowsManager.onGuiContainerPaintForeground(gfx);
    }

    public final boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this._originalMouseX = (int)mouseX;
        this._originalMouseY = (int)mouseY;
        return this._windowsManager.onGuiContainerMouseClicked(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public final boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        this._originalMouseX = (int)mouseX;
        this._originalMouseY = (int)mouseY;
        return this._windowsManager.onGuiContainerMouseReleased(mouseX, mouseY, mouseButton) || super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        super.mouseMoved(mouseX, mouseY);
        this._originalMouseX = (int)mouseX;
        this._originalMouseY = (int)mouseY;
        this._windowsManager.onGuiContainerMouseMoved(mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
        this._originalMouseX = (int)mouseX;
        this._originalMouseY = (int)mouseY;
        return this._windowsManager.onGuiContainerMouseScrolled(mouseX, mouseY, scrollDeltaX, scrollDeltaY) || super.mouseScrolled(mouseX, mouseY, scrollDeltaX, scrollDeltaY);
    }

    public final boolean charTyped(char typedChar, int keyCode) {
        return this._windowsManager.onGuiContainerCharTyped(typedChar, keyCode) || super.charTyped(typedChar, keyCode);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this._windowsManager.onGuiContainerKeyPressed(keyCode, scanCode, modifiers) || this.checkIgnoreCloseOnInventoryKey(keyCode, scanCode) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    private boolean checkIgnoreCloseOnInventoryKey(int keyCode, int scanCode) {
        return this.ignoreCloseOnInventoryKey() && this.getMinecraft().options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode));
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return this._windowsManager.onGuiContainerKeyReleased(keyCode, scanCode, modifiers) || super.keyReleased(keyCode, scanCode, modifiers);
    }

    protected boolean isHovering(int regionX, int regionY, int regionWidth, int regionHeight, double pointX, double pointY) {
        return (pointX -= (double)this.getGuiLeft()) >= (double)(regionX - 1) && pointX < (double)(regionX + regionWidth + 1) && (pointY -= (double)this.getGuiTop()) >= (double)(regionY - 1) && pointY < (double)(regionY + regionHeight + 1);
    }

    private void raiseScreenCreate() {
        this.Create.raise(Runnable::run);
        this.onScreenCreate();
    }

    private void raiseScreenCreated() {
        this.onScreenCreated();
        this.Created.raise(Runnable::run);
    }

    private void raiseScreenClose() {
        this.Close.raise(Runnable::run);
        this.onScreenClose();
        if (null != this._bindings) {
            this._bindings.close();
        }
    }

    protected void raiseDataUpdated() {
        this._dataUpdateInProgress = true;
        if (null != this._bindings) {
            this._bindings.update();
        }
        this.onDataUpdated();
        this.DataUpdated.raise(Runnable::run);
        this._dataUpdateInProgress = false;
    }
}

