/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.gamecontent.debugtool;

import com.google.common.collect.Lists;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.item.ModItem;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.neoforged.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;

public class DebugToolItem
extends ModItem {
    private static ITestCallback s_testCallback = null;

    public DebugToolItem() {
        super(new Item.Properties().stacksTo(64));
    }

    public static void setTestCallback(@Nullable ITestCallback callback) {
        s_testCallback = callback;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"zerocore:debugTool.block.tooltip1"));
        tooltip.add((Component)Component.translatable((String)"zerocore:debugTool.block.tooltip2").withStyle(ChatFormatting.ITALIC));
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.empty().append((Component)Component.translatable((String)"zerocore:debugTool.block.tooltip3a").withStyle(ChatFormatting.GREEN)).append((Component)Component.translatable((String)"zerocore:debugTool.block.tooltip3b")));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        LogicalSide side = CodeHelper.getWorldLogicalSide(world);
        if (CodeHelper.isDevEnv() && null != s_testCallback && !stack.isEmpty() && stack.getCount() > 1 && context.getHand() == InteractionHand.MAIN_HAND) {
            s_testCallback.runTest(stack.getCount(), player, world, pos);
            return InteractionResult.SUCCESS;
        }
        if (null == player || player.isShiftKeyDown() != side.isClient() || world.isEmptyBlock(pos)) {
            return InteractionResult.PASS;
        }
        if (WorldHelper.getTile(world, pos).filter(te -> te instanceof IDebuggable).map(te -> (IDebuggable)te).map(debuggee -> MessagesPool.build(debuggee, side)).map(pool -> this.sendMessages(player, (Component)Component.literal((String)String.format("%1$s side debug analysis report of Tile Entity at %2$d, %3$d, %4$d", CodeHelper.getWorldSideName(world), pos.getX(), pos.getY(), pos.getZ())), (MessagesPool)pool)).filter(result -> result).isPresent()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return false;
    }

    private boolean sendMessages(Player player, Component header, MessagesPool pool) {
        if (pool.isNotEmpty()) {
            CodeHelper.sendChatMessage(player, (Component)Component.literal((String)"--------------------------------------------------"));
            CodeHelper.sendChatMessage(player, header);
            pool.forEach(message -> CodeHelper.sendChatMessage(player, message));
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface ITestCallback {
        public void runTest(int var1, @Nullable Player var2, Level var3, BlockPos var4);
    }

    private static final class MessagesPool
    implements IDebugMessages,
    Iterable<Component> {
        private final List<Component> _messages = Lists.newArrayListWithCapacity((int)2);
        private final int _depth;

        public static MessagesPool build(IDebuggable debuggee, LogicalSide side) {
            MessagesPool pool = new MessagesPool(0);
            debuggee.getDebugMessages(side, pool);
            return pool;
        }

        public boolean isNotEmpty() {
            return !this._messages.isEmpty();
        }

        @Override
        public void add(Component message) {
            this._messages.add(message);
        }

        @Override
        public void add(String messageFormatStringResourceKey, Object ... messageParameters) {
            this.add(this.getFormattedTextComponent(messageFormatStringResourceKey, messageParameters));
        }

        @Override
        public void add(LogicalSide side, IDebuggable debuggable, Component label) {
            MessagesPool other = new MessagesPool(this._depth + 1);
            debuggable.getDebugMessages(side, other);
            this.merge(other, label);
        }

        @Override
        public void add(LogicalSide side, IDebuggable debuggable, String labelFormatStringResourceKey, Object ... labelParameters) {
            this.add(side, debuggable, this.getFormattedTextComponent(labelFormatStringResourceKey, labelParameters));
        }

        @Override
        public <T> void add(T debuggee, BiConsumer<IDebugMessages, T> consumer, Component label) {
            MessagesPool other = new MessagesPool(this._depth + 1);
            consumer.accept(other, (IDebugMessages)debuggee);
            this.merge(other, label);
        }

        @Override
        public <T> void add(T debuggee, BiConsumer<IDebugMessages, T> consumer, String labelFormatStringResourceKey, Object ... labelParameters) {
            this.add(debuggee, consumer, this.getFormattedTextComponent(labelFormatStringResourceKey, labelParameters));
        }

        @Override
        public Iterator<Component> iterator() {
            return this._messages.iterator();
        }

        private MessagesPool(int depth) {
            this._depth = depth;
        }

        private void merge(MessagesPool other, Component label) {
            if (1 == other._messages.size()) {
                this.add((Component)Component.literal((String)"").append(label).append(" ").append(other._messages.get(0)));
            } else {
                this.add(label);
                other._messages.forEach(message -> this.add((Component)this.createPadding(other._depth).append(message)));
            }
        }

        private MutableComponent createPadding(int depth) {
            return Component.literal((String)"                    ".substring(0, Math.min(20, depth)));
        }

        private Component getFormattedTextComponent(String format, Object ... parameters) {
            if (parameters.length > 0) {
                return Component.translatable((String)format, (Object[])parameters);
            }
            return Component.literal((String)format);
        }
    }
}

