/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor;

import it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor.SensorBehaviorGroupPanel;
import it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor.SensorGroupPanelBuilder;
import it.zerono.mods.zerocore.base.redstone.sensor.AbstractSensorSetting;
import it.zerono.mods.zerocore.base.redstone.sensor.ISensorSettingFactory;
import it.zerono.mods.zerocore.base.redstone.sensor.ISensorType;
import it.zerono.mods.zerocore.lib.IMachineReader;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.control.Label;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.PanelGroup;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalLayoutEngine;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import java.util.List;
import net.minecraft.network.chat.Component;

class SensorGroupPanel<Reader extends IMachineReader, Writer, SensorType extends Enum<SensorType>, SensorSetting extends AbstractSensorSetting<Reader, Writer, SensorType, SensorSetting>>
extends Panel {
    private static final int HORIZONTAL_MARGIN = 2;
    private static final int CONTROL_SPACING = 4;
    private final PanelGroup<SensorType> _group;
    private final Label _activeSensorName;

    public SensorGroupPanel(SensorGroupPanelBuilder<Reader, SensorType> builder) {
        super(builder.getGui(), "sensorsGroup");
        this.setDesiredDimension(builder.getWidth(), builder.getHeight());
        this.setLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setZeroMargins()).setHorizontalMargin(2)).setControlsSpacing(4));
        this._activeSensorName = new Label(builder.getGui(), "activename", "");
        this._activeSensorName.setDesiredDimension(builder.getWidth(), 10);
        this._activeSensorName.setAutoSize(false);
        this.addControl((IControl)this._activeSensorName);
        List<SensorType> sensors = builder.getSensors();
        this._group = new PanelGroup<SensorType>(builder.getGui(), "behaviors", sensors);
        this._group.setDesiredDimension(builder.getWidth(), builder.getHeight() - 10 - 4 - 4);
        this.addControl((IControl)this._group);
        for (SensorGroupPanelBuilder.BehaviorGroupBuilder groupBuilder : builder.getGroupsBuilders()) {
            if (null == groupBuilder) continue;
            this._group.setPanel(groupBuilder.getSensor(), new SensorBehaviorGroupPanel(groupBuilder));
        }
    }

    public void setActiveSensor(SensorType sensor) {
        this._group.setActivePanel(sensor);
        this._activeSensorName.setText((Component)TextHelper.translatable(((ISensorType)sensor).getNameTranslationKey()));
    }

    public SensorSetting getSettings(ISensorSettingFactory<Reader, Writer, SensorType, SensorSetting> sensorSettingFactory, SensorSetting defaultValue) {
        return (SensorSetting)this._group.getActivePanel().filter(panel -> panel instanceof SensorBehaviorGroupPanel).map(panel -> (SensorBehaviorGroupPanel)panel).map(panel -> panel.getSettings(sensorSettingFactory, defaultValue)).orElse((AbstractSensorSetting)defaultValue);
    }

    public void resetControls() {
        this._activeSensorName.setText("");
        this._group.clearActivePanel();
        this._group.stream().filter(panel -> panel instanceof SensorBehaviorGroupPanel).map(panel -> (SensorBehaviorGroupPanel)panel).forEach(SensorBehaviorGroupPanel::resetControls);
    }

    public void setSettings(SensorSetting setting) {
        if (!this._group.isPanelIndexValid(((AbstractSensorSetting)setting).Sensor)) {
            return;
        }
        this._activeSensorName.setText((Component)TextHelper.translatable(((ISensorType)((AbstractSensorSetting)setting).Sensor).getNameTranslationKey()));
        this._group.setActivePanel(((AbstractSensorSetting)setting).Sensor);
        this._group.getActivePanel().filter(panel -> panel instanceof SensorBehaviorGroupPanel).map(panel -> (SensorBehaviorGroupPanel)panel).ifPresent(panel -> panel.setSettings(setting));
    }
}

