/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.entity.MantarayEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MantarayModel<T extends MantarayEntity>
extends AdvancedEntityModel<T> {
    private final ModelPart Body;
    private final ModelPart Tail;
    private final ModelPart Tail2;
    private final ModelPart LeftFlipper;
    private final ModelPart LeftFlipper2;
    private final ModelPart RightFlipper;
    private final ModelPart RightFlipper2;

    public MantarayModel(ModelPart root) {
        this.Body = root.getChild("Body");
        this.Tail = this.Body.getChild("Tail");
        this.Tail2 = this.Tail.getChild("Tail2");
        this.LeftFlipper = this.Body.getChild("LeftFlipper");
        this.LeftFlipper2 = this.LeftFlipper.getChild("LeftFlipper2");
        this.RightFlipper = this.Body.getChild("RightFlipper");
        this.RightFlipper2 = this.RightFlipper.getChild("RightFlipper2");
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Body.xRot = headPitch * ((float)Math.PI / 180);
        this.Body.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.Tail.xRot = -0.5f * headPitch * ((float)Math.PI / 180);
        this.Tail2.xRot = -0.25f * headPitch * ((float)Math.PI / 180);
        this.LeftFlipper.zRot = -0.34906584f;
        this.LeftFlipper2.zRot = -0.34906584f;
        this.RightFlipper.zRot = 0.34906584f;
        this.RightFlipper2.zRot = 0.34906584f;
        if (entity.getDeltaMovement().horizontalDistanceSqr() > 1.0E-7) {
            this.Body.xRot += -0.05f + -0.05f * Mth.cos((float)(ageInTicks * 0.2f));
            this.LeftFlipper.zRot = -0.6f * Mth.cos((float)(ageInTicks * 0.15f));
            this.LeftFlipper2.zRot = -0.6f * Mth.cos((float)(ageInTicks * 0.15f));
            this.RightFlipper.zRot = 0.6f * Mth.cos((float)(ageInTicks * 0.15f));
            this.RightFlipper2.zRot = 0.6f * Mth.cos((float)(ageInTicks * 0.15f));
        }
    }

    public void renderToBuffer(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.Body.render(matrixStack, buffer, packedLight, packedOverlay);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 38).addBox(-3.0f, -3.9f, -6.0f, 6.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 51).addBox(-3.5f, -3.5f, -6.0f, 7.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(28, 50).addBox(-3.5f, -1.75f, -6.0f, 7.0f, 1.0f, 11.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)0.0f, (float)23.5f, (float)0.0f));
        PartDefinition Tail = Body.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(46, 14).addBox(-1.5f, -2.0f, 0.0f, 3.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.5f, (float)5.0f));
        PartDefinition Tail2 = Tail.addOrReplaceChild("Tail2", CubeListBuilder.create().texOffs(33, 41).addBox(-0.5f, -1.5f, 0.0f, 1.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.25f, (float)6.0f));
        PartDefinition LeftFlipper = Body.addOrReplaceChild("LeftFlipper", CubeListBuilder.create().texOffs(0, 1).addBox(0.0f, -1.0f, -4.5f, 4.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5f, (float)-2.5f, (float)-0.25f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition LeftFlipper2 = LeftFlipper.addOrReplaceChild("LeftFlipper2", CubeListBuilder.create().texOffs(27, 3).addBox(0.0f, -1.0f, -4.25f, 2.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 13).addBox(0.0f, -0.5f, -4.25f, 2.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 23).addBox(2.0f, -1.0f, -4.0f, 3.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(48, 5).addBox(5.0f, -1.0f, -3.85f, 2.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(22, 16).addBox(7.0f, -1.0f, -3.7f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(22, 26).addBox(8.0f, -1.0f, -3.55f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(35, 18).addBox(9.0f, -1.0f, -3.4f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition RightFlipper = Body.addOrReplaceChild("RightFlipper", CubeListBuilder.create().texOffs(0, 1).mirror().addBox(-4.0f, -1.0f, -4.5f, 4.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.5f, (float)-2.5f, (float)-0.25f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition RightFlipper2 = RightFlipper.addOrReplaceChild("RightFlipper2", CubeListBuilder.create().texOffs(27, 3).mirror().addBox(-2.0f, -1.0f, -4.25f, 2.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 13).mirror().addBox(-2.0f, -0.5f, -4.25f, 2.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 23).mirror().addBox(-5.0f, -1.0f, -4.0f, 3.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(48, 5).mirror().addBox(-7.0f, -1.0f, -3.85f, 2.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(22, 16).mirror().addBox(-8.0f, -1.0f, -3.7f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(22, 26).mirror().addBox(-9.0f, -1.0f, -3.55f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(35, 18).mirror().addBox(-10.0f, -1.0f, -3.4f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(30, 33).addBox(-3.0f, -1.25f, -1.0f, 6.0f, 2.0f, 1.0f, new CubeDeformation(-0.01f)).texOffs(45, 34).addBox(-3.0f, 0.25f, -1.0f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.25f, (float)-5.75f));
        PartDefinition eyes = Head.addOrReplaceChild("eyes", CubeListBuilder.create().texOffs(22, 33).addBox(-2.6f, -0.25f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(15, 33).addBox(-2.6f, -0.75f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.01f)).texOffs(8, 33).addBox(1.6f, -0.25f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 33).addBox(1.6f, -0.75f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0131f, (float)-0.8491f, (float)0.1309f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

