/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.xmod.jei;

import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.client.gui.GuiCircuitCutter;
import com.glodblock.github.extendedae.client.gui.GuiCrystalAssembler;
import com.glodblock.github.extendedae.client.gui.GuiExInscriber;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.recipe.CircuitCutterRecipe;
import com.glodblock.github.extendedae.recipe.CrystalAssemblerRecipe;
import com.glodblock.github.extendedae.recipe.CrystalFixerRecipe;
import com.glodblock.github.extendedae.xmod.jei.recipe.CircuitCutterCategory;
import com.glodblock.github.extendedae.xmod.jei.recipe.CrystalAssemblerCategory;
import com.glodblock.github.extendedae.xmod.jei.recipe.CrystalFixerCategory;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import tamaized.ae2jeiintegration.integration.modules.jei.categories.ChargerCategory;
import tamaized.ae2jeiintegration.integration.modules.jei.categories.InscriberRecipeCategory;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return ExtendedAE.id("jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper helpers = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CrystalAssemblerCategory(helpers)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CircuitCutterCategory(helpers)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrystalFixerCategory(helpers)});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registry) {
        assert (Minecraft.getInstance().level != null);
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        registry.addRecipes(CrystalAssemblerCategory.RECIPE_TYPE, this.getRecipes(CrystalAssemblerRecipe.TYPE, manager));
        registry.addRecipes(CircuitCutterCategory.RECIPE_TYPE, this.getRecipes(CircuitCutterRecipe.TYPE, manager));
        registry.addRecipes(CrystalFixerCategory.RECIPE_TYPE, this.getRecipes(CrystalFixerRecipe.TYPE, manager));
        registry.addIngredientInfo((ItemLike)EAESingletons.ENTRO_CRYSTAL, new Component[]{Component.translatable((String)"emi.extendedae.desc.entro_crystal")});
        registry.addIngredientInfo((ItemLike)EAESingletons.ENTRO_SEED, new Component[]{Component.translatable((String)"emi.extendedae.desc.entro_seed")});
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((ItemLike)EAESingletons.CRYSTAL_ASSEMBLER, new RecipeType[]{CrystalAssemblerCategory.RECIPE_TYPE});
        registry.addRecipeCatalyst((ItemLike)EAESingletons.CIRCUIT_CUTTER, new RecipeType[]{CircuitCutterCategory.RECIPE_TYPE});
        registry.addRecipeCatalyst((ItemLike)EAESingletons.CRYSTAL_FIXER, new RecipeType[]{CrystalFixerCategory.RECIPE_TYPE});
        if (GlodUtil.checkMod((String)"ae2jeiintegration")) {
            registry.addRecipeCatalyst((ItemLike)EAESingletons.EX_CHARGER, new RecipeType[]{ChargerCategory.RECIPE_TYPE});
            registry.addRecipeCatalyst((ItemLike)EAESingletons.EX_INSCRIBER, new RecipeType[]{InscriberRecipeCategory.RECIPE_TYPE});
        }
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registry) {
        registry.addGenericGuiContainerHandler(GuiCrystalAssembler.class, (IGuiContainerHandler)new IGuiContainerHandler<GuiCrystalAssembler>(this){

            @NotNull
            public Collection<IGuiClickableArea> getGuiClickableAreas(@NotNull GuiCrystalAssembler screen, double mouseX, double mouseY) {
                return List.of(IGuiClickableArea.createBasic((int)81, (int)42, (int)40, (int)12, (RecipeType[])new RecipeType[]{CrystalAssemblerCategory.RECIPE_TYPE}));
            }
        });
        registry.addGenericGuiContainerHandler(GuiCircuitCutter.class, (IGuiContainerHandler)new IGuiContainerHandler<GuiCircuitCutter>(this){

            @NotNull
            public Collection<IGuiClickableArea> getGuiClickableAreas(@NotNull GuiCircuitCutter screen, double mouseX, double mouseY) {
                return List.of(IGuiClickableArea.createBasic((int)65, (int)39, (int)35, (int)12, (RecipeType[])new RecipeType[]{CircuitCutterCategory.RECIPE_TYPE}));
            }
        });
        if (GlodUtil.checkMod((String)"ae2jeiintegration")) {
            registry.addGenericGuiContainerHandler(GuiExInscriber.class, (IGuiContainerHandler)new IGuiContainerHandler<GuiExInscriber>(this){

                @NotNull
                public Collection<IGuiClickableArea> getGuiClickableAreas(@NotNull GuiExInscriber screen, double mouseX, double mouseY) {
                    return List.of(IGuiClickableArea.createBasic((int)82, (int)50, (int)26, (int)16, (RecipeType[])new RecipeType[]{InscriberRecipeCategory.RECIPE_TYPE}));
                }
            });
        }
    }

    private <I extends RecipeInput, T extends Recipe<I>> List<RecipeHolder<T>> getRecipes(net.minecraft.world.item.crafting.RecipeType<T> type, RecipeManager manager) {
        return manager.getAllRecipesFor(type);
    }
}

