/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common;

import appeng.api.AECapabilities;
import appeng.api.client.StorageCellModels;
import appeng.api.features.GridLinkables;
import appeng.api.features.IGridLinkableHandler;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.parts.PartModels;
import appeng.api.parts.RegisterPartCapabilitiesEvent;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.upgrades.Upgrades;
import appeng.block.AEBaseBlockItem;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.AEBaseInvBlockEntity;
import appeng.blockentity.ClientTickingBlockEntity;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.blockentity.powersink.AEBasePoweredBlockEntity;
import appeng.core.definitions.AEItems;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.crafting.pattern.AESmithingTablePattern;
import appeng.crafting.pattern.AEStonecuttingPattern;
import appeng.items.AEBaseItem;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.items.tools.powered.powersink.PoweredItemCapabilities;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.api.caps.ICrankPowered;
import com.glodblock.github.extendedae.api.caps.IGenericInvHost;
import com.glodblock.github.extendedae.api.caps.IMEStorageAccess;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.common.inventory.InfinityCellInventory;
import com.glodblock.github.extendedae.common.inventory.VoidCellInventory;
import com.glodblock.github.extendedae.common.items.ItemMEPackingTape;
import com.glodblock.github.extendedae.common.parts.PartActiveFormationPlane;
import com.glodblock.github.extendedae.common.parts.PartExExportBus;
import com.glodblock.github.extendedae.common.parts.PartExImportBus;
import com.glodblock.github.extendedae.common.parts.PartExInterface;
import com.glodblock.github.extendedae.common.parts.PartExPatternAccessTerminal;
import com.glodblock.github.extendedae.common.parts.PartExPatternProvider;
import com.glodblock.github.extendedae.common.parts.PartModExportBus;
import com.glodblock.github.extendedae.common.parts.PartModStorageBus;
import com.glodblock.github.extendedae.common.parts.PartOversizeInterface;
import com.glodblock.github.extendedae.common.parts.PartPreciseExportBus;
import com.glodblock.github.extendedae.common.parts.PartPreciseStorageBus;
import com.glodblock.github.extendedae.common.parts.PartTagExportBus;
import com.glodblock.github.extendedae.common.parts.PartTagStorageBus;
import com.glodblock.github.extendedae.common.parts.PartThresholdExportBus;
import com.glodblock.github.extendedae.common.parts.PartThresholdLevelEmitter;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixBase;
import com.glodblock.github.extendedae.config.ConfigCondition;
import com.glodblock.github.extendedae.config.EAEConfig;
import com.glodblock.github.extendedae.container.ContainerActiveFormationPlane;
import com.glodblock.github.extendedae.container.ContainerAssemblerMatrix;
import com.glodblock.github.extendedae.container.ContainerCaner;
import com.glodblock.github.extendedae.container.ContainerCircuitCutter;
import com.glodblock.github.extendedae.container.ContainerConfigModifier;
import com.glodblock.github.extendedae.container.ContainerCrystalAssembler;
import com.glodblock.github.extendedae.container.ContainerExDrive;
import com.glodblock.github.extendedae.container.ContainerExIOBus;
import com.glodblock.github.extendedae.container.ContainerExIOPort;
import com.glodblock.github.extendedae.container.ContainerExInscriber;
import com.glodblock.github.extendedae.container.ContainerExInterface;
import com.glodblock.github.extendedae.container.ContainerExMolecularAssembler;
import com.glodblock.github.extendedae.container.ContainerExPatternProvider;
import com.glodblock.github.extendedae.container.ContainerExPatternTerminal;
import com.glodblock.github.extendedae.container.ContainerIngredientBuffer;
import com.glodblock.github.extendedae.container.ContainerModExportBus;
import com.glodblock.github.extendedae.container.ContainerModStorageBus;
import com.glodblock.github.extendedae.container.ContainerPatternModifier;
import com.glodblock.github.extendedae.container.ContainerPreciseExportBus;
import com.glodblock.github.extendedae.container.ContainerPreciseStorageBus;
import com.glodblock.github.extendedae.container.ContainerRenamer;
import com.glodblock.github.extendedae.container.ContainerTagExportBus;
import com.glodblock.github.extendedae.container.ContainerTagStorageBus;
import com.glodblock.github.extendedae.container.ContainerThresholdExportBus;
import com.glodblock.github.extendedae.container.ContainerThresholdLevelEmitter;
import com.glodblock.github.extendedae.container.ContainerVoidCell;
import com.glodblock.github.extendedae.container.ContainerWirelessConnector;
import com.glodblock.github.extendedae.container.ContainerWirelessHub;
import com.glodblock.github.extendedae.container.pattern.ContainerCraftingPattern;
import com.glodblock.github.extendedae.container.pattern.ContainerProcessingPattern;
import com.glodblock.github.extendedae.container.pattern.ContainerSmithingTablePattern;
import com.glodblock.github.extendedae.container.pattern.ContainerStonecuttingPattern;
import com.glodblock.github.extendedae.container.pattern.PatternGuiHandler;
import com.glodblock.github.extendedae.recipe.CircuitCutterRecipe;
import com.glodblock.github.extendedae.recipe.CircuitCutterRecipeSerializer;
import com.glodblock.github.extendedae.recipe.CrystalAssemblerRecipe;
import com.glodblock.github.extendedae.recipe.CrystalAssemblerRecipeSerializer;
import com.glodblock.github.extendedae.recipe.CrystalFixerRecipe;
import com.glodblock.github.extendedae.recipe.CrystalFixerRecipeSerializer;
import com.glodblock.github.extendedae.xmod.aae.AAECommonLoad;
import com.glodblock.github.extendedae.xmod.aae.AAERegister;
import com.glodblock.github.extendedae.xmod.appflux.AFCommonLoad;
import com.glodblock.github.extendedae.xmod.framedblocks.FBCommonLoad;
import com.glodblock.github.extendedae.xmod.framedblocks.FBRegister;
import com.glodblock.github.extendedae.xmod.megacells.MEGACommonLoad;
import com.glodblock.github.extendedae.xmod.wt.ContainerWirelessExPAT;
import com.glodblock.github.glodium.registry.RegistryHandler;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.Collection;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class EAERegistryHandler
extends RegistryHandler {
    public static final EAERegistryHandler INSTANCE = new EAERegistryHandler();

    public EAERegistryHandler() {
        super("extendedae");
        this.cap(AEBaseInvBlockEntity.class, Capabilities.ItemHandler.BLOCK, AEBaseInvBlockEntity::getExposedItemHandler);
        this.cap(AEBasePoweredBlockEntity.class, Capabilities.EnergyStorage.BLOCK, AEBasePoweredBlockEntity::getEnergyStorage);
        this.cap(IInWorldGridNodeHost.class, AECapabilities.IN_WORLD_GRID_NODE_HOST, (object, context) -> object);
        this.cap(IAEItemPowerStorage.class, Capabilities.EnergyStorage.ITEM, (object, context) -> new PoweredItemCapabilities(object, (IAEItemPowerStorage)object.getItem()));
        this.cap(ICrankPowered.class, AECapabilities.CRANKABLE, ICrankPowered::getCrankable);
        this.cap(ICraftingMachine.class, AECapabilities.CRAFTING_MACHINE, (object, context) -> object);
        this.cap(IGenericInvHost.class, AECapabilities.GENERIC_INTERNAL_INV, IGenericInvHost::getGenericInv);
        this.cap(IMEStorageAccess.class, AECapabilities.ME_STORAGE, IMEStorageAccess::getMEStorage);
        this.cap(TileAssemblerMatrixBase.class, Capabilities.ItemHandler.BLOCK, TileAssemblerMatrixBase::getPatternInv);
    }

    public <T extends AEBaseBlockEntity> void block(String name, AEBaseEntityBlock<T> block, Class<T> clazz, BlockEntityType.BlockEntitySupplier<? extends T> supplier) {
        this.bindTileEntity(clazz, block, supplier);
        this.block(name, (Block)block, b -> new AEBaseBlockItem(b, new Item.Properties()));
        this.tile(name, block.getBlockEntityType());
    }

    public void runRegister() {
        super.runRegister();
        this.onRegisterContainer();
        this.onRegisterModels();
        this.onRegisterRecipe();
    }

    public Collection<Block> getBlocks() {
        return this.blocks.stream().map(Pair::getRight).toList();
    }

    @SubscribeEvent
    public void onRegisterCapability(RegisterPartCapabilitiesEvent event) {
        PartExInterface.registerCapability(event);
        PartExPatternProvider.registerCapability(event);
        PartOversizeInterface.registerCapability(event);
    }

    @SubscribeEvent
    public void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        super.onRegisterCapabilities(event);
    }

    private void onRegisterRecipe() {
        Registry.register((Registry)NeoForgeRegistries.CONDITION_SERIALIZERS, (ResourceLocation)ExtendedAE.id("config"), ConfigCondition.CODEC);
        Registry.register((Registry)BuiltInRegistries.RECIPE_TYPE, (ResourceLocation)CrystalAssemblerRecipe.ID, CrystalAssemblerRecipe.TYPE);
        Registry.register((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (ResourceLocation)CrystalAssemblerRecipe.ID, (Object)CrystalAssemblerRecipeSerializer.INSTANCE);
        Registry.register((Registry)BuiltInRegistries.RECIPE_TYPE, (ResourceLocation)CircuitCutterRecipe.ID, CircuitCutterRecipe.TYPE);
        Registry.register((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (ResourceLocation)CircuitCutterRecipe.ID, (Object)CircuitCutterRecipeSerializer.INSTANCE);
        Registry.register((Registry)BuiltInRegistries.RECIPE_TYPE, (ResourceLocation)CrystalFixerRecipe.ID, CrystalFixerRecipe.TYPE);
        Registry.register((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (ResourceLocation)CrystalFixerRecipe.ID, (Object)CrystalFixerRecipeSerializer.INSTANCE);
    }

    private void onRegisterContainer() {
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("ex_pattern_provider"), ContainerExPatternProvider.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("ex_interface"), ContainerExInterface.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("ex_export_bus"), ContainerExIOBus.EXPORT_TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("ex_import_bus"), ContainerExIOBus.IMPORT_TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("ex_pattern_access_terminal"), ContainerExPatternTerminal.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("wireless_connector"), ContainerWirelessConnector.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("ingredient_buffer"), ContainerIngredientBuffer.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("ex_drive"), ContainerExDrive.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("pattern_modifier"), ContainerPatternModifier.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("ex_molecular_assembler"), ContainerExMolecularAssembler.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("ex_inscriber"), ContainerExInscriber.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("tag_storage_bus"), ContainerTagStorageBus.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("tag_export_bus"), ContainerTagExportBus.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("threshold_level_emitter"), ContainerThresholdLevelEmitter.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("renamer"), ContainerRenamer.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("mod_storage_bus"), ContainerModStorageBus.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("mod_export_bus"), ContainerModExportBus.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("active_formation_plane"), ContainerActiveFormationPlane.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("caner"), ContainerCaner.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("precise_export_bus"), ContainerPreciseExportBus.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("u_wireless_ex_pattern_access_terminal"), ContainerWirelessExPAT.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("ex_ioport"), ContainerExIOPort.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("precise_storage_bus"), ContainerPreciseStorageBus.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("threshold_export_bus"), ContainerThresholdExportBus.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("crystal_assembler"), ContainerCrystalAssembler.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("circuit_cutter"), ContainerCircuitCutter.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("oversize_interface"), ContainerExInterface.TYPE_OVERSIZE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("assembler_matrix"), ContainerAssemblerMatrix.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("void_cell"), ContainerVoidCell.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("config_modifier"), ContainerConfigModifier.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ExtendedAE.id("wireless_hub"), ContainerWirelessHub.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ContainerProcessingPattern.ID, ContainerProcessingPattern.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ContainerCraftingPattern.ID, ContainerCraftingPattern.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ContainerStonecuttingPattern.ID, ContainerStonecuttingPattern.TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ContainerSmithingTablePattern.ID, ContainerSmithingTablePattern.TYPE);
        if (GlodUtil.checkMod((String)"framedblocks")) {
            FBRegister.register();
        }
        if (GlodUtil.checkMod((String)"advanced_ae")) {
            AAERegister.register();
        }
    }

    private <T extends AEBaseBlockEntity> void bindTileEntity(Class<T> clazz, AEBaseEntityBlock<T> block, BlockEntityType.BlockEntitySupplier<? extends T> supplier) {
        BlockEntityTicker serverTicker = null;
        if (ServerTickingBlockEntity.class.isAssignableFrom(clazz)) {
            serverTicker = (level, pos, state, entity) -> ((ServerTickingBlockEntity)entity).serverTick();
        }
        BlockEntityTicker clientTicker = null;
        if (ClientTickingBlockEntity.class.isAssignableFrom(clazz)) {
            clientTicker = (level, pos, state, entity) -> ((ClientTickingBlockEntity)entity).clientTick();
        }
        block.setBlockEntity(clazz, GlodUtil.getTileType(clazz, supplier, block), clientTicker, serverTicker);
    }

    public void onInit() {
        for (Pair entry : this.blocks) {
            Block block = (Block)entry.getRight();
            if (!(block instanceof AEBaseEntityBlock)) continue;
            AEBaseBlockEntity.registerBlockEntityItem((BlockEntityType)((AEBaseEntityBlock)block).getBlockEntityType(), (Item)block.asItem());
        }
        this.registerAEUpgrade();
        this.registerStorageHandler();
        this.registerRandomAPI();
        this.initPackageList();
        if (GlodUtil.checkMod((String)"appflux")) {
            AFCommonLoad.init();
        }
        if (GlodUtil.checkMod((String)"megacells")) {
            MEGACommonLoad.init();
        }
    }

    private void registerAEUpgrade() {
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, (ItemLike)EAESingletons.EX_INTERFACE, (int)1, (String)"gui.extendedae.ex_interface");
        Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, (ItemLike)EAESingletons.EX_INTERFACE, (int)1, (String)"gui.extendedae.ex_interface");
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, EAESingletons.EX_INTERFACE_PART, (int)1, (String)"gui.extendedae.ex_interface");
        Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, EAESingletons.EX_INTERFACE_PART, (int)1, (String)"gui.extendedae.ex_interface");
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, (ItemLike)EAESingletons.OVERSIZE_INTERFACE, (int)1, (String)"gui.extendedae.oversize_interface");
        Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, (ItemLike)EAESingletons.OVERSIZE_INTERFACE, (int)1, (String)"gui.extendedae.oversize_interface");
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, EAESingletons.OVERSIZE_INTERFACE_PART, (int)1, (String)"gui.extendedae.oversize_interface");
        Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, EAESingletons.OVERSIZE_INTERFACE_PART, (int)1, (String)"gui.extendedae.oversize_interface");
        Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, EAESingletons.EX_EXPORT_BUS, (int)5, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, EAESingletons.EX_EXPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, EAESingletons.EX_EXPORT_BUS, (int)4, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, EAESingletons.EX_EXPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, EAESingletons.EX_EXPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, EAESingletons.EX_IMPORT_BUS, (int)5, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, EAESingletons.EX_IMPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, EAESingletons.EX_IMPORT_BUS, (int)4, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.INVERTER_CARD, EAESingletons.EX_IMPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, EAESingletons.EX_IMPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((ItemLike)AEItems.ENERGY_CARD, (ItemLike)EAESingletons.WIRELESS_CONNECTOR, (int)4);
        Upgrades.add((ItemLike)AEItems.ENERGY_CARD, (ItemLike)EAESingletons.WIRELESS_HUB, (int)4);
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, (ItemLike)EAESingletons.EX_ASSEMBLER, (int)5);
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, (ItemLike)EAESingletons.EX_INSCRIBER, (int)4);
        Upgrades.add((ItemLike)AEItems.INVERTER_CARD, EAESingletons.TAG_STORAGE_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.VOID_CARD, EAESingletons.TAG_STORAGE_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, EAESingletons.TAG_EXPORT_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, EAESingletons.TAG_EXPORT_BUS, (int)4);
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, EAESingletons.THRESHOLD_LEVEL_EMITTER, (int)1);
        Upgrades.add((ItemLike)AEItems.INVERTER_CARD, EAESingletons.MOD_STORAGE_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.VOID_CARD, EAESingletons.MOD_STORAGE_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, EAESingletons.MOD_EXPORT_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, EAESingletons.MOD_EXPORT_BUS, (int)4);
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, EAESingletons.ACTIVE_FORMATION_PLANE, (int)1);
        Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, EAESingletons.ACTIVE_FORMATION_PLANE, (int)1);
        Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, EAESingletons.ACTIVE_FORMATION_PLANE, (int)5);
        Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, EAESingletons.PRECISE_EXPORT_BUS, (int)5);
        Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, EAESingletons.PRECISE_EXPORT_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, EAESingletons.PRECISE_EXPORT_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, (ItemLike)EAESingletons.EX_IO_PORT, (int)5);
        Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, (ItemLike)EAESingletons.EX_IO_PORT, (int)1);
        Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, EAESingletons.PRECISE_STORAGE_BUS, (int)5);
        Upgrades.add((ItemLike)AEItems.VOID_CARD, EAESingletons.PRECISE_STORAGE_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, EAESingletons.THRESHOLD_EXPORT_BUS, (int)5);
        Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, EAESingletons.THRESHOLD_EXPORT_BUS, (int)1);
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, EAESingletons.THRESHOLD_EXPORT_BUS, (int)4);
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, (ItemLike)EAESingletons.CRYSTAL_ASSEMBLER, (int)4);
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, (ItemLike)EAESingletons.CIRCUIT_CUTTER, (int)4);
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, (ItemLike)EAESingletons.VOID_CELL, (int)1);
        Upgrades.add((ItemLike)AEItems.INVERTER_CARD, (ItemLike)EAESingletons.VOID_CELL, (int)1);
    }

    private void registerStorageHandler() {
        StorageCells.addCellHandler((ICellHandler)InfinityCellInventory.HANDLER);
        StorageCells.addCellHandler((ICellHandler)VoidCellInventory.HANDLER);
        StorageCellModels.registerModel((ItemLike)EAESingletons.INFINITY_WATER_CELL, (ResourceLocation)ExtendedAE.id("block/drive/infinity_water_cell"));
        StorageCellModels.registerModel((ItemLike)EAESingletons.INFINITY_COBBLESTONE_CELL, (ResourceLocation)ExtendedAE.id("block/drive/infinity_cobblestone_cell"));
        StorageCellModels.registerModel((ItemLike)EAESingletons.VOID_CELL, (ResourceLocation)ExtendedAE.id("block/drive/void_cell"));
    }

    private void onRegisterModels() {
        PartModels.registerModels(PartExPatternProvider.MODELS);
        PartModels.registerModels(PartExInterface.MODELS);
        PartModels.registerModels(PartExExportBus.MODELS);
        PartModels.registerModels(PartExImportBus.MODELS);
        PartModels.registerModels(PartExPatternAccessTerminal.MODELS);
        PartModels.registerModels((ResourceLocation[])new ResourceLocation[]{PartTagStorageBus.MODEL_BASE});
        PartModels.registerModels((ResourceLocation[])new ResourceLocation[]{PartTagExportBus.MODEL_BASE});
        PartModels.registerModels(PartThresholdLevelEmitter.MODELS);
        PartModels.registerModels((ResourceLocation[])new ResourceLocation[]{PartModStorageBus.MODEL_BASE});
        PartModels.registerModels((ResourceLocation[])new ResourceLocation[]{PartModExportBus.MODEL_BASE});
        PartModels.registerModels(PartActiveFormationPlane.MODELS);
        PartModels.registerModels(PartPreciseExportBus.MODELS);
        PartModels.registerModels((ResourceLocation[])new ResourceLocation[]{PartPreciseStorageBus.MODEL_BASE});
        PartModels.registerModels(PartThresholdExportBus.MODELS);
        PartModels.registerModels(PartOversizeInterface.MODELS);
    }

    private void initPackageList() {
        EAEConfig.tapeWhitelist.forEach(ItemMEPackingTape::registerPackableDevice);
    }

    private void registerRandomAPI() {
        GridLinkables.register((ItemLike)EAESingletons.WIRELESS_EX_PAT, (IGridLinkableHandler)WirelessTerminalItem.LINKABLE_HANDLER);
        PatternGuiHandler.addPatternHandler(AEProcessingPattern.class, ContainerProcessingPattern.ID);
        PatternGuiHandler.addPatternHandler(AECraftingPattern.class, ContainerCraftingPattern.ID);
        PatternGuiHandler.addPatternHandler(AEStonecuttingPattern.class, ContainerStonecuttingPattern.ID);
        PatternGuiHandler.addPatternHandler(AESmithingTablePattern.class, ContainerSmithingTablePattern.ID);
        if (GlodUtil.checkMod((String)"framedblocks")) {
            FBCommonLoad.init();
        }
        if (GlodUtil.checkMod((String)"advanced_ae")) {
            AAECommonLoad.init();
        }
    }

    public void registerTab(Registry<CreativeModeTab> registry) {
        CreativeModeTab tab = CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)EAESingletons.EX_PATTERN_PROVIDER)).title((Component)Component.translatable((String)"itemGroup.extendedae")).displayItems((p, o) -> {
            for (Pair entry : this.items) {
                Object patt0$temp = entry.getRight();
                if (patt0$temp instanceof AEBaseItem) {
                    AEBaseItem aeItem = (AEBaseItem)patt0$temp;
                    aeItem.addToMainCreativeTab(p, o);
                    continue;
                }
                o.accept((ItemLike)entry.getRight());
            }
            for (Pair entry : this.blocks) {
                o.accept((ItemLike)entry.getRight());
            }
        }).build();
        Registry.register(registry, (ResourceLocation)ExtendedAE.id("tab_main"), (Object)tab);
    }
}

