/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.menu.implementations.UpgradeableMenu;
import com.glodblock.github.extendedae.client.button.HighlightButton;
import com.glodblock.github.extendedae.client.button.TooltipIcon;
import com.glodblock.github.extendedae.client.gui.widget.WorldDisplay;
import com.glodblock.github.extendedae.common.me.wireless.WirelessStatus;
import com.glodblock.github.extendedae.container.ContainerWirelessConnector;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.Level;

public class GuiWirelessConnector
extends UpgradeableScreen<ContainerWirelessConnector> {
    public static final int PADDING_X = 8;
    public static final int PADDING_Y = 6;
    private final TooltipIcon statusIcon = new TooltipIcon();
    private final HighlightButton highlight;
    private final WorldDisplay remote = new WorldDisplay((AEBaseScreen<?>)this, 0, 0, 129, 63);
    private BlockPos lastPos = null;

    public GuiWirelessConnector(ContainerWirelessConnector menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.highlight = new HighlightButton();
        this.highlight.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.wireless_connect.highlight.tooltip")));
    }

    public void init() {
        super.init();
        this.statusIcon.setPosition(this.leftPos + 152, this.topPos + 6 - 1);
        this.remote.setPosition(this.leftPos + 24, this.topPos + 76);
        this.highlight.setPosition(this.leftPos + 152, this.topPos + 6 + 21);
        this.remote.refreshBounds();
        this.addRenderableOnly((Renderable)this.statusIcon);
        this.addRenderableWidget((GuiEventListener)this.remote);
        this.addRenderableWidget((GuiEventListener)this.highlight);
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        if (((ContainerWirelessConnector)this.menu).status == WirelessStatus.WORKING) {
            BlockPos remotePos = BlockPos.of((long)((ContainerWirelessConnector)this.menu).otherSide);
            if (!Objects.equals(remotePos, this.lastPos)) {
                this.remote.locate(remotePos);
                this.lastPos = remotePos;
            }
            this.highlight.setTarget(remotePos, (ResourceKey<Level>)this.getPlayer().clientLevel.dimension());
            this.highlight.setMultiplier(this.playerToBlockDis(remotePos));
            this.highlight.setSuccessJob(() -> {
                if (this.getPlayer() != null) {
                    this.getPlayer().displayClientMessage((Component)Component.translatable((String)"chat.wireless.highlight", (Object[])new Object[]{remotePos.toShortString(), this.getPlayer().clientLevel.dimension().location().getPath()}), false);
                }
            });
            this.highlight.setVisibility(true);
        } else {
            this.remote.unload();
            this.highlight.setVisibility(false);
        }
    }

    private double playerToBlockDis(BlockPos pos) {
        if (pos == null) {
            return 0.0;
        }
        BlockPos ps = this.getPlayer().getOnPos();
        return pos.distSqr((Vec3i)ps);
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        int len = 12;
        this.statusIcon.setTooltip(Tooltip.create((Component)((ContainerWirelessConnector)this.menu).status.getDesc()));
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.wireless_connect.status", (Object[])new Object[]{((ContainerWirelessConnector)this.menu).status.getTranslation()}), 8, 6 + len, textColor, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.wireless_connect.power", (Object[])new Object[]{String.format("%.2f", ((ContainerWirelessConnector)this.menu).powerUse)}), 8, 6 + len * 2, textColor, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.wireless_connect.channel", (Object[])new Object[]{((ContainerWirelessConnector)this.menu).usedChannel, ((ContainerWirelessConnector)this.menu).maxChannel}), 8, 6 + len * 3, textColor, false);
        if (((ContainerWirelessConnector)this.menu).status == WirelessStatus.WORKING) {
            BlockPos pos = BlockPos.of((long)((ContainerWirelessConnector)this.menu).otherSide);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.wireless_connect.remote", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}), 22, 62, textColor, false);
        }
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.remote.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY)) {
            return true;
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.remote.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY)) {
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }
}

