/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common;

import com.direwolf20.mininggadgets.common.capabilities.EnergyStorageItemstack;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.network.PacketHandler;
import com.direwolf20.mininggadgets.common.tiles.ModificationTableTileEntity;
import com.direwolf20.mininggadgets.setup.ClientSetup;
import com.direwolf20.mininggadgets.setup.Config;
import com.direwolf20.mininggadgets.setup.ModSetup;
import com.direwolf20.mininggadgets.setup.Registration;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mininggadgets")
public class MiningGadgets {
    public static final String MOD_ID = "mininggadgets";
    private static final Logger LOGGER = LogManager.getLogger();

    public MiningGadgets(IEventBus event, ModContainer container) {
        Registration.init(event);
        Config.register(container);
        event.addListener(ModSetup::init);
        ModSetup.TABS.register(event);
        NeoForge.EVENT_BUS.register((Object)this);
        event.addListener(PacketHandler::registerNetworking);
        event.addListener(this::registerCapabilities);
        if (FMLLoader.getDist().isClient()) {
            event.addListener(ClientSetup::init);
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.EnergyStorage.ITEM, (itemStack, context) -> new EnergyStorageItemstack(((MiningGadget)itemStack.getItem()).getEnergyMax(), (ItemStack)itemStack), new ItemLike[]{(ItemLike)Registration.MININGGADGET.get(), (ItemLike)Registration.MININGGADGET_FANCY.get(), (ItemLike)Registration.MININGGADGET_SIMPLE.get()});
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, be, side) -> ((ModificationTableTileEntity)be).handler, new Block[]{(Block)Registration.MODIFICATION_TABLE.get()});
    }

    @SubscribeEvent
    public void rightClickEvent(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = MiningGadget.getGadget(event.getEntity());
        if (stack.getItem() instanceof MiningGadget && (this.stackIsAnnoying(event.getEntity().getMainHandItem()) || this.stackIsAnnoying(event.getEntity().getOffhandItem()) || event.getLevel().getBlockState(event.getPos()).getBlock() instanceof RedStoneOreBlock)) {
            event.setCanceled(true);
        }
    }

    private boolean stackIsAnnoying(ItemStack stack) {
        if (!(stack.getItem() instanceof BlockItem)) {
            return false;
        }
        Block block = ((BlockItem)stack.getItem()).getBlock();
        return block instanceof TorchBlock || block instanceof LanternBlock || block.equals(Blocks.GLOWSTONE) || block instanceof RedstoneLampBlock || block instanceof EndRodBlock;
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

