/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.storage;

import java.util.Iterator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageSlotted;
import org.cyclops.cyclopscore.ingredient.collection.IngredientArrayList;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionHelpers;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollections;
import org.cyclops.cyclopscore.ingredient.storage.InconsistentIngredientInsertionException;
import org.cyclops.cyclopscore.ingredient.storage.IngredientComponentStorageCollectionWrapper;
import org.cyclops.cyclopscore.ingredient.storage.IngredientComponentStorageSlottedCollectionWrapper;
import org.cyclops.cyclopscore.ingredient.storage.IngredientComponentStorageSlottedWrapped;
import org.cyclops.cyclopscore.ingredient.storage.IngredientComponentStorageWrapped;

public final class IngredientStorageHelpers {
    public static <T, M> T moveIngredientsIterative(IIngredientComponentStorage<T, M> source, IIngredientComponentStorage<T, M> destination, long maxQuantity, boolean simulate) throws InconsistentIngredientInsertionException {
        long movedFirstQuantity;
        T moved;
        long movedQuantity;
        IngredientComponent component = source.getComponent();
        IIngredientMatcher matcher = component.getMatcher();
        Object movedFirst = IngredientStorageHelpers.moveIngredients(source, destination, maxQuantity, simulate);
        if (simulate || movedQuantity == 0L) {
            return movedFirst;
        }
        Object matchCondition = matcher.getExactMatchNoQuantityCondition();
        for (movedQuantity = movedFirstQuantity = matcher.getQuantity(movedFirst); movedQuantity < maxQuantity; movedQuantity += matcher.getQuantity(moved)) {
            long toMoveQuantity = maxQuantity - movedQuantity;
            if (toMoveQuantity < movedFirstQuantity) {
                movedFirst = matcher.withQuantity(movedFirst, toMoveQuantity);
            }
            if (matcher.isEmpty(moved = IngredientStorageHelpers.moveIngredients(source, destination, movedFirst, matchCondition, false))) break;
        }
        return (T)matcher.withQuantity(movedFirst, movedQuantity);
    }

    public static <T, M> T moveIngredients(IIngredientComponentStorage<T, M> source, IIngredientComponentStorage<T, M> destination, long maxQuantity, boolean simulate) throws InconsistentIngredientInsertionException {
        IIngredientMatcher matcher = source.getComponent().getMatcher();
        Object extractedSimulated = source.extract(maxQuantity, true);
        long movableQuantity = IngredientStorageHelpers.insertIngredientQuantity(destination, extractedSimulated, true);
        if (movableQuantity > 0L) {
            if (simulate) {
                if (maxQuantity == movableQuantity) {
                    return (T)extractedSimulated;
                }
                return (T)matcher.withQuantity(extractedSimulated, movableQuantity);
            }
            Object extracted = source.extract(movableQuantity, false);
            return (T)IngredientStorageHelpers.insertIngredientRemainderFixup(source, destination, extracted, false);
        }
        return (T)matcher.getEmptyInstance();
    }

    public static <T, M> T moveIngredientsIterative(IIngredientComponentStorage<T, M> source, IIngredientComponentStorage<T, M> destination, T instance, M matchCondition, boolean simulate) throws InconsistentIngredientInsertionException {
        long movedFirstQuantity;
        T moved;
        long movedQuantity;
        IngredientComponent component = source.getComponent();
        IIngredientMatcher matcher = component.getMatcher();
        long maxQuantity = matcher.getQuantity(instance);
        Object movedFirst = IngredientStorageHelpers.moveIngredients(source, destination, instance, matchCondition, simulate);
        if (simulate || movedQuantity == 0L) {
            return movedFirst;
        }
        for (movedQuantity = movedFirstQuantity = matcher.getQuantity(movedFirst); movedQuantity < maxQuantity; movedQuantity += matcher.getQuantity(moved)) {
            long toMoveQuantity = maxQuantity - movedQuantity;
            if (toMoveQuantity < movedFirstQuantity) {
                movedFirst = matcher.withQuantity(movedFirst, toMoveQuantity);
            }
            if (matcher.isEmpty(moved = IngredientStorageHelpers.moveIngredients(source, destination, movedFirst, matchCondition, false))) break;
        }
        return (T)matcher.withQuantity(movedFirst, movedQuantity);
    }

    public static <T, M> T moveIngredients(IIngredientComponentStorage<T, M> source, IIngredientComponentStorage<T, M> destination, T instance, M matchCondition, boolean simulate) throws InconsistentIngredientInsertionException {
        IIngredientMatcher matcher = source.getComponent().getMatcher();
        Iterator it = source.iterator(instance, matcher.withoutCondition(matchCondition, source.getComponent().getPrimaryQuantifier().getMatchCondition()));
        Object matchConditionExact = matcher.hasCondition(matchCondition, source.getComponent().getPrimaryQuantifier().getMatchCondition()) ? matcher.getExactMatchCondition() : matcher.getExactMatchNoQuantityCondition();
        long prototypeQuantity = matcher.getQuantity(instance);
        while (it.hasNext()) {
            T moved;
            Object extractedSimulated = it.next();
            if (matcher.getQuantity(extractedSimulated) != prototypeQuantity) {
                extractedSimulated = matcher.withQuantity(extractedSimulated, prototypeQuantity);
            }
            if (matcher.isEmpty(moved = IngredientStorageHelpers.moveIngredient(source, destination, extractedSimulated, matchConditionExact, simulate))) continue;
            return moved;
        }
        return (T)matcher.getEmptyInstance();
    }

    public static <T, M> T moveIngredients(IIngredientComponentStorage<T, M> source, IIngredientComponentStorage<T, M> destination, Predicate<T> predicate, long maxQuantity, boolean exactQuantity, boolean simulate) throws InconsistentIngredientInsertionException {
        IIngredientMatcher matcher = source.getComponent().getMatcher();
        for (Object extractedSimulated : source) {
            T movable;
            if (!predicate.test(extractedSimulated)) continue;
            if (matcher.getQuantity(extractedSimulated) > maxQuantity) {
                extractedSimulated = matcher.withQuantity(extractedSimulated, maxQuantity);
            }
            if (matcher.isEmpty(extractedSimulated = source.extract(extractedSimulated, matcher.getExactMatchNoQuantityCondition(), true)) || matcher.isEmpty(movable = IngredientStorageHelpers.insertIngredient(destination, extractedSimulated, true)) || !(exactQuantity ? matcher.getQuantity(movable) == maxQuantity : matcher.getQuantity(movable) <= maxQuantity)) continue;
            if (simulate) {
                return movable;
            }
            Object extracted = source.extract(movable, matcher.getExactMatchNoQuantityCondition(), false);
            return (T)IngredientStorageHelpers.insertIngredientRemainderFixup(source, destination, extracted, false);
        }
        return (T)matcher.getEmptyInstance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T, M> T moveIngredientsSlotted(IIngredientComponentStorage<T, M> source, int sourceSlot, IIngredientComponentStorage<T, M> destination, int destinationSlot, T instance, M matchCondition, boolean simulate) throws InconsistentIngredientInsertionException {
        boolean loopDestinationSlots;
        IIngredientMatcher matcher = source.getComponent().getMatcher();
        if (matcher.getQuantity(instance) <= 0L) {
            return (T)matcher.getEmptyInstance();
        }
        boolean loopSourceSlots = sourceSlot < 0;
        boolean bl = loopDestinationSlots = destinationSlot < 0;
        if (!loopSourceSlots && !loopDestinationSlots) {
            Object remaining;
            long remainingQuantity;
            if (!(source instanceof IIngredientComponentStorageSlotted)) {
                return (T)matcher.getEmptyInstance();
            }
            if (!(destination instanceof IIngredientComponentStorageSlotted)) {
                return (T)matcher.getEmptyInstance();
            }
            IIngredientComponentStorageSlotted sourceSlotted = (IIngredientComponentStorageSlotted)source;
            IIngredientComponentStorageSlotted destinationSlotted = (IIngredientComponentStorageSlotted)destination;
            if (sourceSlot >= sourceSlotted.getSlots() || destinationSlot >= destinationSlotted.getSlots()) {
                return (T)matcher.getEmptyInstance();
            }
            long prototypeQuantity = matcher.getQuantity(instance);
            Object extractedSimulated = sourceSlotted.extract(sourceSlot, prototypeQuantity, true);
            if (matcher.isEmpty(extractedSimulated) || !matcher.matches(instance, extractedSimulated, matchCondition) || (remainingQuantity = matcher.getQuantity(remaining = destinationSlotted.insert(destinationSlot, extractedSimulated, true))) != 0L && (remainingQuantity >= prototypeQuantity || matcher.hasCondition(matchCondition, source.getComponent().getPrimaryQuantifier().getMatchCondition()))) return (T)matcher.getEmptyInstance();
            return (T)IngredientStorageHelpers.moveEffectiveSourceExactDestinationExact(sourceSlotted, sourceSlot, destinationSlotted, destinationSlot, extractedSimulated, remaining, simulate);
        }
        if (loopSourceSlots) {
            if (source instanceof IIngredientComponentStorageSlotted) {
                IIngredientComponentStorageSlotted sourceSlotted = (IIngredientComponentStorageSlotted)source;
                int slots = sourceSlotted.getSlots();
                for (int slot = 0; slot < slots; ++slot) {
                    T moved = IngredientStorageHelpers.moveIngredientsSlotted(source, slot, destination, destinationSlot, instance, matchCondition, simulate);
                    if (matcher.isEmpty(moved)) continue;
                    return moved;
                }
                return (T)matcher.getEmptyInstance();
            } else {
                long prototypeQuantity = matcher.getQuantity(instance);
                if (loopDestinationSlots) {
                    if (!matcher.hasCondition(matchCondition, source.getComponent().getPrimaryQuantifier().getMatchCondition()) || !(destination instanceof IIngredientComponentStorageSlotted)) return IngredientStorageHelpers.moveIngredients(source, destination, instance, matchCondition, simulate);
                    IIngredientComponentStorageSlotted destinationSlotted = (IIngredientComponentStorageSlotted)destination;
                    int slots = destinationSlotted.getSlots();
                    for (int slot = 0; slot < slots; ++slot) {
                        T moved = IngredientStorageHelpers.moveIngredientsSlotted(source, sourceSlot, destination, slot, instance, matchCondition, simulate);
                        if (matcher.isEmpty(moved)) continue;
                        return moved;
                    }
                    return (T)matcher.getEmptyInstance();
                } else {
                    if (!(destination instanceof IIngredientComponentStorageSlotted)) {
                        return (T)matcher.getEmptyInstance();
                    }
                    IIngredientComponentStorageSlotted destinationSlotted = (IIngredientComponentStorageSlotted)destination;
                    if (destinationSlot >= destinationSlotted.getSlots()) {
                        return (T)matcher.getEmptyInstance();
                    }
                    for (Object sourceInstance : source) {
                        Object moved;
                        Object remaining;
                        long remainingQuantity;
                        Object extractedSimulated;
                        if (!matcher.matches(instance, sourceInstance, matcher.withoutCondition(matchCondition, source.getComponent().getPrimaryQuantifier().getMatchCondition()))) continue;
                        if (matcher.getQuantity(sourceInstance) != prototypeQuantity) {
                            sourceInstance = matcher.withQuantity(sourceInstance, prototypeQuantity);
                        }
                        if (matcher.isEmpty(extractedSimulated = source.extract(sourceInstance, matchCondition, true)) || (remainingQuantity = matcher.getQuantity(remaining = destinationSlotted.insert(destinationSlot, extractedSimulated, true))) != 0L && (remainingQuantity >= prototypeQuantity || matcher.hasCondition(matchCondition, source.getComponent().getPrimaryQuantifier().getMatchCondition())) || (moved = IngredientStorageHelpers.moveEffectiveSourceNonSlottedDestinationExact(source, destinationSlotted, destinationSlot, matchCondition, extractedSimulated, remaining, simulate)) == null) continue;
                        return (T)moved;
                    }
                }
            }
            return (T)matcher.getEmptyInstance();
        } else {
            if (!(source instanceof IIngredientComponentStorageSlotted)) {
                return (T)matcher.getEmptyInstance();
            }
            if (destination instanceof IIngredientComponentStorageSlotted) {
                IIngredientComponentStorageSlotted destinationSlotted = (IIngredientComponentStorageSlotted)destination;
                int slots = destinationSlotted.getSlots();
                for (int slot = 0; slot < slots; ++slot) {
                    T moved = IngredientStorageHelpers.moveIngredientsSlotted(source, sourceSlot, destination, slot, instance, matchCondition, simulate);
                    if (matcher.isEmpty(moved)) continue;
                    return moved;
                }
                return (T)matcher.getEmptyInstance();
            } else {
                IIngredientComponentStorageSlotted sourceSlotted = (IIngredientComponentStorageSlotted)source;
                if (sourceSlot >= sourceSlotted.getSlots()) {
                    return (T)matcher.getEmptyInstance();
                }
                long prototypeQuantity = matcher.getQuantity(instance);
                Object sourceInstance = sourceSlotted.extract(sourceSlot, prototypeQuantity, true);
                if (matcher.isEmpty(sourceInstance) || !matcher.matches(instance, sourceInstance, matchCondition)) return (T)matcher.getEmptyInstance();
                Object inserted = IngredientStorageHelpers.insertIngredient(destination, sourceInstance, true);
                if (!matcher.hasCondition(matchCondition, source.getComponent().getPrimaryQuantifier().getMatchCondition()) || matcher.getQuantity(inserted) == prototypeQuantity) return (T)IngredientStorageHelpers.moveEffectiveSourceExactDestinationNonSlotted(sourceSlotted, sourceSlot, destination, inserted, simulate);
                return (T)matcher.getEmptyInstance();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T, M> T moveIngredientsSlotted(IIngredientComponentStorage<T, M> source, int sourceSlot, IIngredientComponentStorage<T, M> destination, int destinationSlot, Predicate<T> predicate, long maxQuantity, boolean exactQuantity, boolean simulate) throws InconsistentIngredientInsertionException {
        boolean loopDestinationSlots;
        IIngredientMatcher matcher = source.getComponent().getMatcher();
        boolean loopSourceSlots = sourceSlot < 0;
        boolean bl = loopDestinationSlots = destinationSlot < 0;
        if (!loopSourceSlots && !loopDestinationSlots) {
            Object remaining;
            long remainingQuantity;
            if (!(source instanceof IIngredientComponentStorageSlotted)) {
                return (T)matcher.getEmptyInstance();
            }
            if (!(destination instanceof IIngredientComponentStorageSlotted)) {
                return (T)matcher.getEmptyInstance();
            }
            IIngredientComponentStorageSlotted sourceSlotted = (IIngredientComponentStorageSlotted)source;
            IIngredientComponentStorageSlotted destinationSlotted = (IIngredientComponentStorageSlotted)destination;
            if (sourceSlot >= sourceSlotted.getSlots() || destinationSlot >= destinationSlotted.getSlots()) {
                return (T)matcher.getEmptyInstance();
            }
            Object extractedSimulated = sourceSlotted.extract(sourceSlot, maxQuantity, true);
            if (matcher.isEmpty(extractedSimulated) || !predicate.test(extractedSimulated) || exactQuantity && matcher.getQuantity(extractedSimulated) != maxQuantity || (remainingQuantity = matcher.getQuantity(remaining = destinationSlotted.insert(destinationSlot, extractedSimulated, true))) != 0L && (remainingQuantity >= maxQuantity || exactQuantity)) return (T)matcher.getEmptyInstance();
            return (T)IngredientStorageHelpers.moveEffectiveSourceExactDestinationExact(sourceSlotted, sourceSlot, destinationSlotted, destinationSlot, extractedSimulated, remaining, simulate);
        }
        if (loopSourceSlots) {
            if (source instanceof IIngredientComponentStorageSlotted) {
                IIngredientComponentStorageSlotted sourceSlotted = (IIngredientComponentStorageSlotted)source;
                int slots = sourceSlotted.getSlots();
                for (int slot = 0; slot < slots; ++slot) {
                    Object moved = IngredientStorageHelpers.moveIngredientsSlotted(source, slot, destination, destinationSlot, predicate, maxQuantity, exactQuantity, simulate);
                    if (matcher.isEmpty(moved)) continue;
                    return (T)moved;
                }
                return (T)matcher.getEmptyInstance();
            } else if (loopDestinationSlots) {
                if (!exactQuantity || !(destination instanceof IIngredientComponentStorageSlotted)) return (T)IngredientStorageHelpers.moveIngredients(source, destination, predicate, maxQuantity, exactQuantity, simulate);
                IIngredientComponentStorageSlotted destinationSlotted = (IIngredientComponentStorageSlotted)destination;
                int slots = destinationSlotted.getSlots();
                for (int slot = 0; slot < slots; ++slot) {
                    Object moved = IngredientStorageHelpers.moveIngredientsSlotted(source, sourceSlot, destination, slot, predicate, maxQuantity, true, simulate);
                    if (matcher.isEmpty(moved)) continue;
                    return (T)moved;
                }
                return (T)matcher.getEmptyInstance();
            } else {
                if (!(destination instanceof IIngredientComponentStorageSlotted)) {
                    return (T)matcher.getEmptyInstance();
                }
                IIngredientComponentStorageSlotted destinationSlotted = (IIngredientComponentStorageSlotted)destination;
                if (destinationSlot >= destinationSlotted.getSlots()) {
                    return (T)matcher.getEmptyInstance();
                }
                for (Object sourceInstance : source) {
                    Object moved;
                    Object remaining;
                    long remainingQuantity;
                    Object extractedSimulated;
                    if (!predicate.test(sourceInstance)) continue;
                    if (matcher.getQuantity(sourceInstance) != maxQuantity) {
                        sourceInstance = matcher.withQuantity(sourceInstance, maxQuantity);
                    }
                    if (matcher.isEmpty(extractedSimulated = source.extract(sourceInstance, matcher.getExactMatchCondition(), true)) || (remainingQuantity = matcher.getQuantity(remaining = destinationSlotted.insert(destinationSlot, extractedSimulated, true))) != 0L && (remainingQuantity >= maxQuantity || exactQuantity) || (moved = IngredientStorageHelpers.moveEffectiveSourceNonSlottedDestinationExact(source, destinationSlotted, destinationSlot, matcher.getExactMatchCondition(), extractedSimulated, remaining, simulate)) == null) continue;
                    return (T)moved;
                }
            }
            return (T)matcher.getEmptyInstance();
        } else {
            if (!(source instanceof IIngredientComponentStorageSlotted)) {
                return (T)matcher.getEmptyInstance();
            }
            if (destination instanceof IIngredientComponentStorageSlotted) {
                IIngredientComponentStorageSlotted destinationSlotted = (IIngredientComponentStorageSlotted)destination;
                int slots = destinationSlotted.getSlots();
                for (int slot = 0; slot < slots; ++slot) {
                    Object moved = IngredientStorageHelpers.moveIngredientsSlotted(source, sourceSlot, destination, slot, predicate, maxQuantity, exactQuantity, simulate);
                    if (matcher.isEmpty(moved)) continue;
                    return (T)moved;
                }
                return (T)matcher.getEmptyInstance();
            } else {
                IIngredientComponentStorageSlotted sourceSlotted = (IIngredientComponentStorageSlotted)source;
                if (sourceSlot >= sourceSlotted.getSlots()) {
                    return (T)matcher.getEmptyInstance();
                }
                Object sourceInstance = sourceSlotted.extract(sourceSlot, maxQuantity, true);
                if (matcher.isEmpty(sourceInstance) || !predicate.test(sourceInstance)) return (T)matcher.getEmptyInstance();
                Object inserted = IngredientStorageHelpers.insertIngredient(destination, sourceInstance, true);
                if (!exactQuantity || matcher.getQuantity(inserted) == maxQuantity) return (T)IngredientStorageHelpers.moveEffectiveSourceExactDestinationNonSlotted(sourceSlotted, sourceSlot, destination, inserted, simulate);
                return (T)matcher.getEmptyInstance();
            }
        }
    }

    protected static <T, M> T moveEffectiveSourceExactDestinationExact(IIngredientComponentStorageSlotted<T, M> sourceSlotted, int sourceSlot, IIngredientComponentStorageSlotted<T, M> destinationSlotted, int destinationSlot, T extractedSimulated, T remaining, boolean simulate) throws InconsistentIngredientInsertionException {
        IIngredientMatcher matcher = sourceSlotted.getComponent().getMatcher();
        if (simulate) {
            if (matcher.getQuantity(remaining) == 0L) {
                return extractedSimulated;
            }
            return (T)matcher.withQuantity(extractedSimulated, matcher.getQuantity(extractedSimulated) - matcher.getQuantity(remaining));
        }
        long movedQuantitySimulated = matcher.getQuantity(extractedSimulated) - matcher.getQuantity(remaining);
        Object sourceInstanceEffective = sourceSlotted.extract(sourceSlot, movedQuantitySimulated, false);
        if (!matcher.isEmpty(sourceInstanceEffective)) {
            Object remainingEffective = destinationSlotted.insert(destinationSlot, sourceInstanceEffective, false);
            if (matcher.isEmpty(remainingEffective)) {
                return (T)sourceInstanceEffective;
            }
            Object remainderFixup = sourceSlotted.insert(sourceSlot, remainingEffective, false);
            if (!matcher.isEmpty(remainderFixup)) {
                Object movedActual = matcher.withQuantity(remainingEffective, matcher.getQuantity(sourceInstanceEffective) - matcher.getQuantity(remainingEffective) + matcher.getQuantity(remainderFixup));
                throw new InconsistentIngredientInsertionException((IngredientComponent<?, ?>)destinationSlotted.getComponent(), (IIngredientComponentStorage<?, ?>)destinationSlotted, remainderFixup, movedActual);
            }
            return (T)matcher.withQuantity(remainingEffective, matcher.getQuantity(sourceInstanceEffective) - matcher.getQuantity(remainingEffective));
        }
        return (T)matcher.getEmptyInstance();
    }

    protected static <T, M> T moveEffectiveSourceExactDestinationNonSlotted(IIngredientComponentStorageSlotted<T, M> sourceSlotted, int sourceSlot, IIngredientComponentStorage<T, M> destination, T inserted, boolean simulate) throws InconsistentIngredientInsertionException {
        IIngredientMatcher matcher = sourceSlotted.getComponent().getMatcher();
        if (simulate) {
            return inserted;
        }
        if (!matcher.isEmpty(inserted)) {
            Object sourceInstanceEffective = sourceSlotted.extract(sourceSlot, matcher.getQuantity(inserted), false);
            return (T)IngredientStorageHelpers.insertIngredientRemainderFixup(sourceSlotted, destination, sourceInstanceEffective, false);
        }
        return (T)matcher.getEmptyInstance();
    }

    @Nullable
    protected static <T, M> T moveEffectiveSourceNonSlottedDestinationExact(IIngredientComponentStorage<T, M> source, IIngredientComponentStorageSlotted<T, M> destinationSlotted, int destinationSlot, M extractMatchCondition, T extractedSimulated, T remaining, boolean simulate) throws InconsistentIngredientInsertionException {
        IIngredientMatcher matcher = source.getComponent().getMatcher();
        Object shouldMove = matcher.isEmpty(remaining) ? extractedSimulated : matcher.withQuantity(extractedSimulated, matcher.getQuantity(extractedSimulated) - matcher.getQuantity(remaining));
        if (simulate) {
            return shouldMove;
        }
        Object extractedEffective = source.extract(shouldMove, extractMatchCondition, false);
        if (!matcher.isEmpty(extractedSimulated)) {
            Object remainingEffective = destinationSlotted.insert(destinationSlot, extractedEffective, false);
            return (T)IngredientStorageHelpers.handleRemainder(source, destinationSlotted, extractedEffective, remainingEffective);
        }
        return null;
    }

    public static <T, M> T handleRemainder(IIngredientComponentStorage<T, M> source, IIngredientComponentStorage<T, M> destination, T movedEffective, T remainingEffective) throws InconsistentIngredientInsertionException {
        IIngredientMatcher matcher = source.getComponent().getMatcher();
        boolean remainingEffectiveEmpty = matcher.isEmpty(remainingEffective);
        if (remainingEffectiveEmpty) {
            return movedEffective;
        }
        Object remainderFixup = source.insert(remainingEffective, false);
        if (!matcher.isEmpty(remainderFixup)) {
            Object movedActual = matcher.withQuantity(remainingEffective, matcher.getQuantity(remainingEffective) - matcher.getQuantity(remainingEffective) + matcher.getQuantity(remainderFixup));
            throw new InconsistentIngredientInsertionException(destination.getComponent(), destination, remainderFixup, movedActual);
        }
        return (T)matcher.withQuantity(remainingEffective, matcher.getQuantity(movedEffective) - matcher.getQuantity(remainingEffective));
    }

    public static <T, M> T moveIngredient(IIngredientComponentStorage<T, M> source, IIngredientComponentStorage<T, M> destination, T instance, M matchCondition, boolean simulate) throws InconsistentIngredientInsertionException {
        long movableQuantity;
        Object extractedSimulated;
        IIngredientMatcher matcher = source.getComponent().getMatcher();
        if (!matcher.isEmpty(extractedSimulated = source.extract(instance, matchCondition, true)) && (movableQuantity = IngredientStorageHelpers.insertIngredientQuantity(destination, extractedSimulated, true)) > 0L) {
            if (simulate) {
                if (matcher.getQuantity(instance) == movableQuantity) {
                    return (T)extractedSimulated;
                }
                if (matcher.hasCondition(matchCondition, source.getComponent().getPrimaryQuantifier().getMatchCondition())) {
                    return (T)matcher.getEmptyInstance();
                }
                return (T)matcher.withQuantity(extractedSimulated, movableQuantity);
            }
            if (matcher.getQuantity(instance) != movableQuantity && matcher.hasCondition(matchCondition, source.getComponent().getPrimaryQuantifier().getMatchCondition())) {
                return (T)matcher.getEmptyInstance();
            }
            Object extracted = source.extract(matcher.withQuantity(extractedSimulated, movableQuantity), matchCondition, false);
            return (T)IngredientStorageHelpers.insertIngredientRemainderFixup(source, destination, extracted, false);
        }
        return (T)matcher.getEmptyInstance();
    }

    public static <T, M> long insertIngredientQuantity(IIngredientComponentStorage<T, M> destination, T instance, boolean simulate) {
        IIngredientMatcher matcher = destination.getComponent().getMatcher();
        long quantity = matcher.getQuantity(instance);
        if (quantity > 0L) {
            Object remainingInserted = destination.insert(instance, simulate);
            long remainingInsertedQuantity = matcher.getQuantity(remainingInserted);
            return quantity - remainingInsertedQuantity;
        }
        return 0L;
    }

    public static <T, M> T insertIngredient(IIngredientComponentStorage<T, M> destination, T instance, boolean simulate) {
        IIngredientMatcher matcher = destination.getComponent().getMatcher();
        return (T)matcher.withQuantity(instance, IngredientStorageHelpers.insertIngredientQuantity(destination, instance, simulate));
    }

    public static <T, M> T insertIngredientRemainderFixup(IIngredientComponentStorage<T, M> source, IIngredientComponentStorage<T, M> destination, T instance, boolean simulate) throws InconsistentIngredientInsertionException {
        if (simulate) {
            return IngredientStorageHelpers.insertIngredient(destination, instance, true);
        }
        Object remainingEffective = destination.insert(instance, false);
        return (T)IngredientStorageHelpers.handleRemainder(source, destination, instance, remainingEffective);
    }

    public static <T, M> IIngredientComponentStorage<T, M> wrapStorage(IIngredientComponentStorage<T, M> ingredientComponentStorage, boolean read, boolean insert, boolean extract) {
        if (ingredientComponentStorage instanceof IIngredientComponentStorageSlotted) {
            return new IngredientComponentStorageSlottedWrapped((IIngredientComponentStorageSlotted)ingredientComponentStorage, read, insert, extract);
        }
        return new IngredientComponentStorageWrapped<T, M>(ingredientComponentStorage, read, insert, extract);
    }

    public static <T, M> CompoundTag serialize(HolderLookup.Provider lookupProvider, IIngredientComponentStorage<T, M> storage) {
        CompoundTag tag = IngredientCollections.serialize(lookupProvider, new IngredientArrayList(storage.getComponent(), storage.iterator()));
        tag.putLong("maxQuantity", storage.getMaxQuantity());
        tag.putBoolean("slotted", storage instanceof IIngredientComponentStorageSlotted);
        return tag;
    }

    public static IIngredientComponentStorage<?, ?> deserialize(HolderLookup.Provider lookupProvider, CompoundTag tag, long rateLimit) {
        if (!tag.contains("maxQuantity", 4)) {
            throw new IllegalArgumentException("No maxQuantity was found in the given tag");
        }
        if (!tag.contains("slotted", 1)) {
            throw new IllegalArgumentException("No slotted was found in the given tag");
        }
        long maxQuantity = tag.getLong("maxQuantity");
        if (tag.getBoolean("slotted")) {
            return new IngredientComponentStorageSlottedCollectionWrapper(IngredientCollections.deserialize(lookupProvider, tag, IngredientArrayList::new), maxQuantity, rateLimit);
        }
        return new IngredientComponentStorageCollectionWrapper(IngredientCollections.deserialize(lookupProvider, tag, IngredientCollectionHelpers::createCollapsedCollection), maxQuantity, rateLimit);
    }

    public static interface IIngredientStorageConstructor<C extends IIngredientComponentStorage<?, ?>> {
        public <T, M> C create(IngredientComponent<T, M> var1);
    }
}

