/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.gui;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.joml.Vector2fc;
import tv.soaryn.xycraft.api.content.IStage;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContent;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.network.packets.SBMenuComponentMessagePacket;
import tv.soaryn.xycraft.core.ui.BaseMenu;
import tv.soaryn.xycraft.core.ui.BaseMenuUI;
import tv.soaryn.xycraft.core.ui.widgets.callbacks.IClickCallback;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableBackground;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableButton;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableCanvas;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableFluid;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableFrame;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableItem;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableText;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.content.recipes.producers.refinery.RefineryRecipe;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;
import tv.soaryn.xycraft.machines.gui.ProtoMenu;

public class ProtoUI
extends BaseMenuUI<ProtoMenu> {
    private final Context<RefineryRecipe> _context = new Context();

    public ProtoUI(ProtoMenu menu, Inventory playerInv, Component title) {
        super((BaseMenu)menu, playerInv, title, 200, 192);
    }

    protected void init() {
        super.init();
        Player player = Utils.getClientPlayer();
        List allRecipes = Utils.getClientLevel().getRecipeManager().getAllRecipesFor((RecipeType)MachinesRecipeTypes.Refinery.type().get()).stream().sorted((o1, o2) -> {
            if (((RefineryRecipe)o1.value()).getRequiredStage().map(iStage -> iStage.test((Object)player)).orElse(true).booleanValue()) {
                if (((RefineryRecipe)o2.value()).getRequiredStage().map(iStage -> iStage.test((Object)player)).orElse(true).booleanValue()) {
                    String s1 = Component.translatable((String)Util.makeDescriptionId((String)"recipe", (ResourceLocation)o1.id())).getString();
                    String s2 = Component.translatable((String)Util.makeDescriptionId((String)"recipe", (ResourceLocation)o2.id())).getString();
                    return s1.compareToIgnoreCase(s2);
                }
                return 1;
            }
            return 1;
        }).toList();
        this.rootCanvas.addChild(DrawableFrame::create, recipeWindow -> {
            ((DrawableFrame)recipeWindow.dimensions(-100.0f, 0.0f, 100.0f, 0.0f).fillParentVertical()).scale(1.0f, 0.75f);
            recipeWindow.addChild(DrawableBackground::create, BaseMenuUI::backgroundFillWithPlayerColor);
            recipeWindow.addChild(DrawableItem::create, itemA -> {
                itemA.dimensions(12.0f, 12.0f, 16.0f, 16.0f);
                itemA.onRenderTick((widget, graphics, x, y, mouseX, mouseY, depth, time, partialTick) -> {
                    Optional ingredient = ((RefineryRecipe)this._context.Recipe.value()).inputA().right();
                    if (this._context.Recipe != null && this._context.IsResearched && ingredient.isPresent()) {
                        widget.item(((SizedIngredient)ingredient.get()).getItems(), ((SizedIngredient)ingredient.get()).count());
                        widget.Visible = true;
                    } else {
                        widget.Visible = false;
                    }
                });
            });
            recipeWindow.addChild(DrawableFluid::create, fluidA -> {
                fluidA.dimensions(12.0f, 12.0f, 16.0f, 16.0f);
                fluidA.showCapacity(false).showMarkers(false);
                fluidA.onRenderTick((widget, graphics, x, y, mouseX, mouseY, depth, time, partialTick) -> {
                    if (this._context.Recipe != null && this._context.IsResearched) {
                        Optional fluidIngredientOptional = ((RefineryRecipe)this._context.Recipe.value()).inputA().left();
                        if (fluidIngredientOptional.isPresent() && ((SizedFluidIngredient)fluidIngredientOptional.get()).getFluids().length > 0) {
                            widget.fluid(((SizedFluidIngredient)fluidIngredientOptional.get()).getFluids()[0]);
                            widget.Visible = true;
                        } else {
                            widget.Visible = false;
                        }
                    } else {
                        widget.Visible = false;
                    }
                });
            });
            recipeWindow.addChild(DrawableItem::create, itemB -> {
                itemB.dimensions(30.0f, 12.0f, 16.0f, 16.0f);
                itemB.onRenderTick((widget, graphics, x, y, mouseX, mouseY, depth, time, partialTick) -> {
                    if (this._context.Recipe != null && this._context.IsResearched) {
                        widget.item(((RefineryRecipe)this._context.Recipe.value()).inputB().map(Either::right).map(optionalIngredient -> {
                            if (optionalIngredient.isEmpty()) {
                                return ItemStack.EMPTY;
                            }
                            SizedIngredient ingredient = (SizedIngredient)optionalIngredient.get();
                            return ingredient.getItems()[0].copyWithCount(ingredient.count());
                        }).orElse(ItemStack.EMPTY));
                        widget.Visible = true;
                    } else {
                        widget.Visible = false;
                    }
                });
            });
            recipeWindow.addChild(DrawableFluid::create, fluidA -> {
                fluidA.dimensions(30.0f, 12.0f, 16.0f, 16.0f);
                fluidA.showCapacity(false).showMarkers(false);
                fluidA.onRenderTick((widget, graphics, x, y, mouseX, mouseY, depth, time, partialTick) -> {
                    if (this._context.Recipe != null && this._context.IsResearched) {
                        Optional fluidIngredientOptional = ((RefineryRecipe)this._context.Recipe.value()).inputB().flatMap(either -> either.left());
                        if (fluidIngredientOptional.isPresent() && ((SizedFluidIngredient)fluidIngredientOptional.get()).getFluids().length > 0) {
                            widget.fluid(((SizedFluidIngredient)fluidIngredientOptional.get()).getFluids()[0]);
                            widget.Visible = true;
                        } else {
                            widget.Visible = false;
                        }
                    } else {
                        widget.Visible = false;
                    }
                });
            });
            recipeWindow.addChild(DrawableItem::create, itemA -> {
                itemA.dimensions(12.0f, 30.0f, 16.0f, 16.0f);
                itemA.onRenderTick((widget, graphics, x, y, mouseX, mouseY, depth, time, partialTick) -> {
                    if (this._context.Recipe != null && this._context.IsResearched) {
                        widget.item(((RefineryRecipe)this._context.Recipe.value()).outputA().right().orElse(ItemStack.EMPTY));
                        widget.Visible = true;
                    } else {
                        widget.Visible = false;
                    }
                });
            });
            recipeWindow.addChild(DrawableFluid::create, fluidA -> {
                fluidA.dimensions(12.0f, 30.0f, 16.0f, 16.0f);
                fluidA.showCapacity(false).showMarkers(false);
                fluidA.onRenderTick((widget, graphics, x, y, mouseX, mouseY, depth, time, partialTick) -> {
                    if (this._context.Recipe != null && this._context.IsResearched) {
                        FluidStack fluidStack = ((RefineryRecipe)this._context.Recipe.value()).outputA().left().orElse(FluidStack.EMPTY);
                        widget.fluid(fluidStack);
                        widget.Visible = !fluidStack.isEmpty();
                    } else {
                        widget.Visible = false;
                    }
                });
            });
            recipeWindow.addChild(DrawableItem::create, itemB -> {
                itemB.dimensions(30.0f, 30.0f, 16.0f, 16.0f);
                itemB.onRenderTick((widget, graphics, x, y, mouseX, mouseY, depth, time, partialTick) -> {
                    if (this._context.Recipe != null && this._context.IsResearched) {
                        ItemStack item = ((RefineryRecipe)this._context.Recipe.value()).outputB().map(either -> either.right().orElse(ItemStack.EMPTY)).orElse(ItemStack.EMPTY);
                        widget.item(item);
                        widget.Visible = true;
                    } else {
                        widget.Visible = false;
                    }
                });
            });
            recipeWindow.addChild(DrawableFluid::create, fluidB -> {
                fluidB.dimensions(30.0f, 30.0f, 16.0f, 16.0f);
                fluidB.showCapacity(false).showMarkers(false);
                fluidB.onRenderTick((widget, graphics, x, y, mouseX, mouseY, depth, time, partialTick) -> {
                    if (this._context.Recipe != null && this._context.IsResearched) {
                        FluidStack fluidStack = ((RefineryRecipe)this._context.Recipe.value()).outputB().map(either -> either.left().orElse(FluidStack.EMPTY)).orElse(FluidStack.EMPTY);
                        widget.Visible = !fluidStack.isEmpty();
                        widget.fluid(fluidStack);
                    } else {
                        widget.Visible = false;
                    }
                });
            });
            recipeWindow.addChild(DrawableText::create, text -> {
                text.dimensions(16.0f, 16.0f, 80.0f, 100.0f);
                text.onRenderTick((widget, graphics, x, y, mouseX, mouseY, depth, time, partialTick) -> {
                    if (this._context.Recipe == null) {
                        return;
                    }
                    Optional<IStage> optional = ((RefineryRecipe)this._context.Recipe.value()).getRequiredStage();
                    if (!this._context.IsResearched && optional.isPresent()) {
                        text.Visible = true;
                        text.text(optional.get().presentedLabel().getString());
                    } else {
                        text.Visible = false;
                        text.text("");
                    }
                });
            });
        });
        this.rootCanvas.addChild(DrawableFrame::create, frame -> ((DrawableFrame)((DrawableFrame)frame.fillParent()).addChild(DrawableBackground::create, drawableBackground -> ((DrawableBackground)drawableBackground.fillParent()).color(-8912982))).addChild(DrawableCanvas::create, canvas -> {
            ((DrawableCanvas)canvas.dimensions(0.0f, 12.0f, 300.0f, Math.max((float)(allRecipes.size() * 24), canvas.Dimensions.height))).fillParentHorizontal();
            canvas.addChild(DrawableFrame::create, panel -> ((DrawableFrame)panel.fillParent()).addChild(DrawableBackground::create, BaseMenuUI::backgroundFillWithPlayerColor));
            for (int i = 0; i < allRecipes.size(); ++i) {
                this.createRecipeElement((DrawableCanvas)canvas, i, (RecipeHolder<RefineryRecipe>)((RecipeHolder)allRecipes.get(i)));
            }
            canvas.onScroll((widget, mouseX, mouseY, deltaX, deltaY) -> {
                widget.Velocity.y += (float)deltaY;
                return true;
            });
            canvas.onDrag(context -> {
                if (!context.startedInWidget() || context.button() == 0) {
                    return false;
                }
                context.widget().move(0.0f, (float)context.deltaY());
                context.widget().dimensions(context.widget().Dimensions.x, Mth.clamp((float)context.widget().Dimensions.y, (float)(context.widget().Parent.Dimensions.height - 12.0f - context.widget().Dimensions.height), (float)12.0f), context.widget().Dimensions.width, context.widget().Dimensions.height);
                return true;
            });
            canvas.onRenderTick(this::processScrollVelocity);
        }));
    }

    private void processScrollVelocity(DrawableCanvas widget, GuiGraphics graphics, float x, float y, double mouseX, double mouseY, int depth, float time, float partialTick) {
        if (widget.Parent == null || widget.Dimensions.height < widget.Parent.Dimensions.height || widget.isDragging()) {
            return;
        }
        widget.move(widget.Velocity.x, widget.Velocity.y);
        widget.dimensions(widget.Dimensions.x, Mth.clamp((float)widget.Dimensions.y, (float)(widget.Parent.Dimensions.height - 12.0f - widget.Dimensions.height), (float)12.0f), widget.Dimensions.width, widget.Dimensions.height);
        widget.Velocity.add((Vector2fc)widget.Acceleration);
        widget.Acceleration.mul(0.0f);
        widget.Velocity.mul(0.96f);
    }

    private void createRecipeElement(DrawableCanvas canvas, int index, RecipeHolder<RefineryRecipe> holder) {
        Boolean canUse = ((RefineryRecipe)holder.value()).getRequiredStage().map(iStage -> iStage.test((Object)Utils.getClientPlayer())).orElse(true);
        String recipeName = canUse != false ? Component.translatable((String)Util.makeDescriptionId((String)"recipe", (ResourceLocation)holder.id())).getString() : "Locked Recipe";
        int buttonHighlightColor = -12255352;
        int mainTextColor = canUse != false ? -12112 : -7829368;
        int subTextColor = canUse != false ? -8368096 : -13421773;
        canvas.addChild(DrawableCanvas::create, scrollWindow -> {
            scrollWindow.fillParent();
            scrollWindow.addChild(DrawableCanvas::create, element -> {
                ((DrawableCanvas)element.dimensions(0.0f, (float)(index * 24), 0.0f, 24.0f)).fillParentHorizontal();
                element.addChild(DrawableButton::create, button -> ((DrawableButton)((DrawableButton)((DrawableButton)button.fillParent()).setColor(DrawableButton.ButtonLayer.Active, buttonHighlightColor).setColor(DrawableButton.ButtonLayer.Hovered, buttonHighlightColor).onClick((widget, x, y, input, action) -> {
                    if (input != 0 || action != IClickCallback.Action.Down) {
                        return false;
                    }
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    XyCore.Network.send((Packet.ServerBound)new SBMenuComponentMessagePacket(1, new byte[]{(byte)index}));
                    return true;
                })).onToolTip((widget, mouseX, mouseY, tooltip) -> {
                    this._context.Recipe = holder;
                    this._context.IsResearched = canUse;
                })).addChild(DrawableBackground::create, bgrnd -> ((DrawableBackground)((DrawableBackground)bgrnd.texture(null).fillParent()).color(-12237499)).onRenderTick((widget, graphics, x1, y1, mouseX, mouseY, depth, time, partialTick) -> {})));
                if (canUse.booleanValue()) {
                    if (((RefineryRecipe)holder.value()).outputA().right().isPresent()) {
                        element.addChild(DrawableItem::create, itemWidget -> ((DrawableItem)itemWidget.dimensions(26.0f, 4.0f, 16.0f, 16.0f)).showCount(false).item(((RefineryRecipe)holder.value()).outputA().right().orElse(ItemStack.EMPTY)));
                    } else {
                        element.addChild(DrawableFluid::create, fluidWidget -> ((DrawableFluid)fluidWidget.dimensions(26.0f, 4.0f, 16.0f, 16.0f)).fluid(((RefineryRecipe)holder.value()).outputA().left().orElse(FluidStack.EMPTY)).showCapacity(false).showMarkers(false));
                    }
                }
                element.addChild(DrawableText::create, upperText -> ((DrawableText)((DrawableText)upperText.text(recipeName).color(mainTextColor)).dimensions(52.0f, 8.0f, 240.0f, 60.0f)).addChild(DrawableText::create, subText -> ((DrawableText)subText.text(recipeName).color(subTextColor)).fillParent()));
            });
        });
    }

    private static class Context<T extends IRecipeContent<?, T>> {
        public RecipeHolder<T> Recipe;
        public boolean IsResearched = false;

        private Context() {
        }
    }
}

