/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.datagen;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AutoSmeltLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<AutoSmeltLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> AutoSmeltLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, AutoSmeltLootModifier::new)));

    public AutoSmeltLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> originalLoot, @NotNull LootContext context) {
        ObjectArrayList newLoot = new ObjectArrayList();
        originalLoot.forEach(stack -> {
            Optional optional = context.getLevel().getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), (Level)context.getLevel());
            if (optional.isPresent()) {
                SmeltingRecipe recipe = (SmeltingRecipe)((RecipeHolder)optional.get()).value();
                ItemStack smeltedItemStack = recipe.getResultItem((HolderLookup.Provider)context.getLevel().registryAccess());
                if (!smeltedItemStack.isEmpty()) {
                    ItemStack copy = smeltedItemStack.copyWithCount(stack.getCount() * smeltedItemStack.getCount());
                    newLoot.add((Object)copy);
                } else {
                    newLoot.add(stack);
                }
            } else {
                newLoot.add(stack);
            }
        });
        return newLoot;
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

