/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipes.producers.refinery;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IStage;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContainer;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContent;
import tv.soaryn.xycraft.core.content.recipe.IRecipeWithStage;
import tv.soaryn.xycraft.core.content.recipe.RecipeContent;
import tv.soaryn.xycraft.core.content.recipe.RecipeSerDes;
import tv.soaryn.xycraft.core.content.stages.IXyStage;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;
import tv.soaryn.xycraft.core.utils.serialization.Serializer;
import tv.soaryn.xycraft.machines.content.blocks.properties.IOMode;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;

public record RefineryRecipe(Either<SizedFluidIngredient, SizedIngredient> inputA, Optional<Either<SizedFluidIngredient, SizedIngredient>> inputB, Either<FluidStack, ItemStack> outputA, Optional<Either<FluidStack, ItemStack>> outputB, long ticks, Optional<IStage> requiredStage) implements IRecipeContent<Input, RefineryRecipe>,
IRecipeWithStage
{
    private static final MapCodec<RefineryRecipe> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)CodecUtils.Codecs.ContentObjectIngredient.fieldOf("ingredient_a").forGetter(RefineryRecipe::inputA), (App)CodecUtils.Codecs.ContentObjectIngredient.optionalFieldOf("ingredient_b").forGetter(RefineryRecipe::inputB), (App)CodecUtils.Codecs.ContentObject.fieldOf("output_a").forGetter(RefineryRecipe::outputA), (App)CodecUtils.Codecs.ContentObject.optionalFieldOf("output_b").forGetter(RefineryRecipe::outputB), (App)Codec.LONG.fieldOf("ticks").forGetter(RefineryRecipe::ticks), (App)IXyStage.CODEC.optionalFieldOf("stage_required").forGetter(RefineryRecipe::requiredStage)).apply((Applicative)builder, RefineryRecipe::new));
    private static final BinarySerializer<RefineryRecipe> SerDes = BinarySerializer.ofType(RefineryRecipe::new, RefineryRecipe::inputA, (BinarySerializer)RecipeSerDes.InputObjectSerDes, RefineryRecipe::inputB, (BinarySerializer)BinarySerializer.optionalOf((BinarySerializer)RecipeSerDes.InputObjectSerDes), RefineryRecipe::outputA, (BinarySerializer)RecipeSerDes.OutputObjectSerDes, RefineryRecipe::outputB, (BinarySerializer)BinarySerializer.optionalOf((BinarySerializer)RecipeSerDes.OutputObjectSerDes), RefineryRecipe::ticks, (BinarySerializer)Serializer.LONG, RefineryRecipe::requiredStage, (BinarySerializer)BinarySerializer.optionalOf((BinarySerializer)IXyStage.SerDes));

    public static RecipeSerDes<RefineryRecipe> register() {
        return RecipeSerDes.create(codec, SerDes);
    }

    public RecipeContent<RefineryRecipe> getContent() {
        return MachinesRecipeTypes.Refinery;
    }

    public IOMode inputModeA() {
        return this.inputA.left().isPresent() ? IOMode.Fluid : IOMode.Item;
    }

    public IOMode inputModeB() {
        return this.inputB.map(fluidStackItemStackEither -> fluidStackItemStackEither.left().isPresent() ? IOMode.Fluid : IOMode.Item).orElse(IOMode.Empty);
    }

    public IOMode outputModeA() {
        return this.outputA.left().isPresent() ? IOMode.Fluid : IOMode.Item;
    }

    public IOMode outputModeB() {
        return this.outputB.map(fluidStackItemStackEither -> fluidStackItemStackEither.left().isPresent() ? IOMode.Fluid : IOMode.Item).orElse(IOMode.Empty);
    }

    public boolean matches(@NotNull Input input, @NotNull Level level) {
        return (Boolean)this.inputA.map(left -> left.test(input.getInputFluid(0)), right -> right.test(input.getInputItem(0))) != false && this.inputB.map(either -> (Boolean)either.map(left -> left.test(input.getInputFluid(1)), right -> right.test(input.getInputItem(1)))).orElse(true) != false;
    }

    public Optional<IStage> getRequiredStage() {
        return this.requiredStage();
    }

    public static interface Input
    extends IRecipeContainer {
        public ItemStack getInputItem(int var1);

        public FluidStack getInputFluid(int var1);
    }
}

